/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.VariantOutput;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.internal.ide.AaptOptionsImpl;
import com.android.build.gradle.internal.ide.AndroidArtifactImpl;
import com.android.build.gradle.internal.ide.ArtifactDependencyGraph;
import com.android.build.gradle.internal.ide.ArtifactMetaDataImpl;
import com.android.build.gradle.internal.ide.BuildOutputSupplier;
import com.android.build.gradle.internal.ide.BuildOutputsSupplier;
import com.android.build.gradle.internal.ide.BuildTypeContainerImpl;
import com.android.build.gradle.internal.ide.DefaultAndroidProject;
import com.android.build.gradle.internal.ide.DefaultProjectBuildOutput;
import com.android.build.gradle.internal.ide.DefaultTestVariantBuildOutput;
import com.android.build.gradle.internal.ide.DefaultVariantBuildOutput;
import com.android.build.gradle.internal.ide.DependenciesImpl;
import com.android.build.gradle.internal.ide.InstantRunImpl;
import com.android.build.gradle.internal.ide.JavaArtifactImpl;
import com.android.build.gradle.internal.ide.NativeToolchainImpl;
import com.android.build.gradle.internal.ide.ProductFlavorContainerImpl;
import com.android.build.gradle.internal.ide.ProductFlavorImpl;
import com.android.build.gradle.internal.ide.SigningConfigImpl;
import com.android.build.gradle.internal.ide.SourceProviderImpl;
import com.android.build.gradle.internal.ide.SyncIssueImpl;
import com.android.build.gradle.internal.ide.TestOptionsImpl;
import com.android.build.gradle.internal.ide.TestedTargetVariantImpl;
import com.android.build.gradle.internal.ide.VariantImpl;
import com.android.build.gradle.internal.ide.level2.EmptyDependencyGraphs;
import com.android.build.gradle.internal.ide.level2.GlobalLibraryMapImpl;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.model.NativeLibraryFactory;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.Version;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.ProjectBuildOutput;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.TestVariantBuildOutput;
import com.android.builder.model.TestedTargetVariant;
import com.android.builder.model.VariantBuildOutput;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.ide.common.build.ApkInfo;
import com.android.utils.Pair;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class ModelBuilder
implements ToolingModelBuilder {
    static final DependenciesImpl EMPTY_DEPENDENCIES_IMPL = new DependenciesImpl((List<AndroidLibrary>)ImmutableList.of(), (List<JavaLibrary>)ImmutableList.of(), (List<String>)ImmutableList.of());
    static final DependencyGraphs EMPTY_DEPENDENCY_GRAPH = new EmptyDependencyGraphs();
    private final GlobalScope globalScope;
    private final AndroidBuilder androidBuilder;
    private final AndroidConfig config;
    private final ExtraModelInfo extraModelInfo;
    private final VariantManager variantManager;
    private final TaskManager taskManager;
    private final NdkHandler ndkHandler;
    private Map<Abi, NativeToolchain> toolchains;
    private NativeLibraryFactory nativeLibFactory;
    private final int projectType;
    private final int generation;
    private int modelLevel = 0;
    private boolean modelWithFullDependency = false;
    private Set<SyncIssue> syncIssues = Sets.newLinkedHashSet();

    public ModelBuilder(GlobalScope globalScope, AndroidBuilder androidBuilder, VariantManager variantManager, TaskManager taskManager, AndroidConfig config, ExtraModelInfo extraModelInfo, NdkHandler ndkHandler, NativeLibraryFactory nativeLibraryFactory, int projectType, int generation) {
        this.globalScope = globalScope;
        this.androidBuilder = androidBuilder;
        this.config = config;
        this.extraModelInfo = extraModelInfo;
        this.variantManager = variantManager;
        this.taskManager = taskManager;
        this.ndkHandler = ndkHandler;
        this.nativeLibFactory = nativeLibraryFactory;
        this.projectType = projectType;
        this.generation = generation;
    }

    public static void clearCaches() {
        ArtifactDependencyGraph.clearCaches();
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(AndroidProject.class.getName()) || modelName.equals(GlobalLibraryMap.class.getName()) || modelName.equals(ProjectBuildOutput.class.getName());
    }

    public Object buildAll(String modelName, Project project) {
        if (modelName.equals(AndroidProject.class.getName())) {
            return this.buildAndroidProject(project);
        }
        if (modelName.equals(ProjectBuildOutput.class.getName())) {
            return this.buildMinimalisticModel();
        }
        return ModelBuilder.buildGlobalLibraryMap();
    }

    ProjectBuildOutput buildMinimalisticModel() {
        boolean isForTesting;
        ImmutableList.Builder variantsOutput = ImmutableList.builder();
        ArrayListMultimap sortedVariants = ArrayListMultimap.create();
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            isForTesting = variantScope.getVariantData().getType().isForTesting();
            if (!isForTesting || variantScope.getTestedVariantData() == null) continue;
            sortedVariants.put((Object)variantScope.getTestedVariantData().getScope(), (Object)variantScope);
        }
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            isForTesting = variantScope.getVariantData().getType().isForTesting();
            if (isForTesting) continue;
            Collection testingVariants = sortedVariants.get((Object)variantScope);
            Object testVariantBuildOutputs = testingVariants == null ? ImmutableList.of() : (Collection)testingVariants.stream().map(testVariantScope -> new DefaultTestVariantBuildOutput(testVariantScope.getFullVariantName(), (Collection)ModelBuilder.getBuildOutputSupplier(testVariantScope.getVariantData()).get(), variantScope.getFullVariantName(), testVariantScope.getVariantData().getType() == VariantType.ANDROID_TEST ? TestVariantBuildOutput.TestType.ANDROID_TEST : TestVariantBuildOutput.TestType.UNIT)).collect(Collectors.toList());
            variantsOutput.add((Object)new DefaultVariantBuildOutput(variantScope.getFullVariantName(), (Collection)ModelBuilder.getBuildOutputSupplier(variantScope.getVariantData()).get(), (Collection<TestVariantBuildOutput>)testVariantBuildOutputs));
        }
        return new DefaultProjectBuildOutput((ImmutableList<VariantBuildOutput>)variantsOutput.build());
    }

    private static Object buildGlobalLibraryMap() {
        return new GlobalLibraryMapImpl(ArtifactDependencyGraph.getGlobalLibMap());
    }

    private Object buildAndroidProject(Project project) {
        ProjectOptions projectOptions = new ProjectOptions(project);
        Integer modelLevelInt = SyncOptions.buildModelOnlyVersion(projectOptions);
        if (modelLevelInt != null) {
            this.modelLevel = modelLevelInt;
        }
        if (this.modelLevel < 3) {
            throw new RuntimeException("This Gradle plugin requires Studio 3.0 minimum");
        }
        this.modelWithFullDependency = projectOptions.get(BooleanOption.IDE_BUILD_MODEL_FEATURE_FULL_DEPENDENCIES);
        List bootClasspath = this.androidBuilder.getBootClasspathAsStrings(false);
        List<File> frameworkSource = Collections.emptyList();
        ArrayList artifactMetaDataList = Lists.newArrayList(this.extraModelInfo.getExtraArtifacts());
        for (VariantType variantType : VariantType.getTestingTypes()) {
            artifactMetaDataList.add(new ArtifactMetaDataImpl(variantType.getArtifactName(), true, variantType.getArtifactType()));
        }
        com.android.builder.model.LintOptions lintOptions = LintOptions.create(this.config.getLintOptions());
        AaptOptions aaptOptions = AaptOptionsImpl.create(this.config.getAaptOptions());
        this.syncIssues.addAll(this.extraModelInfo.getSyncIssues().values());
        ArrayList flavorDimensionList = this.config.getFlavorDimensionList() != null ? this.config.getFlavorDimensionList() : Lists.newArrayList();
        this.toolchains = ModelBuilder.createNativeToolchainModelMap(this.ndkHandler);
        ProductFlavorContainer defaultConfig = ProductFlavorContainerImpl.createProductFlavorContainer(this.variantManager.getDefaultConfig(), this.extraModelInfo.getExtraFlavorSourceProviders(this.variantManager.getDefaultConfig().getProductFlavor().getName()));
        ArrayList buildTypes = Lists.newArrayList();
        ArrayList productFlavors = Lists.newArrayList();
        ArrayList variants = Lists.newArrayList();
        for (BuildTypeData buildTypeData : this.variantManager.getBuildTypes().values()) {
            buildTypes.add(BuildTypeContainerImpl.create(buildTypeData, this.extraModelInfo.getExtraBuildTypeSourceProviders(buildTypeData.getBuildType().getName())));
        }
        for (ProductFlavorData productFlavorData : this.variantManager.getProductFlavors().values()) {
            productFlavors.add(ProductFlavorContainerImpl.createProductFlavorContainer(productFlavorData, this.extraModelInfo.getExtraFlavorSourceProviders(productFlavorData.getProductFlavor().getName())));
        }
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            if (variantScope.getVariantData().getType().isForTesting()) continue;
            variants.add(this.createVariant(variantScope.getVariantData()));
        }
        return new DefaultAndroidProject(project.getName(), defaultConfig, flavorDimensionList, buildTypes, productFlavors, variants, this.androidBuilder.getTarget() != null ? this.androidBuilder.getTarget().hashString() : "", bootClasspath, frameworkSource, ModelBuilder.cloneSigningConfigs(this.config.getSigningConfigs()), aaptOptions, artifactMetaDataList, this.syncIssues, this.config.getCompileOptions(), lintOptions, project.getBuildDir(), this.config.getResourcePrefix(), (Collection<NativeToolchain>)ImmutableList.copyOf(this.toolchains.values()), this.config.getBuildToolsVersion(), this.projectType, Version.BUILDER_MODEL_API_VERSION, this.generation, this.projectType == 5 && this.config.getBaseFeature() != false);
    }

    public static Map<Abi, NativeToolchain> createNativeToolchainModelMap(NdkHandler ndkHandler) {
        if (!ndkHandler.isConfigured()) {
            return ImmutableMap.of();
        }
        HashMap toolchains = Maps.newHashMap();
        for (Abi abi : ndkHandler.getSupportedAbis()) {
            toolchains.put(abi, new NativeToolchainImpl(ndkHandler.getToolchain().getName() + "-" + abi.getName(), ndkHandler.getCCompiler(abi), ndkHandler.getCppCompiler(abi)));
        }
        return toolchains;
    }

    private VariantImpl createVariant(BaseVariantData variantData) {
        AndroidArtifact mainArtifact = this.createAndroidArtifact("_main_", variantData);
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        String variantName = variantConfiguration.getFullName();
        ArrayList extraAndroidArtifacts = Lists.newArrayList(this.extraModelInfo.getExtraAndroidArtifacts(variantName));
        List<JavaArtifact> clonedExtraJavaArtifacts = this.extraModelInfo.getExtraJavaArtifacts(variantName).stream().map(javaArtifact -> JavaArtifactImpl.clone(javaArtifact, this.modelLevel, this.modelWithFullDependency)).collect(Collectors.toList());
        if (variantData instanceof TestedVariantData) {
            block4: for (VariantType variantType : VariantType.getTestingTypes()) {
                VariantType type;
                TestVariantData testVariantData = ((TestedVariantData)((Object)variantData)).getTestVariantData(variantType);
                if (testVariantData == null || (type = testVariantData.getType()) == null) continue;
                switch (type) {
                    case ANDROID_TEST: {
                        extraAndroidArtifacts.add(this.createAndroidArtifact(variantType.getArtifactName(), testVariantData));
                        continue block4;
                    }
                    case UNIT_TEST: {
                        clonedExtraJavaArtifacts.add(this.createUnitTestsJavaArtifact(variantType, testVariantData));
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("Unsupported test variant type ${variantType}.");
            }
        }
        Collection<TestedTargetVariant> testTargetVariants = this.getTestTargetVariants(variantData);
        return new VariantImpl(variantName, variantConfiguration.getBaseName(), ((CoreBuildType)variantConfiguration.getBuildType()).getName(), ModelBuilder.getProductFlavorNames(variantData), new ProductFlavorImpl(variantConfiguration.getMergedFlavor()), mainArtifact, extraAndroidArtifacts, clonedExtraJavaArtifacts, testTargetVariants);
    }

    private Collection<TestedTargetVariant> getTestTargetVariants(BaseVariantData variantData) {
        if (this.config instanceof TestAndroidConfig) {
            TestAndroidConfig testConfig = (TestAndroidConfig)this.config;
            ArtifactCollection apkArtifacts = variantData.getScope().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST_METADATA);
            ResolvedArtifactResult result = (ResolvedArtifactResult)Iterables.getOnlyElement((Iterable)apkArtifacts.getArtifacts());
            String variant = ArtifactDependencyGraph.getVariant(result);
            return ImmutableList.of((Object)new TestedTargetVariantImpl(testConfig.getTargetProjectPath(), variant));
        }
        return ImmutableList.of();
    }

    private JavaArtifactImpl createUnitTestsJavaArtifact(VariantType variantType, BaseVariantData variantData) {
        SourceProviders sourceProviders = ModelBuilder.determineSourceProviders(variantData);
        List<File> extraGeneratedSourceFolders = variantData.getExtraGeneratedSourceFolders();
        VariantScope scope = variantData.getScope();
        Pair<Dependencies, DependencyGraphs> result = ModelBuilder.getDependencies(scope, this.extraModelInfo, this.syncIssues, this.modelLevel, this.modelWithFullDependency);
        HashSet<File> additionalTestClasses = new HashSet<File>();
        additionalTestClasses.addAll(variantData.getAllPreJavacGeneratedBytecode().getFiles());
        additionalTestClasses.addAll(variantData.getAllPostJavacGeneratedBytecode().getFiles());
        return new JavaArtifactImpl(variantType.getArtifactName(), scope.getAssembleTask().getName(), scope.getCompileTask().getName(), Sets.newHashSet((Object[])new String[]{this.taskManager.createMockableJar.getName()}), extraGeneratedSourceFolders != null ? extraGeneratedSourceFolders : Collections.emptyList(), variantData.javacTask != null ? variantData.javacTask.getDestinationDir() : scope.getJavaOutputDir(), additionalTestClasses, variantData.getJavaResourcesForUnitTesting(), this.globalScope.getMockableAndroidJarFile(), (Dependencies)result.getFirst(), (DependencyGraphs)result.getSecond(), sourceProviders.variantSourceProvider, sourceProviders.multiFlavorSourceProvider);
    }

    public static Pair<Dependencies, DependencyGraphs> getDependencies(VariantScope variantScope, ExtraModelInfo extraModelInfo, Set<SyncIssue> syncIssues, int modelLevel, boolean modelWithFullDependency) {
        Pair result;
        if (extraModelInfo.hasSyncIssue(26)) {
            result = Pair.of((Object)EMPTY_DEPENDENCIES_IMPL, (Object)EMPTY_DEPENDENCY_GRAPH);
        } else {
            boolean downloadSources;
            Project project = variantScope.getGlobalScope().getProject();
            ArtifactDependencyGraph graph = new ArtifactDependencyGraph();
            boolean bl = downloadSources = !project.hasProperty("android.injected.build.model.disable.src.download") || !Boolean.TRUE.equals(project.getProperties().get("android.injected.build.model.disable.src.download"));
            result = modelLevel >= 4 ? Pair.of((Object)EMPTY_DEPENDENCIES_IMPL, (Object)graph.createLevel2DependencyGraph(variantScope, modelWithFullDependency, downloadSources)) : Pair.of((Object)graph.createDependencies(variantScope, downloadSources), (Object)EMPTY_DEPENDENCY_GRAPH);
            graph.collectFailures(syncIssues::add);
        }
        return result;
    }

    private Collection<NativeLibrary> createNativeLibraries(Collection<Abi> abis, VariantScope scope) {
        ArrayList nativeLibraries = Lists.newArrayListWithCapacity((int)abis.size());
        for (Abi abi : abis) {
            Optional<NativeLibrary> lib;
            NativeToolchain toolchain = this.toolchains.get((Object)abi);
            if (toolchain == null || !(lib = this.nativeLibFactory.create(scope, toolchain.getName(), abi)).isPresent()) continue;
            nativeLibraries.add(lib.get());
        }
        return nativeLibraries;
    }

    private AndroidArtifact createAndroidArtifact(String name, BaseVariantData variantData) {
        VariantScope scope = variantData.getScope();
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        CoreSigningConfig signingConfig = variantConfiguration.getSigningConfig();
        String signingConfigName = null;
        if (signingConfig != null) {
            signingConfigName = signingConfig.getName();
        }
        SourceProviders sourceProviders = ModelBuilder.determineSourceProviders(variantData);
        BuildOutputSupplier<Collection<BuildOutput>> splitOutputsProxy = ModelBuilder.getBuildOutputSupplier(variantData);
        BuildOutputSupplier<Collection<BuildOutput>> manifestsProxy = ModelBuilder.getManifestsSupplier(variantData);
        CoreNdkOptions ndkConfig = variantData.getVariantConfiguration().getNdkConfig();
        Object nativeLibraries = ImmutableList.of();
        if (this.ndkHandler.isConfigured()) {
            nativeLibraries = this.config.getSplits().getAbi().isEnable() ? this.createNativeLibraries(this.config.getSplits().getAbi().isUniversalApk() ? this.ndkHandler.getSupportedAbis() : ModelBuilder.createAbiList(this.config.getSplits().getAbiFilters()), scope) : (ndkConfig.getAbiFilters() == null || ndkConfig.getAbiFilters().isEmpty() ? this.createNativeLibraries(this.ndkHandler.getSupportedAbis(), scope) : this.createNativeLibraries(ModelBuilder.createAbiList(ndkConfig.getAbiFilters()), scope));
        }
        InstantRunImpl instantRun = new InstantRunImpl(BuildInfoWriterTask.ConfigAction.getBuildInfoFile(scope), variantConfiguration.getInstantRunSupportStatus());
        Pair<Dependencies, DependencyGraphs> dependencies = ModelBuilder.getDependencies(scope, this.extraModelInfo, this.syncIssues, this.modelLevel, this.modelWithFullDependency);
        HashSet<File> additionalTestClasses = new HashSet<File>();
        additionalTestClasses.addAll(variantData.getAllPreJavacGeneratedBytecode().getFiles());
        additionalTestClasses.addAll(variantData.getAllPostJavacGeneratedBytecode().getFiles());
        ArrayList<File> additionalRuntimeApks = new ArrayList<File>();
        TestOptionsImpl testOptions = null;
        if (variantData.getType().isForTesting()) {
            Configuration testHelpers = (Configuration)scope.getGlobalScope().getProject().getConfigurations().findByName("androidTestUtil");
            if (testHelpers != null) {
                additionalRuntimeApks.addAll(testHelpers.getFiles());
            }
            DeviceProviderInstrumentTestTask.checkForNonApks(additionalRuntimeApks, message -> this.syncIssues.add(new SyncIssueImpl(0, 2, null, (String)message)));
            TestOptions testOptionsDsl = scope.getGlobalScope().getExtension().getTestOptions();
            testOptions = new TestOptionsImpl(testOptionsDsl.getAnimationsDisabled(), testOptionsDsl.getExecutionEnum());
        }
        return new AndroidArtifactImpl(name, scope.getGlobalScope().getProjectBaseName() + "-" + variantConfiguration.getBaseName(), variantData.getTaskByKind(TaskContainer.TaskKind.ASSEMBLE) == null ? scope.getTaskName("assemble") : variantData.getTaskByKind(TaskContainer.TaskKind.ASSEMBLE).getName(), variantConfiguration.isSigningReady() || variantData.outputsAreSigned, signingConfigName, variantConfiguration.getApplicationId(), scope.getSourceGenTask() == null ? scope.getTaskName("generate", "Sources") : scope.getSourceGenTask().getName(), scope.getCompileTask() == null ? scope.getTaskName("compile", "Sources") : scope.getCompileTask().getName(), ModelBuilder.getGeneratedSourceFolders(variantData), ModelBuilder.getGeneratedResourceFolders(variantData), variantData.javacTask != null ? variantData.javacTask.getDestinationDir() : scope.getJavaOutputDir(), additionalTestClasses, scope.getVariantData().getJavaResourcesForUnitTesting(), (Dependencies)dependencies.getFirst(), (DependencyGraphs)dependencies.getSecond(), additionalRuntimeApks, sourceProviders.variantSourceProvider, sourceProviders.multiFlavorSourceProvider, variantConfiguration.getSupportedAbis(), (Collection<NativeLibrary>)nativeLibraries, variantConfiguration.getMergedBuildConfigFields(), variantConfiguration.getMergedResValues(), instantRun, splitOutputsProxy, manifestsProxy, testOptions);
    }

    private static BuildOutputSupplier<Collection<BuildOutput>> getBuildOutputSupplier(BaseVariantData variantData) {
        switch (variantData.getType()) {
            case DEFAULT: 
            case FEATURE: {
                return new BuildOutputsSupplier((List<TaskOutputHolder.OutputType>)ImmutableList.of((Object)TaskOutputHolder.TaskOutputType.APK, (Object)TaskOutputHolder.TaskOutputType.ABI_PACKAGED_SPLIT, (Object)TaskOutputHolder.TaskOutputType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT), (List<File>)ImmutableList.of((Object)variantData.getScope().getApkLocation()));
            }
            case LIBRARY: {
                ApkInfo mainApkInfo = ApkInfo.of((VariantOutput.OutputType)VariantOutput.OutputType.MAIN, (Collection)ImmutableList.of(), (int)0);
                return BuildOutputSupplier.of(ImmutableList.of((Object)new BuildOutput(TaskOutputHolder.TaskOutputType.AAR, mainApkInfo, variantData.getScope().getOutput(TaskOutputHolder.TaskOutputType.AAR).getSingleFile())));
            }
            case ANDROID_TEST: {
                return new BuildOutputsSupplier((List<TaskOutputHolder.OutputType>)ImmutableList.of((Object)TaskOutputHolder.TaskOutputType.APK), (List<File>)ImmutableList.of((Object)variantData.getScope().getApkLocation()));
            }
            case UNIT_TEST: {
                return () -> ImmutableList.of((Object)new BuildOutput(TaskOutputHolder.TaskOutputType.JAVAC, ApkInfo.of((VariantOutput.OutputType)VariantOutput.OutputType.MAIN, (Collection)ImmutableList.of(), (int)variantData.getVariantConfiguration().getVersionCode()), variantData.getScope().getJavaOutputDir()));
            }
        }
        throw new RuntimeException("Unhandled build type " + variantData.getType());
    }

    private static BuildOutputSupplier<Collection<BuildOutput>> getManifestsSupplier(BaseVariantData variantData) {
        switch (variantData.getType()) {
            case ANDROID_TEST: 
            case DEFAULT: 
            case FEATURE: {
                return new BuildOutputsSupplier((List<TaskOutputHolder.OutputType>)ImmutableList.of((Object)TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS), (List<File>)ImmutableList.of((Object)variantData.getScope().getManifestOutputDirectory()));
            }
            case LIBRARY: {
                ApkInfo mainApkInfo = ApkInfo.of((VariantOutput.OutputType)VariantOutput.OutputType.MAIN, (Collection)ImmutableList.of(), (int)0);
                return BuildOutputSupplier.of(ImmutableList.of((Object)new BuildOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, mainApkInfo, new File(variantData.getScope().getManifestOutputDirectory(), "AndroidManifest.xml"))));
            }
        }
        throw new RuntimeException("Unhandled build type " + variantData.getType());
    }

    private static Collection<Abi> createAbiList(Collection<String> abiNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String abiName : abiNames) {
            Abi abi = Abi.getByName(abiName);
            if (abi == null) continue;
            builder.add((Object)abi);
        }
        return builder.build();
    }

    private static SourceProviders determineSourceProviders(BaseVariantData variantData) {
        SourceProvider variantSourceProvider = variantData.getVariantConfiguration().getVariantSourceProvider();
        SourceProvider multiFlavorSourceProvider = variantData.getVariantConfiguration().getMultiFlavorSourceProvider();
        return new SourceProviders(variantSourceProvider != null ? new SourceProviderImpl(variantSourceProvider) : null, multiFlavorSourceProvider != null ? new SourceProviderImpl(multiFlavorSourceProvider) : null);
    }

    private static List<String> getProductFlavorNames(BaseVariantData variantData) {
        return variantData.getVariantConfiguration().getProductFlavors().stream().map(ProductFlavor::getName).collect(Collectors.toList());
    }

    private static List<File> getGeneratedSourceFolders(BaseVariantData variantData) {
        ArrayList folders;
        if (variantData == null) {
            return Collections.emptyList();
        }
        List<File> extraFolders = variantData.getExtraGeneratedSourceFolders();
        if (extraFolders != null) {
            folders = Lists.newArrayListWithExpectedSize((int)(5 + extraFolders.size()));
            folders.addAll(extraFolders);
        } else {
            folders = Lists.newArrayListWithExpectedSize((int)5);
        }
        VariantScope scope = variantData.getScope();
        folders.add(scope.getRClassSourceOutputDir());
        folders.add(scope.getAidlSourceOutputDir());
        folders.add(scope.getBuildConfigSourceOutputDir());
        Boolean ndkMode = variantData.getVariantConfiguration().getMergedFlavor().getRenderscriptNdkModeEnabled();
        if (ndkMode == null || !ndkMode.booleanValue()) {
            folders.add(scope.getRenderscriptSourceOutputDir());
        }
        folders.add(scope.getAnnotationProcessorOutputDir());
        return folders;
    }

    private static List<File> getGeneratedResourceFolders(BaseVariantData variantData) {
        ArrayList result;
        Set extraFolders;
        if (variantData == null) {
            return Collections.emptyList();
        }
        FileCollection extraResFolders = variantData.getExtraGeneratedResFolders();
        Set set = extraFolders = extraResFolders != null ? extraResFolders.getFiles() : null;
        if (extraFolders != null && !extraFolders.isEmpty()) {
            result = Lists.newArrayListWithCapacity((int)(extraFolders.size() + 2));
            result.addAll(extraFolders);
        } else {
            result = Lists.newArrayListWithCapacity((int)2);
        }
        VariantScope scope = variantData.getScope();
        result.add(scope.getRenderscriptResOutputDir());
        result.add(scope.getGeneratedResOutputDir());
        return result;
    }

    private static Collection<SigningConfig> cloneSigningConfigs(Collection<? extends SigningConfig> signingConfigs) {
        return signingConfigs.stream().map(SigningConfigImpl::createSigningConfig).collect(Collectors.toList());
    }

    private static SourceProviderContainer getSourceProviderContainer(Collection<SourceProviderContainer> items, String name) {
        for (SourceProviderContainer item : items) {
            if (!name.equals(item.getArtifactName())) continue;
            return item;
        }
        return null;
    }

    private static class SourceProviders {
        protected SourceProviderImpl variantSourceProvider;
        protected SourceProviderImpl multiFlavorSourceProvider;

        public SourceProviders(SourceProviderImpl variantSourceProvider, SourceProviderImpl multiFlavorSourceProvider) {
            this.variantSourceProvider = variantSourceProvider;
            this.multiFlavorSourceProvider = multiFlavorSourceProvider;
        }
    }
}

