/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderCacheHandler;
import com.android.builder.core.DexOptions;
import com.android.builder.core.ErrorReporter;
import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexArchiveBuilderConfig;
import com.android.builder.dexing.DexArchives;
import com.android.builder.dexing.DexerTool;
import com.android.builder.utils.FileCache;
import com.android.dx.command.dexer.DxContext;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.DexParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.gradle.tooling.BuildException;
import org.gradle.workers.IsolationMode;

public class DexArchiveBuilderTransform
extends Transform {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(DexArchiveBuilderTransform.class);
    public static final int DEFAULT_BUFFER_SIZE_IN_KB = 100;
    public static final int NUMBER_OF_BUCKETS = 5;
    private final DexOptions dexOptions;
    private final ErrorReporter errorReporter;
    final WaitableExecutor executor;
    private final int minSdkVersion;
    private final DexerTool dexer;
    private final DexArchiveBuilderCacheHandler cacheHandler;
    private final boolean useGradleWorkers;
    private final int inBufferSize;
    private final int outBufferSize;
    private final boolean isDebuggable;

    public DexArchiveBuilderTransform(DexOptions dexOptions, ErrorReporter errorReporter, FileCache userLevelCache, int minSdkVersion, DexerTool dexer, boolean useGradleWorkers, Integer inBufferSize, Integer outBufferSize, boolean isDebuggable) {
        this.dexOptions = dexOptions;
        this.errorReporter = errorReporter;
        this.minSdkVersion = minSdkVersion;
        this.dexer = dexer;
        this.executor = WaitableExecutor.useGlobalSharedThreadPool();
        this.cacheHandler = new DexArchiveBuilderCacheHandler(userLevelCache, dexOptions, minSdkVersion, isDebuggable);
        this.useGradleWorkers = useGradleWorkers;
        this.inBufferSize = (inBufferSize == null ? 100 : inBufferSize) * 1024;
        this.outBufferSize = (outBufferSize == null ? 100 : outBufferSize) * 1024;
        this.isDebuggable = isDebuggable;
    }

    public String getName() {
        return "dexBuilder";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE));
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_WITH_IR_FOR_DEXING;
    }

    public Map<String, Object> getParameterInputs() {
        try {
            HashMap params = Maps.newHashMapWithExpectedSize((int)4);
            params.put("optimize", !this.dexOptions.getAdditionalParameters().contains("--no-optimize"));
            params.put("jumbo", this.dexOptions.getJumboMode());
            params.put("min-sdk-version", this.minSdkVersion);
            params.put("dex-builder-tool", this.dexer.name());
            return params;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, IOException, InterruptedException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider, (Object)"Missing output provider.");
        if (this.dexer == DexerTool.D8) {
            logger.info("D8 is used to build dex.", new Object[0]);
        }
        if (this.dexOptions.getAdditionalParameters().contains("--no-optimize")) {
            logger.warning("Disabling dex optimization produces wrong local debug info, b.android.com/82031.", new Object[0]);
        }
        logger.verbose("Task is incremental : %b ", transformInvocation.isIncremental());
        ParsingProcessOutputHandler outputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new DexParser(), Message.Kind.ERROR, (ILogger)logger), new ToolOutputParser((PatternAwareOutputParser)new DexParser(), (ILogger)logger), new MessageReceiver[]{this.errorReporter});
        if (!transformInvocation.isIncremental()) {
            outputProvider.deleteAll();
        }
        ProcessOutput processOutput = null;
        HashMultimap cacheableItems = HashMultimap.create();
        try (ProcessOutput ignored = processOutput = outputHandler.createOutput();){
            for (TransformInput input : transformInvocation.getInputs()) {
                for (DirectoryInput dirInput : input.getDirectoryInputs()) {
                    logger.verbose("Dir input %s", dirInput.getFile().toString());
                    this.convertToDexArchive(transformInvocation.getContext(), (QualifiedContent)dirInput, outputProvider, transformInvocation.isIncremental());
                }
                for (JarInput jarInput : input.getJarInputs()) {
                    logger.verbose("Jar input %s", jarInput.getFile().toString());
                    List<File> dexArchives = this.processJarInput(transformInvocation.getContext(), transformInvocation.isIncremental(), jarInput, outputProvider);
                    cacheableItems.putAll((Object)jarInput, dexArchives);
                }
            }
            if (this.useGradleWorkers) {
                transformInvocation.getContext().getWorkerExecutor().await();
            } else {
                this.executor.waitForTasksWithQuickFail(true);
            }
            if (transformInvocation.isIncremental()) {
                for (TransformInput transformInput : transformInvocation.getInputs()) {
                    for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                        File outputFile = DexArchiveBuilderTransform.getPreDexFolder(outputProvider, directoryInput);
                        DexArchive output = DexArchives.fromInput((Path)outputFile.toPath());
                        Throwable throwable = null;
                        try {
                            for (Map.Entry fileStatusEntry : directoryInput.getChangedFiles().entrySet()) {
                                if (fileStatusEntry.getValue() != Status.REMOVED) continue;
                                Path relativePath = directoryInput.getFile().toPath().relativize(((File)fileStatusEntry.getKey()).toPath());
                                output.removeFile(ClassFileEntry.withDexExtension((Path)relativePath));
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (output == null) continue;
                            if (throwable != null) {
                                try {
                                    output.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            output.close();
                        }
                    }
                }
            }
            if (!cacheableItems.isEmpty()) {
                this.cacheHandler.populateCache((Multimap<QualifiedContent, File>)cacheableItems);
            }
            logger.verbose("Done with all dex archive conversions", new Object[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TransformException((Throwable)e);
        }
        catch (Exception e) {
            throw new TransformException((Throwable)e);
        }
        finally {
            if (processOutput != null) {
                try {
                    outputHandler.handleOutput(processOutput);
                }
                catch (ProcessException processException) {}
            }
        }
    }

    private List<File> processJarInput(Context context, boolean isIncremental, JarInput jarInput, TransformOutputProvider transformOutputProvider) throws Exception {
        if (!isIncremental) {
            if (jarInput.getFile().exists()) {
                return this.convertJarToDexArchive(context, jarInput, transformOutputProvider);
            }
            FileUtils.deleteIfExists((File)jarInput.getFile());
        } else if (jarInput.getStatus() != Status.NOTCHANGED) {
            for (int bucketId = 0; bucketId < 5; ++bucketId) {
                File contentLocation = DexArchiveBuilderTransform.getPreDexJar(transformOutputProvider, jarInput, bucketId);
                FileUtils.deleteIfExists((File)contentLocation);
                if (jarInput.getStatus() == Status.REMOVED) continue;
                FileUtils.mkdirs((File)contentLocation.getParentFile());
            }
            if (jarInput.getStatus() == Status.ADDED || jarInput.getStatus() == Status.CHANGED) {
                return this.convertJarToDexArchive(context, jarInput, transformOutputProvider);
            }
        }
        return ImmutableList.of();
    }

    private List<File> convertJarToDexArchive(Context context, JarInput toConvert, TransformOutputProvider transformOutputProvider) throws Exception {
        File cachedVersion = this.cacheHandler.getCachedVersionIfPresent(toConvert);
        if (cachedVersion == null) {
            return this.convertToDexArchive(context, (QualifiedContent)toConvert, transformOutputProvider, false);
        }
        File outputFile = DexArchiveBuilderTransform.getPreDexJar(transformOutputProvider, toConvert, null);
        Files.copy(cachedVersion.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return ImmutableList.of();
    }

    private static DexArchiveBuilder getDexArchiveBuilder(int minSdkVersion, List<String> dexAdditionalParameters, int inBufferSize, int outBufferSize, DexerTool dexer, boolean isDebuggable) throws IOException {
        DexArchiveBuilder dexArchiveBuilder;
        switch (dexer) {
            case DX: {
                boolean optimizedDex = !dexAdditionalParameters.contains("--no-optimize");
                DxContext dxContext = new DxContext((OutputStream)System.out, (OutputStream)System.err);
                DexArchiveBuilderConfig config = new DexArchiveBuilderConfig(dxContext, optimizedDex, inBufferSize, minSdkVersion, DexerTool.DX, outBufferSize, DexArchiveBuilderCacheHandler.isJumboModeEnabledForDx());
                dexArchiveBuilder = DexArchiveBuilder.createDxDexBuilder((DexArchiveBuilderConfig)config);
                break;
            }
            case D8: {
                dexArchiveBuilder = DexArchiveBuilder.createD8DexBuilder((int)minSdkVersion, (boolean)isDebuggable);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown dexer type: " + dexer.name()));
            }
        }
        return dexArchiveBuilder;
    }

    private List<File> convertToDexArchive(Context context, QualifiedContent input, TransformOutputProvider outputProvider, boolean isIncremental) throws Exception {
        logger.verbose("Dexing {}", input.getFile().getAbsolutePath());
        ImmutableList.Builder dexArchives = ImmutableList.builder();
        for (int bucketId = 0; bucketId < 5; ++bucketId) {
            File preDexOutputFile = DexArchiveBuilderTransform.getPreDexFile(outputProvider, input, bucketId);
            dexArchives.add((Object)preDexOutputFile);
            DexConversionParameters parameters = new DexConversionParameters(input, preDexOutputFile, 5, bucketId, this.minSdkVersion, this.dexOptions.getAdditionalParameters(), this.inBufferSize, this.outBufferSize, this.dexer, this.isDebuggable, isIncremental);
            if (this.useGradleWorkers) {
                context.getWorkerExecutor().submit(DexConversionWorkAction.class, configuration -> {
                    configuration.setIsolationMode(IsolationMode.NONE);
                    configuration.setParams(new Object[]{parameters});
                });
                continue;
            }
            this.executor.execute(() -> {
                new DexConversionWorkAction(parameters).run();
                return null;
            });
        }
        return dexArchives.build();
    }

    private static File getPreDexFile(TransformOutputProvider output, QualifiedContent qualifiedContent, int bucketId) {
        return qualifiedContent.getFile().isDirectory() ? DexArchiveBuilderTransform.getPreDexFolder(output, (DirectoryInput)qualifiedContent) : DexArchiveBuilderTransform.getPreDexJar(output, (JarInput)qualifiedContent, bucketId);
    }

    private static File getPreDexJar(TransformOutputProvider output, JarInput qualifiedContent, Integer bucketId) {
        return output.getContentLocation(qualifiedContent.getName() + (bucketId == null ? "" : "-" + bucketId), (Set)ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE)), qualifiedContent.getScopes(), Format.JAR);
    }

    private static File getPreDexFolder(TransformOutputProvider output, DirectoryInput directoryInput) {
        return FileUtils.mkdirs((File)output.getContentLocation(directoryInput.getName(), (Set)ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE)), directoryInput.getScopes(), Format.DIRECTORY));
    }

    public static class DexConversionWorkAction
    implements Runnable {
        private final DexConversionParameters dexConversionParameters;

        @Inject
        public DexConversionWorkAction(DexConversionParameters dexConversionParameters) {
            this.dexConversionParameters = dexConversionParameters;
        }

        @Override
        public void run() {
            try {
                DexArchiveBuilder dexArchiveBuilder = DexArchiveBuilderTransform.getDexArchiveBuilder(this.dexConversionParameters.minSdkVersion, this.dexConversionParameters.dexAdditionalParameters, this.dexConversionParameters.inBufferSize, this.dexConversionParameters.outBufferSize, this.dexConversionParameters.dexer, this.dexConversionParameters.isDebuggable);
                Path inputPath = this.dexConversionParameters.input.getFile().toPath();
                Predicate<Path> bucketFilter = this.dexConversionParameters::belongsToThisBucket;
                boolean hasIncrementalInfo = this.dexConversionParameters.isDirectoryBased() && this.dexConversionParameters.isIncremental;
                Predicate<Path> toProcess = hasIncrementalInfo ? path -> {
                    File resolved;
                    Map changedFiles = ((DirectoryInput)this.dexConversionParameters.input).getChangedFiles();
                    Status status = (Status)changedFiles.get(resolved = inputPath.resolve((Path)path).toFile());
                    return status == Status.ADDED || status == Status.CHANGED;
                } : path -> true;
                bucketFilter = bucketFilter.and(toProcess);
                try (ClassFileInput input = ClassFileInputs.fromPath((Path)inputPath);){
                    dexArchiveBuilder.convert(input.entries(bucketFilter), Paths.get(new URI(this.dexConversionParameters.output)), this.dexConversionParameters.isDirectoryBased());
                }
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class DexConversionParameters
    implements Serializable {
        private final QualifiedContent input;
        private final String output;
        private final int numberOfBuckets;
        private final int buckedId;
        private final int minSdkVersion;
        private final List<String> dexAdditionalParameters;
        private final int inBufferSize;
        private final int outBufferSize;
        private final DexerTool dexer;
        private final boolean isDebuggable;
        private final boolean isIncremental;

        public DexConversionParameters(QualifiedContent input, File output, int numberOfBuckets, int buckedId, int minSdkVersion, List<String> dexAdditionalParameters, int inBufferSize, int outBufferSize, DexerTool dexer, boolean isDebuggable, boolean isIncremental) {
            this.input = input;
            this.numberOfBuckets = numberOfBuckets;
            this.buckedId = buckedId;
            this.output = output.toURI().toString();
            this.minSdkVersion = minSdkVersion;
            this.dexAdditionalParameters = dexAdditionalParameters;
            this.inBufferSize = inBufferSize;
            this.outBufferSize = outBufferSize;
            this.dexer = dexer;
            this.isDebuggable = isDebuggable;
            this.isIncremental = isIncremental;
        }

        public boolean belongsToThisBucket(Path path) {
            return Math.abs(path.toString().hashCode()) % this.numberOfBuckets == this.buckedId;
        }

        public boolean isDirectoryBased() {
            return this.input instanceof DirectoryInput;
        }
    }
}

