/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.cmake;

import com.android.repository.Revision;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class CmakeUtils {
    private static final String CMAKE_VERSION_LINE_PREFIX = "cmake version ";

    public static Revision getVersion(File cmakeInstallPath) throws IOException {
        String versionString = CmakeUtils.getVersionString(cmakeInstallPath);
        return Revision.parseRevision((String)versionString);
    }

    public static Revision getVersion(String cmakeVersionString) {
        return Revision.parseRevision((String)cmakeVersionString);
    }

    private static String getVersionString(File cmakeInstallPath) throws IOException {
        String versionOutput = CmakeUtils.getCmakeVersionLinePrefix(cmakeInstallPath);
        if (!versionOutput.startsWith(CMAKE_VERSION_LINE_PREFIX)) {
            throw new RuntimeException("Did not recognize stdout line as a cmake version: " + versionOutput);
        }
        return versionOutput.substring(CMAKE_VERSION_LINE_PREFIX.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCmakeVersionLinePrefix(File cmakeInstallPath) throws IOException {
        File cmakeExecutable = new File(cmakeInstallPath, "cmake");
        ProcessBuilder processBuilder = new ProcessBuilder(cmakeExecutable.getAbsolutePath(), "--version");
        processBuilder.redirectErrorStream();
        Process process = processBuilder.start();
        BufferedReader bufferedReader = null;
        try (InputStreamReader inputStreamReader = null;){
            String string;
            block8: {
                inputStreamReader = new InputStreamReader(process.getInputStream());
                try {
                    bufferedReader = new BufferedReader(inputStreamReader);
                    string = bufferedReader.readLine();
                    if (bufferedReader == null) break block8;
                }
                catch (Throwable throwable) {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    throw throwable;
                }
                bufferedReader.close();
            }
            return string;
        }
    }
}

