/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.VariantOutput;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.DslAdaptersKt;
import com.android.build.gradle.internal.scope.OutputFactory;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.variant.FeatureVariantData;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.utils.FileCache;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.CharMatcher;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Set;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class GenerateSplitAbiRes
extends BaseTask {
    private String applicationId;
    private String outputBaseName;
    private String versionName;
    private int versionCode;
    private AaptGeneration aaptGeneration;
    private Set<String> splits;
    private File outputDirectory;
    private boolean debuggable;
    private AaptOptions aaptOptions;
    private OutputScope outputScope;
    private OutputFactory outputFactory;
    private VariantType variantType;
    private VariantScope variantScope;
    private FileCache fileCache;
    private String featureName;

    @Input
    public String getApplicationId() {
        return this.applicationId;
    }

    @Input
    public int getVersionCode() {
        return this.versionCode;
    }

    @Input
    @Optional
    public String getVersionName() {
        return this.versionName;
    }

    @Input
    public String getAaptGeneration() {
        return this.aaptGeneration.name();
    }

    @Input
    public String getOutputBaseName() {
        return this.outputBaseName;
    }

    @Input
    public Set<String> getSplits() {
        return this.splits;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Input
    public boolean isDebuggable() {
        return this.debuggable;
    }

    @Nested
    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    @Input
    @Optional
    public String getFeatureName() {
        return this.featureName;
    }

    @TaskAction
    protected void doFullTaskAction() throws IOException, InterruptedException, ProcessException {
        this.outputScope.deleteAllEntries(TaskOutputHolder.TaskOutputType.ABI_PROCESSED_SPLIT_RES);
        for (String split : this.getSplits()) {
            File resPackageFile = this.getOutputFileForSplit(split);
            ApkData abiApkData = this.outputFactory.addConfigurationSplit(VariantOutput.FilterType.ABI, split, resPackageFile.getName());
            abiApkData.setVersionCode(this.variantScope.getVariantConfiguration().getVersionCode());
            abiApkData.setVersionName(this.variantScope.getVariantConfiguration().getVersionName());
            if (this.variantScope.getVariantData().variantOutputFactory != null) {
                this.variantScope.getVariantData().variantOutputFactory.create(abiApkData);
            }
            File manifestFile = this.generateSplitManifest(split, abiApkData);
            AndroidBuilder builder = this.getBuilder();
            Aapt aapt = AaptGradleFactory.make(this.aaptGeneration, builder, (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)new AaptGradleFactory.FilteringLogger(builder.getLogger())), this.fileCache, true, FileUtils.mkdirs((File)new File(this.variantScope.getIncrementalDir(this.getName()), "aapt-temp")), this.variantScope.getGlobalScope().getExtension().getAaptOptions().getCruncherProcesses());
            AaptPackageConfig.Builder aaptConfig = new AaptPackageConfig.Builder();
            aaptConfig.setManifestFile(manifestFile).setOptions(DslAdaptersKt.convert(this.aaptOptions)).setDebuggable(this.debuggable).setResourceOutputApk(resPackageFile).setVariantType(this.variantType);
            this.getBuilder().processResources(aapt, aaptConfig);
            this.outputScope.addOutputForSplit(TaskOutputHolder.TaskOutputType.ABI_PROCESSED_SPLIT_RES, abiApkData, resPackageFile);
        }
        this.outputScope.save(TaskOutputHolder.TaskOutputType.ABI_PROCESSED_SPLIT_RES, this.outputDirectory);
    }

    File generateSplitManifest(String split, ApkData abiApkData) throws IOException {
        CharMatcher charMatcher = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.is((char)'_')).or(CharMatcher.is((char)'.')).negate();
        String abiName = charMatcher.replaceFrom((CharSequence)split, '_');
        File tmpDirectory = new File(this.outputDirectory, abiName);
        FileUtils.mkdirs((File)tmpDirectory);
        File tmpFile = new File(tmpDirectory, "AndroidManifest.xml");
        String versionNameToUse = abiApkData.getVersionName();
        if (versionNameToUse == null) {
            versionNameToUse = String.valueOf(abiApkData.getVersionCode());
        }
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(tmpFile)), "UTF-8");){
            String encodedSplitName = charMatcher.replaceFrom((CharSequence)((this.featureName != null ? this.featureName + "." : "") + "config." + split), '_');
            fileWriter.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n      package=\"" + this.applicationId + "\"\n      android:versionCode=\"" + abiApkData.getVersionCode() + "\"\n      android:versionName=\"" + versionNameToUse + "\"\n");
            if (this.featureName != null) {
                fileWriter.append("      configForSplit=\"" + this.featureName + "\"\n");
            }
            fileWriter.append("      split=\"" + encodedSplitName + "\"\n      targetABI=\"" + abiName + "\">\n       <uses-sdk android:minSdkVersion=\"21\"/>\n</manifest> ");
            fileWriter.flush();
        }
        return tmpFile;
    }

    private File getOutputFileForSplit(String split) {
        return new File(this.outputDirectory, "resources-" + this.getOutputBaseName() + "-" + split + ".ap_");
    }

    public static class ConfigAction
    implements TaskConfigAction<GenerateSplitAbiRes> {
        private final VariantScope scope;
        private final File outputDirectory;

        public ConfigAction(VariantScope scope, File outputDirectory) {
            this.scope = scope;
            this.outputDirectory = outputDirectory;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("generate", "SplitAbiRes");
        }

        @Override
        public Class<GenerateSplitAbiRes> getType() {
            return GenerateSplitAbiRes.class;
        }

        @Override
        public void execute(GenerateSplitAbiRes generateSplitAbiRes) {
            GradleVariantConfiguration config = this.scope.getVariantConfiguration();
            generateSplitAbiRes.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            generateSplitAbiRes.setVariantName(config.getFullName());
            generateSplitAbiRes.featureName = config.getType() == VariantType.FEATURE && !this.scope.isBaseFeature() ? ((FeatureVariantData)this.scope.getVariantData()).getFeatureName() : null;
            generateSplitAbiRes.versionCode = config.getVersionCode();
            generateSplitAbiRes.versionName = config.getVersionName();
            generateSplitAbiRes.aaptGeneration = AaptGeneration.fromProjectOptions(this.scope.getGlobalScope().getProjectOptions());
            generateSplitAbiRes.fileCache = this.scope.getGlobalScope().getBuildCache();
            generateSplitAbiRes.variantScope = this.scope;
            generateSplitAbiRes.variantType = config.getType();
            generateSplitAbiRes.outputDirectory = this.outputDirectory;
            generateSplitAbiRes.splits = AbiSplitOptions.getAbiFilters(this.scope.getGlobalScope().getExtension().getSplits().getAbiFilters());
            generateSplitAbiRes.outputBaseName = config.getBaseName();
            generateSplitAbiRes.applicationId = config.getApplicationId();
            generateSplitAbiRes.debuggable = config.getBuildType().isDebuggable();
            generateSplitAbiRes.aaptOptions = this.scope.getGlobalScope().getExtension().getAaptOptions();
            generateSplitAbiRes.outputScope = this.scope.getOutputScope();
            generateSplitAbiRes.outputFactory = this.scope.getVariantData().getOutputFactory();
        }
    }
}

