/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.ide.common.res2.FileStatus;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

public abstract class IncrementalTask
extends BaseTask {
    public static final String MARKER_NAME = "build_was_incremental";
    private File incrementalFolder;

    public void setIncrementalFolder(File incrementalFolder) {
        this.incrementalFolder = incrementalFolder;
    }

    @OutputDirectory
    @Optional
    public File getIncrementalFolder() {
        return this.incrementalFolder;
    }

    @Internal
    protected boolean isIncremental() {
        return false;
    }

    protected abstract void doFullTaskAction() throws Exception;

    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws Exception {
    }

    @TaskAction
    void taskAction(IncrementalTaskInputs inputs) throws Exception {
        if (!this.isIncremental() || !inputs.isIncremental()) {
            this.getProject().getLogger().info("Unable do incremental execution: full task run");
            this.doFullTaskAction();
            return;
        }
        this.doIncrementalTaskAction(this.getChangedInputs(inputs));
    }

    private Map<File, FileStatus> getChangedInputs(IncrementalTaskInputs inputs) {
        HashMap changedInputs = Maps.newHashMap();
        inputs.outOfDate(change -> {
            FileStatus status = change.isAdded() ? FileStatus.NEW : FileStatus.CHANGED;
            changedInputs.put(change.getFile(), status);
        });
        inputs.removed(change -> changedInputs.put(change.getFile(), FileStatus.REMOVED));
        return changedInputs;
    }
}

