/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.builder.core.ErrorReporter;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.regex.Pattern;

public class FeatureVariantData
extends ApkVariantData
implements TestedVariantData {
    private static final Pattern FEATURE_REPLACEMENT = Pattern.compile("-");
    private static final Pattern FEATURE_EXCLUSION = Pattern.compile("[^a-zA-Z0-9_]");
    private final Map<VariantType, TestVariantData> testVariants = Maps.newEnumMap(VariantType.class);
    private final String featureName;

    public FeatureVariantData(GlobalScope globalScope, AndroidConfig androidConfig, TaskManager taskManager, GradleVariantConfiguration config, ErrorReporter errorReporter, Recorder recorder) {
        super(globalScope, androidConfig, taskManager, config, errorReporter, recorder);
        String splitName = FEATURE_REPLACEMENT.matcher(this.getScope().getGlobalScope().getProjectBaseName()).replaceAll("_");
        this.featureName = FEATURE_EXCLUSION.matcher(splitName).replaceAll("");
        this.getOutputFactory().addMainApk();
    }

    @Override
    public String getDescription() {
        if (this.getVariantConfiguration().hasFlavors()) {
            return String.format("%s feature split build for flavor %s", this.getCapitalizedBuildTypeName(), this.getCapitalizedFlavorName());
        }
        return String.format("%s feature split build", this.getCapitalizedBuildTypeName());
    }

    @Override
    public TestVariantData getTestVariantData(VariantType type) {
        return this.testVariants.get(type);
    }

    @Override
    public void setTestVariantData(TestVariantData testVariantData, VariantType type) {
        this.testVariants.put(type, testVariantData);
    }

    public String getFeatureName() {
        return this.featureName;
    }
}

