/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.VariantOutput;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.builder.model.ApiVersion;
import com.android.ide.common.build.ApkData;
import com.android.resources.Density;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class CompatibleScreensManifest
extends DefaultAndroidTask {
    private Set<String> screenSizes;
    private File outputFolder;
    private OutputScope outputScope;
    private Supplier<String> minSdkVersion;

    @Input
    public Set<String> getScreenSizes() {
        return this.screenSizes;
    }

    public void setScreenSizes(Set<String> screenSizes) {
        this.screenSizes = screenSizes;
    }

    @Input
    List<ApkData> getSplits() {
        return this.outputScope.getApkDatas();
    }

    @Input
    @Optional
    String getMinSdkVersion() {
        return this.minSdkVersion.get();
    }

    void setMinSdkVersion(Supplier<String> minSdkVersion) {
        this.minSdkVersion = minSdkVersion;
    }

    @OutputDirectory
    File getOutputFolder() {
        return this.outputFolder;
    }

    void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    @TaskAction
    public void generateAll() throws IOException {
        this.outputScope.parallelForEach(TaskOutputHolder.TaskOutputType.COMPATIBLE_SCREEN_MANIFEST, this::generate);
        this.outputScope.save((ImmutableList<TaskOutputHolder.OutputType>)ImmutableList.of((Object)TaskOutputHolder.TaskOutputType.COMPATIBLE_SCREEN_MANIFEST), this.outputFolder);
    }

    public File generate(ApkData apkData) throws IOException {
        String density = apkData.getFilter(VariantOutput.FilterType.DENSITY);
        if (density == null) {
            return null;
        }
        StringBuilder content2 = new StringBuilder();
        content2.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n").append("    package=\"\">\n").append("\n");
        if (this.minSdkVersion.get() != null) {
            content2.append("    <uses-sdk android:minSdkVersion=\"").append(this.minSdkVersion.get()).append("\"/>\n");
        }
        content2.append("    <compatible-screens>\n");
        density = CompatibleScreensManifest.convert(density, Density.XXHIGH, Density.XXXHIGH);
        for (String size : this.getScreenSizes()) {
            content2.append("        <screen android:screenSize=\"").append(size).append("\" android:screenDensity=\"").append(density).append("\" />\n");
        }
        content2.append("    </compatible-screens>\n</manifest>");
        File splitFolder = new File(this.outputFolder, apkData.getDirName());
        FileUtils.mkdirs((File)splitFolder);
        File manifestFile = new File(splitFolder, "AndroidManifest.xml");
        Files.write((CharSequence)content2.toString(), (File)manifestFile, (Charset)Charsets.UTF_8);
        return manifestFile;
    }

    private static String convert(String density, Density ... densitiesToConvert) {
        for (Density densityToConvert : densitiesToConvert) {
            if (!densityToConvert.getResourceValue().equals(density)) continue;
            return Integer.toString(densityToConvert.getDpiValue());
        }
        return density;
    }

    public static class ConfigAction
    implements TaskConfigAction<CompatibleScreensManifest> {
        private final VariantScope scope;
        private final Set<String> screenSizes;

        public ConfigAction(VariantScope scope, Set<String> screenSizes) {
            this.scope = scope;
            this.screenSizes = screenSizes;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("create", "CompatibleScreenManifests");
        }

        @Override
        public Class<CompatibleScreensManifest> getType() {
            return CompatibleScreensManifest.class;
        }

        @Override
        public void execute(CompatibleScreensManifest csmTask) {
            csmTask.outputScope = this.scope.getOutputScope();
            csmTask.setVariantName(this.scope.getFullVariantName());
            csmTask.setScreenSizes(this.screenSizes);
            csmTask.setOutputFolder(this.scope.getCompatibleScreensManifestDirectory());
            GradleVariantConfiguration config = this.scope.getVariantConfiguration();
            csmTask.minSdkVersion = TaskInputHelper.memoize(() -> {
                ApiVersion minSdk = config.getMergedFlavor().getMinSdkVersion();
                return minSdk == null ? null : minSdk.getApiString();
            });
        }
    }
}

