/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.ir;

import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class FastDeployRuntimeExtractorTask
extends DefaultAndroidTask {
    private File outputFile;

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File file) {
        this.outputFile = file;
    }

    @TaskAction
    public void extract() throws IOException {
        URL fdrJar = FastDeployRuntimeExtractorTask.class.getResource("/instant-run/instant-run-server.jar");
        if (fdrJar == null) {
            throw new RuntimeException("Couldn't find Instant-Run runtime library");
        }
        URLConnection urlConnection = fdrJar.openConnection();
        urlConnection.setUseCaches(false);
        Files.createParentDirs((File)this.getOutputFile());
        try (InputStream inputStream = urlConnection.getInputStream();
             JarInputStream jarInputStream = new JarInputStream(inputStream);
             JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.getOutputFile())));){
            ZipEntry entry = jarInputStream.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (FastDeployRuntimeExtractorTask.isValidForPackaging(name)) {
                    ZipEntry copy = new ZipEntry(entry);
                    jarOutputStream.putNextEntry(copy);
                    ByteStreams.copy((InputStream)jarInputStream, (OutputStream)jarOutputStream);
                    jarOutputStream.closeEntry();
                }
                entry = jarInputStream.getNextEntry();
            }
        }
    }

    private static boolean isValidForPackaging(String name) {
        return !name.startsWith("META-INF") && !name.endsWith("AppInfo.class");
    }

    public static class ConfigAction
    implements TaskConfigAction<FastDeployRuntimeExtractorTask> {
        private final InstantRunVariantScope instantRunVariantScope;

        public ConfigAction(InstantRunVariantScope instantRunVariantScope) {
            this.instantRunVariantScope = instantRunVariantScope;
        }

        @Override
        public String getName() {
            return this.instantRunVariantScope.getTransformVariantScope().getTaskName("fastDeploy", "Extractor");
        }

        @Override
        public Class<FastDeployRuntimeExtractorTask> getType() {
            return FastDeployRuntimeExtractorTask.class;
        }

        @Override
        public void execute(FastDeployRuntimeExtractorTask fastDeployRuntimeExtractorTask) {
            fastDeployRuntimeExtractorTask.setVariantName(this.instantRunVariantScope.getFullVariantName());
            fastDeployRuntimeExtractorTask.setOutputFile(this.instantRunVariantScope.getIncrementalRuntimeSupportJar());
        }
    }
}

