/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.BuildSessionImpl;
import com.android.builder.Version;
import com.android.ide.common.util.JvmWideVariable;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.reflect.TypeToken;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.Project;

@ThreadSafe
public final class PluginInitializer {
    private static final ConcurrentMap<String, String> projectToPluginVersionMap = (ConcurrentMap)Verify.verifyNotNull((Object)new JvmWideVariable("PLUGIN_VERSION", "ANDROID_GRADLE_PLUGIN", (TypeToken)new TypeToken<ConcurrentMap<String, String>>(){}, ConcurrentHashMap::new).get());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Project project) {
        BuildSessionImpl.getSingleton().initialize(project.getGradle());
        ConcurrentMap<String, String> concurrentMap = projectToPluginVersionMap;
        synchronized (concurrentMap) {
            PluginInitializer.verifyPluginVersion(projectToPluginVersionMap, project, Version.ANDROID_GRADLE_PLUGIN_VERSION);
        }
        BuildSessionImpl.getSingleton().executeOnceWhenBuildFinished(PluginInitializer.class.getName(), "resetPluginVersionMap", projectToPluginVersionMap::clear);
    }

    static void verifyPluginVersion(ConcurrentMap<String, String> projectToPluginVersionMap, Project project, String pluginVersion) {
        String projectPath = project.getProjectDir().getAbsolutePath();
        Preconditions.checkState((!projectToPluginVersionMap.containsKey(projectPath) ? 1 : 0) != 0, (Object)String.format("Android Gradle plugin %1$s must not be applied to project %2$s since version %3$s was already applied to this project", pluginVersion, projectPath, projectToPluginVersionMap.get(projectPath)));
        projectToPluginVersionMap.put(projectPath, pluginVersion);
        if (projectToPluginVersionMap.values().stream().distinct().count() > 1L) {
            throw new IllegalStateException("Using multiple versions of the plugin in the same build is not allowed.\n\t" + Joiner.on((String)"\n\t").withKeyValueSeparator(" is using Android Gradle plugin ").join(projectToPluginVersionMap));
        }
    }
}

