/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.TransformInput;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;

public class TransformInputUtil {
    public static Collection<File> getAllFiles(Collection<TransformInput> transformInputs) {
        return TransformInputUtil.getAllFiles(transformInputs, true, true);
    }

    public static Collection<File> getDirectories(Collection<TransformInput> transformInputs) {
        return TransformInputUtil.getAllFiles(transformInputs, true, false);
    }

    private static Collection<File> getAllFiles(Collection<TransformInput> transformInputs, boolean includeDirectoryInput, boolean includeJarInput) {
        ImmutableList.Builder inputFiles = ImmutableList.builder();
        for (TransformInput input : transformInputs) {
            if (includeDirectoryInput) {
                for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                    inputFiles.add((Object)directoryInput.getFile());
                }
            }
            if (!includeJarInput) continue;
            for (JarInput jarInput : input.getJarInputs()) {
                inputFiles.add((Object)jarInput.getFile());
            }
        }
        return inputFiles.build();
    }
}

