/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.InstantAppOutputScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.ApplicationId;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class BundleInstantApp
extends DefaultAndroidTask {
    private File bundleDirectory;
    private String bundleName;
    private FileCollection applicationId;
    private FileCollection apkDirectories;

    @TaskAction
    public void taskAction() throws IOException {
        FileUtils.mkdirs((File)this.bundleDirectory);
        File bundleFile = new File(this.bundleDirectory, this.bundleName);
        FileUtils.deleteIfExists((File)bundleFile);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(bundleFile));){
            for (File apkDirectory : this.apkDirectories) {
                Collection<BuildOutput> buildOutputs = BuildOutputs.load(apkDirectory);
                for (BuildOutput buildOutput : buildOutputs) {
                    if (buildOutput.getType() != TaskOutputHolder.TaskOutputType.APK) continue;
                    File apkFile = buildOutput.getOutputFile();
                    FileInputStream fileInputStream = new FileInputStream(apkFile);
                    Throwable throwable = null;
                    try {
                        byte[] inputBuffer = IOUtils.toByteArray((InputStream)fileInputStream);
                        zipOutputStream.putNextEntry(new ZipEntry(apkFile.getName()));
                        zipOutputStream.write(inputBuffer, 0, inputBuffer.length);
                        zipOutputStream.closeEntry();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileInputStream == null) continue;
                        if (throwable != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fileInputStream.close();
                    }
                }
            }
        }
        InstantAppOutputScope instantAppOutputScope = new InstantAppOutputScope(ApplicationId.load(this.applicationId.getSingleFile()).getApplicationId(), bundleFile, this.apkDirectories.getFiles().stream().collect(Collectors.toList()));
        instantAppOutputScope.save(this.bundleDirectory);
    }

    @OutputDirectory
    public File getBundleDirectory() {
        return this.bundleDirectory;
    }

    @Input
    public String getBundleName() {
        return this.bundleName;
    }

    @InputFiles
    public FileCollection getApplicationId() {
        return this.applicationId;
    }

    @InputFiles
    public FileCollection getApkDirectories() {
        return this.apkDirectories;
    }

    public static class ConfigAction
    implements TaskConfigAction<BundleInstantApp> {
        private final VariantScope scope;
        private final File bundleDirectory;

        public ConfigAction(VariantScope scope, File bundleDirectory) {
            this.scope = scope;
            this.bundleDirectory = bundleDirectory;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("package", "InstantAppBundle");
        }

        @Override
        public Class<BundleInstantApp> getType() {
            return BundleInstantApp.class;
        }

        @Override
        public void execute(BundleInstantApp bundleInstantApp) {
            bundleInstantApp.setVariantName(this.scope.getFullVariantName());
            bundleInstantApp.bundleDirectory = this.bundleDirectory;
            bundleInstantApp.bundleName = this.scope.getGlobalScope().getProjectBaseName() + "-" + this.scope.getVariantConfiguration().getBaseName() + ".zip";
            bundleInstantApp.applicationId = this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_APPLICATION_ID_DECLARATION);
            bundleInstantApp.apkDirectories = this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.APK);
        }
    }
}

