/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.external.gson.NativeBuildConfigValue;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreExternalNativeCmakeOptions;
import com.android.build.gradle.internal.dsl.CoreExternalNativeNdkBuildOptions;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.CmakeExternalNativeJsonGeneratorFactory;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.build.gradle.tasks.NdkBuildExternalNativeJsonGenerator;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.ErrorReporter;
import com.android.builder.model.ApiVersion;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;

public abstract class ExternalNativeJsonGenerator {
    private final NdkHandler ndkHandler;
    private final int minSdkVersion;
    protected final String variantName;
    private final Collection<Abi> abis;
    protected final AndroidBuilder androidBuilder;
    private final File makefile;
    private final File sdkFolder;
    private final File ndkFolder;
    private final File soFolder;
    private final File objFolder;
    private final File jsonFolder;
    private final boolean debuggable;
    private final List<String> buildArguments;
    private final List<String> cFlags;
    private final List<String> cppFlags;
    private final List<File> nativeBuildConfigurationsJsons;

    ExternalNativeJsonGenerator(NdkHandler ndkHandler, int minSdkVersion, String variantName, Collection<Abi> abis, AndroidBuilder androidBuilder, File sdkFolder, File ndkFolder, File soFolder, File objFolder, File jsonFolder, File makefile, boolean debuggable, List<String> buildArguments, List<String> cFlags, List<String> cppFlags, List<File> nativeBuildConfigurationsJsons) {
        this.ndkHandler = ndkHandler;
        this.minSdkVersion = minSdkVersion;
        this.variantName = variantName;
        this.abis = abis;
        this.androidBuilder = androidBuilder;
        this.sdkFolder = sdkFolder;
        this.ndkFolder = ndkFolder;
        this.soFolder = soFolder;
        this.objFolder = objFolder;
        this.jsonFolder = jsonFolder;
        this.makefile = makefile;
        this.debuggable = debuggable;
        this.buildArguments = buildArguments == null ? Lists.newArrayList() : buildArguments;
        this.cFlags = cFlags == null ? Lists.newArrayList() : cFlags;
        this.cppFlags = cppFlags == null ? Lists.newArrayList() : cppFlags;
        this.nativeBuildConfigurationsJsons = nativeBuildConfigurationsJsons;
    }

    protected static boolean isWindows() {
        return SdkConstants.CURRENT_PLATFORM == 2;
    }

    private static boolean shouldRebuildJson(File json, String groupName) throws IOException {
        if (!json.exists()) {
            return true;
        }
        NativeBuildConfigValue config = ExternalNativeBuildTaskUtils.getNativeBuildConfigValue(json, groupName);
        if (config.buildFiles != null) {
            long jsonLastModified = Files.getLastModifiedTime(json.toPath(), new LinkOption[0]).toMillis();
            for (File buildFile : config.buildFiles) {
                if (!buildFile.exists()) {
                    return true;
                }
                long buildFileLastModified = Files.getLastModifiedTime(buildFile.toPath(), new LinkOption[0]).toMillis();
                if (buildFileLastModified <= jsonLastModified) continue;
                return true;
            }
        }
        return false;
    }

    public void build() throws IOException, ProcessException {
        this.buildAndPropagateException(false);
    }

    public void build(boolean forceJsonGeneration) {
        try {
            this.diagnostic("building json with force flag %s", forceJsonGeneration);
            this.buildAndPropagateException(forceJsonGeneration);
        }
        catch (IOException | GradleException e) {
            this.androidBuilder.getErrorReporter().handleSyncError(this.variantName, 16, e.getMessage());
        }
        catch (ProcessException e) {
            this.androidBuilder.getErrorReporter().handleSyncError(e.getMessage(), 17, String.format("executing external native build for %s %s", this.getNativeBuildSystem().getName(), this.makefile));
        }
    }

    private void buildAndPropagateException(boolean forceJsonGeneration) throws IOException, ProcessException {
        this.diagnostic("starting JSON generation", new Object[0]);
        this.diagnostic("bringing JSONs up-to-date", new Object[0]);
        Throwable firstException = null;
        for (Abi abi : this.abis) {
            try {
                int abiPlatformVersion = this.ndkHandler.findSuitablePlatformVersion(abi.getName(), this.minSdkVersion);
                this.diagnostic("using platform version %s for ABI %s and min SDK version %s", new Object[]{abiPlatformVersion, abi, this.minSdkVersion});
                File expectedJson = ExternalNativeBuildTaskUtils.getOutputJson(this.getJsonFolder(), abi.getName());
                ProcessInfoBuilder processBuilder = this.getProcessBuilder(abi.getName(), abiPlatformVersion, expectedJson);
                String currentBuildCommand = processBuilder.toString();
                boolean rebuildDueToMissingPreviousCommand = false;
                File commandFile = new File(expectedJson.getParentFile(), String.format("%s_build_command.txt", this.getNativeBuildSystem().getName()));
                boolean rebuildDueToChangeInCommandFile = false;
                if (!commandFile.exists()) {
                    rebuildDueToMissingPreviousCommand = true;
                } else {
                    String previousBuildCommand = com.google.common.io.Files.asCharSource((File)commandFile, (Charset)Charsets.UTF_8).read();
                    if (!previousBuildCommand.equals(currentBuildCommand)) {
                        rebuildDueToChangeInCommandFile = true;
                    }
                }
                boolean generateDueToBuildFileChange = ExternalNativeJsonGenerator.shouldRebuildJson(expectedJson, this.variantName);
                if (forceJsonGeneration || generateDueToBuildFileChange || rebuildDueToMissingPreviousCommand || rebuildDueToChangeInCommandFile) {
                    this.diagnostic("rebuilding JSON %s due to:", expectedJson);
                    if (forceJsonGeneration) {
                        this.diagnostic("- force flag", new Object[0]);
                    }
                    if (generateDueToBuildFileChange) {
                        this.diagnostic("- dependent build file missing or changed", new Object[0]);
                    }
                    if (rebuildDueToMissingPreviousCommand) {
                        this.diagnostic("- missing previous command file %s", commandFile);
                    }
                    if (rebuildDueToChangeInCommandFile) {
                        this.diagnostic("- command changed from previous", new Object[0]);
                    }
                    if (this.jsonFolder.exists()) {
                        this.diagnostic("removing stale contents from '%s'", expectedJson.getParentFile());
                        FileUtils.deletePath((File)expectedJson.getParentFile());
                    }
                    if (expectedJson.getParentFile().mkdirs()) {
                        this.diagnostic("created folder '%s'", expectedJson.getParentFile());
                    }
                    this.diagnostic("executing %s %s", this.getNativeBuildSystem().getName(), processBuilder);
                    String buildOutput = this.executeProcess(abi.getName(), abiPlatformVersion, expectedJson);
                    this.diagnostic("done executing %s", this.getNativeBuildSystem().getName());
                    File outputTextFile = new File(expectedJson.getParentFile(), String.format("%s_build_output.txt", this.getNativeBuildSystem().getName()));
                    this.diagnostic("write build output %s", outputTextFile.getAbsolutePath());
                    com.google.common.io.Files.write((CharSequence)buildOutput, (File)outputTextFile, (Charset)Charsets.UTF_8);
                    this.processBuildOutput(buildOutput, abi.getName(), abiPlatformVersion);
                    if (!expectedJson.exists()) {
                        throw new GradleException(String.format("Expected json generation to create '%s' but it didn't", expectedJson));
                    }
                    this.diagnostic("write command file %s", commandFile.getAbsolutePath());
                    com.google.common.io.Files.write((CharSequence)currentBuildCommand, (File)commandFile, (Charset)Charsets.UTF_8);
                    continue;
                }
                this.diagnostic("JSON '%s' was up-to-date", expectedJson);
            }
            catch (ProcessException | IOException | GradleException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        this.diagnostic("build complete", new Object[0]);
        if (firstException == null) {
            this.diagnostic("build completed without problems", new Object[0]);
            return;
        }
        this.diagnostic("build completed with problems", new Object[0]);
        if (firstException instanceof GradleException) {
            throw (GradleException)firstException;
        }
        if (firstException instanceof IOException) {
            throw (IOException)firstException;
        }
        throw (ProcessException)firstException;
    }

    abstract void processBuildOutput(String var1, String var2, int var3) throws IOException;

    abstract ProcessInfoBuilder getProcessBuilder(String var1, int var2, File var3);

    abstract String executeProcess(String var1, int var2, File var3) throws ProcessException, IOException;

    public abstract NativeBuildSystem getNativeBuildSystem();

    abstract Map<Abi, File> getStlSharedObjectFiles();

    void diagnostic(String format, Object ... args) {
        this.androidBuilder.getLogger().verbose("External native generate JSON " + this.variantName + ": " + format, args);
    }

    void warn(String format, Object ... args) {
        this.androidBuilder.getLogger().warning(format, args);
    }

    List<String> getBaseConfigurationErrors() {
        ArrayList messages = Lists.newArrayList();
        if (!this.getNdkFolder().isDirectory()) {
            messages.add(String.format("NDK not configured (%s).\nDownload the NDK from http://developer.android.com/tools/sdk/ndk/.Then add ndk.dir=path/to/ndk in local.properties.\n(On Windows, make sure you escape backslashes, e.g. C:\\\\ndk rather than C:\\ndk)", this.getNdkFolder()));
        }
        return messages;
    }

    public Collection<NativeBuildConfigValue> readExistingNativeBuildConfigurations() throws IOException {
        List<File> files = this.getNativeBuildConfigurationsJsons();
        this.diagnostic("reading %s JSON files", files.size());
        ArrayList result = Lists.newArrayList();
        ArrayList existing = Lists.newArrayList();
        for (File file : files) {
            if (file.exists()) {
                this.diagnostic("reading JSON file %s", file.getAbsolutePath());
                existing.add(file);
                continue;
            }
            this.diagnostic("using fallback JSON for %s", file.getAbsolutePath());
            NativeBuildConfigValue fallback = new NativeBuildConfigValue();
            fallback.buildFiles = Lists.newArrayList((Object[])new File[]{this.makefile});
            result.add(fallback);
        }
        result.addAll(ExternalNativeBuildTaskUtils.getNativeBuildConfigValues(existing, this.variantName));
        return result;
    }

    private static List<Abi> filterToAvailableAbis(Collection<Abi> supportedAbis, Collection<String> userRequestedAbis, ErrorReporter errorReporter, String variantName) {
        ArrayList requestedButNotAvailable = Lists.newArrayList();
        ArrayList result = Lists.newArrayList();
        for (String abiName : userRequestedAbis) {
            Abi requestedAbi = Abi.getByName(abiName);
            if (requestedAbi == null || !supportedAbis.contains((Object)requestedAbi)) {
                requestedButNotAvailable.add(abiName);
            }
            if (requestedAbi == null) continue;
            result.add(requestedAbi);
        }
        if (!requestedButNotAvailable.isEmpty()) {
            Iterable supportedAbisNames = supportedAbis.stream().map(Abi::getName)::iterator;
            errorReporter.handleSyncError(variantName, 16, String.format("ABIs [%s] are not supported for platform. Supported ABIs are [%s].", Joiner.on((String)", ").join((Iterable)requestedButNotAvailable), Joiner.on((String)", ").join(supportedAbisNames)));
        }
        return result;
    }

    private static Collection<String> getUserRequestedAbiFilters(NativeBuildSystem buildSystem, VariantScope variantScope) {
        Set<String> externalNativeAbiFilters = ExternalNativeJsonGenerator.emptySetToNull(ExternalNativeJsonGenerator.getExternalNativeBuildAbiFilters(buildSystem, variantScope.getVariantConfiguration()));
        Set<String> abiFilters = ExternalNativeJsonGenerator.filterAbis(externalNativeAbiFilters, ExternalNativeJsonGenerator.emptySetToNull(variantScope.getVariantConfiguration().getNdkConfig().getAbiFilters()));
        AndroidConfig extension = variantScope.getGlobalScope().getExtension();
        if (extension.getSplits().getAbi().isEnable()) {
            abiFilters = ExternalNativeJsonGenerator.filterAbis(abiFilters, extension.getSplits().getAbiFilters());
        }
        return abiFilters;
    }

    private static Set<String> emptySetToNull(Set<String> abiFilters) {
        if (abiFilters != null && abiFilters.isEmpty()) {
            return null;
        }
        return abiFilters;
    }

    private static Set<String> filterAbis(Set<String> abis, Set<String> filters) {
        if (filters == null) {
            return abis;
        }
        if (abis == null) {
            return filters;
        }
        return Sets.intersection(abis, filters);
    }

    private static Set<String> getExternalNativeBuildAbiFilters(NativeBuildSystem buildSystem, GradleVariantConfiguration variantConfig) {
        switch (buildSystem) {
            case NDK_BUILD: {
                CoreExternalNativeNdkBuildOptions options = variantConfig.getExternalNativeBuildOptions().getExternalNativeNdkBuildOptions();
                if (options == null) break;
                return (Set)Preconditions.checkNotNull(options.getAbiFilters());
            }
            case CMAKE: {
                CoreExternalNativeCmakeOptions options = variantConfig.getExternalNativeBuildOptions().getExternalNativeCmakeOptions();
                if (options == null) break;
                return (Set)Preconditions.checkNotNull(options.getAbiFilters());
            }
            default: {
                throw new IllegalArgumentException("Unknown ExternalNativeJsonGenerator type");
            }
        }
        return Sets.newHashSet();
    }

    public static ExternalNativeJsonGenerator create(File projectDir, File buildDir, File externalNativeBuildDir, NativeBuildSystem buildSystem, File makefile, AndroidBuilder androidBuilder, SdkHandler sdkHandler, VariantScope scope) {
        Preconditions.checkNotNull((Object)sdkHandler.getSdkFolder(), (Object)"No Android SDK folder found");
        File ndkFolder = sdkHandler.getNdkFolder();
        if (ndkFolder == null || !ndkFolder.isDirectory()) {
            throw new InvalidUserDataException(String.format("NDK not configured. %s\nDownload it with SDK manager.", ndkFolder == null ? "" : ndkFolder));
        }
        BaseVariantData variantData = scope.getVariantData();
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        File intermediates = FileUtils.join((File)scope.getGlobalScope().getIntermediatesDir(), (String[])new String[]{buildSystem.getName(), variantData.getVariantConfiguration().getDirName()});
        File soFolder = new File(intermediates, "lib");
        File externalNativeBuildFolder = ExternalNativeJsonGenerator.findExternalNativeBuildFolder(androidBuilder, projectDir, buildSystem, variantData, buildDir, externalNativeBuildDir);
        File objFolder = new File(intermediates, "obj");
        NdkHandler ndkHandler = scope.getGlobalScope().getNdkHandler();
        ApiVersion minSdkVersion = scope.getVariantData().getVariantConfiguration().getMergedFlavor().getMinSdkVersion();
        int minSdkVersionApiLevel = minSdkVersion == null ? 1 : minSdkVersion.getApiLevel();
        Collection userRequestedAbis = ExternalNativeJsonGenerator.getUserRequestedAbiFilters(buildSystem, scope);
        Collection<Abi> validAbis = userRequestedAbis == null ? ndkHandler.getDefaultAbis() : ExternalNativeJsonGenerator.filterToAvailableAbis(ndkHandler.getSupportedAbis(), userRequestedAbis, androidBuilder.getErrorReporter(), variantData.getName());
        List<File> expectedJsons = ExternalNativeBuildTaskUtils.getOutputJsons(externalNativeBuildFolder, userRequestedAbis == null ? (Collection)ndkHandler.getDefaultAbis().stream().map(Abi::getName).collect(Collectors.toList()) : userRequestedAbis);
        switch (buildSystem) {
            case NDK_BUILD: {
                CoreExternalNativeNdkBuildOptions options = variantConfig.getExternalNativeBuildOptions().getExternalNativeNdkBuildOptions();
                Preconditions.checkNotNull((Object)options, (Object)"NdkBuild options not found");
                return new NdkBuildExternalNativeJsonGenerator(ndkHandler, minSdkVersionApiLevel, variantData.getName(), validAbis, androidBuilder, projectDir, sdkHandler.getSdkFolder(), sdkHandler.getNdkFolder(), soFolder, objFolder, externalNativeBuildFolder, makefile, ((CoreBuildType)variantConfig.getBuildType()).isDebuggable(), options.getArguments(), options.getcFlags(), options.getCppFlags(), expectedJsons);
            }
            case CMAKE: {
                return ExternalNativeJsonGenerator.createCmakeExternalNativeJsonGenerator(variantData, ndkHandler, sdkHandler, minSdkVersionApiLevel, validAbis, androidBuilder, soFolder, objFolder, externalNativeBuildFolder, makefile, expectedJsons);
            }
        }
        throw new IllegalArgumentException("Unknown ExternalNativeJsonGenerator type");
    }

    private static ExternalNativeJsonGenerator createCmakeExternalNativeJsonGenerator(BaseVariantData variantData, NdkHandler ndkHandler, SdkHandler sdkHandler, int minSdkVersionApiLevel, Collection<Abi> validAbis, AndroidBuilder androidBuilder, File soFolder, File objFolder, File externalNativeBuildFolder, File makefile, List<File> expectedJsons) {
        File cmakeExecutable;
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        CoreExternalNativeCmakeOptions options = variantConfig.getExternalNativeBuildOptions().getExternalNativeCmakeOptions();
        Preconditions.checkNotNull((Object)options, (Object)"CMake options not found");
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
        AndroidSdkHandler sdk = AndroidSdkHandler.getInstance((File)sdkHandler.getSdkFolder());
        LocalPackage cmakePackage = sdk.getLatestLocalPackageForPrefix("cmake", null, true, (ProgressIndicator)progress);
        if (cmakePackage == null) {
            sdkHandler.installCMake();
        }
        if (!(cmakeExecutable = ExternalNativeJsonGenerator.getSdkCmakeExecutable(sdkHandler.getSdkFolder())).exists()) {
            throw new InvalidUserDataException(String.format("Failed to find CMake.\nInstall from Android Studio under File/Settings/Appearance & Behavior/System Settings/Android SDK/SDK Tools/CMake.\nExpected CMake executable at %s.", cmakeExecutable));
        }
        try {
            return CmakeExternalNativeJsonGeneratorFactory.createCmakeStrategy(CmakeUtils.getVersion(ExternalNativeJsonGenerator.getCmakeBinFolder(sdkHandler.getSdkFolder())), ndkHandler, minSdkVersionApiLevel, variantData.getName(), validAbis, androidBuilder, sdkHandler.getSdkFolder(), sdkHandler.getNdkFolder(), soFolder, objFolder, externalNativeBuildFolder, makefile, ((CoreBuildType)variantConfig.getBuildType()).isDebuggable(), options.getArguments(), options.getcFlags(), options.getCppFlags(), expectedJsons);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create the Cmake strategy");
        }
    }

    private static File findExternalNativeBuildFolder(AndroidBuilder androidBuilder, File projectDir, NativeBuildSystem buildSystem, BaseVariantData variantData, File buildDir, File externalNativeBuildDir) {
        if (externalNativeBuildDir == null) {
            return FileUtils.join((File)projectDir, (String[])new String[]{".externalNativeBuild", buildSystem.getName(), variantData.getName()});
        }
        File externalNativeBuildPath = FileUtils.join((File)externalNativeBuildDir, (String[])new String[]{buildSystem.getName(), variantData.getName()});
        if (FileUtils.isFileInDirectory((File)externalNativeBuildPath, (File)buildDir)) {
            File invalidPath = externalNativeBuildPath;
            externalNativeBuildPath = FileUtils.join((File)projectDir, (String[])new String[]{".externalNativeBuild", buildSystem.getName(), variantData.getName()});
            androidBuilder.getErrorReporter().handleSyncError("", 16, String.format(Locale.getDefault(), "The selected build staging directory '%s' is a subdirectory of the build directory of the build directory '%s'. Defaulting to '%s' instead.", invalidPath.getAbsolutePath(), buildDir.getAbsolutePath(), externalNativeBuildPath.getAbsolutePath()));
        }
        return externalNativeBuildPath;
    }

    @InputFile
    public File getMakefile() {
        return this.makefile;
    }

    @Input
    public File getObjFolder() {
        return this.objFolder;
    }

    public File getJsonFolder() {
        return this.jsonFolder;
    }

    @Input
    public File getNdkFolder() {
        return this.ndkFolder;
    }

    @Input
    public boolean isDebuggable() {
        return this.debuggable;
    }

    @Optional
    @Input
    public List<String> getBuildArguments() {
        return this.buildArguments;
    }

    @Optional
    @Input
    public List<String> getcFlags() {
        return this.cFlags;
    }

    @Optional
    @Input
    public List<String> getCppFlags() {
        return this.cppFlags;
    }

    @OutputFiles
    public List<File> getNativeBuildConfigurationsJsons() {
        return this.nativeBuildConfigurationsJsons;
    }

    @Input
    public File getSoFolder() {
        return this.soFolder;
    }

    @Input
    public File getSdkFolder() {
        return this.sdkFolder;
    }

    @Input
    Collection<Abi> getAbis() {
        return this.abis;
    }

    protected static File getSdkCmakeExecutable(File sdkFolder) {
        if (ExternalNativeJsonGenerator.isWindows()) {
            return new File(ExternalNativeJsonGenerator.getCmakeBinFolder(sdkFolder), "cmake.exe");
        }
        return new File(ExternalNativeJsonGenerator.getCmakeBinFolder(sdkFolder), "cmake");
    }

    protected static File getCmakeBinFolder(File sdkFolder) {
        return new File(ExternalNativeJsonGenerator.getCmakeFolder(sdkFolder), "bin");
    }

    protected static File getCmakeFolder(File sdkFolder) {
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
        AndroidSdkHandler sdk = AndroidSdkHandler.getInstance((File)sdkFolder);
        LocalPackage cmakePackage = sdk.getLatestLocalPackageForPrefix("cmake", null, true, (ProgressIndicator)progress);
        if (cmakePackage != null) {
            return cmakePackage.getLocation();
        }
        return new File(sdkFolder, "cmake");
    }
}

