/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import android.databinding.tool.DataBindingCompilerArgs;
import com.android.build.VariantOutput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.api.JavaCompileOptions;
import com.android.build.gradle.internal.InstantRunTaskManager;
import com.android.build.gradle.internal.LibraryTaskManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskContainerAdaptor;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.VariantDimensionData;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.coverage.JacocoPlugin;
import com.android.build.gradle.internal.coverage.JacocoReportTask;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.AnnotationProcessorOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.DexOptions;
import com.android.build.gradle.internal.incremental.BuildInfoLoaderTask;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.incremental.InstantRunAnchorTaskConfigAction;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.model.CoreExternalNativeBuild;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.VariantPublishingSpec;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.AndroidTaskRegistry;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.android.build.gradle.internal.scope.DefaultGradlePackagingScope;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.CheckProguardFiles;
import com.android.build.gradle.internal.tasks.DependencyReportTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.ExtractProguardFiles;
import com.android.build.gradle.internal.tasks.ExtractTryWithResourcesSupportJar;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.InstallVariantTask;
import com.android.build.gradle.internal.tasks.LintCompile;
import com.android.build.gradle.internal.tasks.MockableAndroidJarTask;
import com.android.build.gradle.internal.tasks.PlatformAttrExtractorTask;
import com.android.build.gradle.internal.tasks.PrepareLintJar;
import com.android.build.gradle.internal.tasks.SigningReportTask;
import com.android.build.gradle.internal.tasks.SourceSetsTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.TestServerTask;
import com.android.build.gradle.internal.tasks.UninstallTask;
import com.android.build.gradle.internal.tasks.ValidateSigningTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportBuildInfoTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingMergeArtifactsTransform;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.TestDataImpl;
import com.android.build.gradle.internal.transforms.BaseProguardAction;
import com.android.build.gradle.internal.transforms.BuiltInShrinkerTransform;
import com.android.build.gradle.internal.transforms.CustomClassTransform;
import com.android.build.gradle.internal.transforms.DesugarTransform;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransform;
import com.android.build.gradle.internal.transforms.DexMergerTransform;
import com.android.build.gradle.internal.transforms.DexMergerTransformCallable;
import com.android.build.gradle.internal.transforms.DexTransform;
import com.android.build.gradle.internal.transforms.ExternalLibsMergerTransform;
import com.android.build.gradle.internal.transforms.ExtractJarsTransform;
import com.android.build.gradle.internal.transforms.FixStackFramesTransform;
import com.android.build.gradle.internal.transforms.JacocoTransform;
import com.android.build.gradle.internal.transforms.JarMergingTransform;
import com.android.build.gradle.internal.transforms.MainDexListTransform;
import com.android.build.gradle.internal.transforms.MergeJavaResourcesTransform;
import com.android.build.gradle.internal.transforms.MultiDexTransform;
import com.android.build.gradle.internal.transforms.PreDexTransform;
import com.android.build.gradle.internal.transforms.ProGuardTransform;
import com.android.build.gradle.internal.transforms.ProguardConfigurable;
import com.android.build.gradle.internal.transforms.ShrinkResourcesTransform;
import com.android.build.gradle.internal.transforms.StripDebugSymbolTransform;
import com.android.build.gradle.internal.variant.AndroidArtifactVariantData;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.CleanBuildCache;
import com.android.build.gradle.tasks.CompatibleScreensManifest;
import com.android.build.gradle.tasks.CopyOutputs;
import com.android.build.gradle.tasks.ExternalNativeBuildJsonTask;
import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.ExternalNativeCleanTask;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.GenerateResValues;
import com.android.build.gradle.tasks.GenerateSplitAbiRes;
import com.android.build.gradle.tasks.GenerateTestConfig;
import com.android.build.gradle.tasks.InstantRunResourcesApkBuilder;
import com.android.build.gradle.tasks.JavaPreCompileTask;
import com.android.build.gradle.tasks.LintGlobalTask;
import com.android.build.gradle.tasks.LintPerVariantTask;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.MergeManifests;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.PackageSplitAbi;
import com.android.build.gradle.tasks.PackageSplitRes;
import com.android.build.gradle.tasks.PreColdSwapTask;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.ProcessManifest;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.build.gradle.tasks.ShaderCompile;
import com.android.build.gradle.tasks.SplitsDiscovery;
import com.android.build.gradle.tasks.factory.AndroidJavaCompile;
import com.android.build.gradle.tasks.factory.AndroidUnitTest;
import com.android.build.gradle.tasks.factory.JavaCompileConfigAction;
import com.android.build.gradle.tasks.factory.ProcessJavaResConfigAction;
import com.android.build.gradle.tasks.factory.TestServerTaskConfigAction;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DefaultDexOptions;
import com.android.builder.core.VariantType;
import com.android.builder.dexing.DexingType;
import com.android.builder.model.DataBindingOptions;
import com.android.builder.profile.Recorder;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceProvider;
import com.android.builder.testing.api.TestServer;
import com.android.builder.utils.FileCache;
import com.android.ide.common.build.ApkData;
import com.android.manifmerger.ManifestMerger2;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public abstract class TaskManager {
    public static final String DIR_BUNDLES = "bundles";
    public static final String INSTALL_GROUP = "Install";
    public static final String BUILD_GROUP = "build";
    public static final String ANDROID_GROUP = "Android";
    public static final String FEATURE_SUFFIX = "Feature";
    public static final String MAIN_PREBUILD = "preBuild";
    public static final String UNINSTALL_ALL = "uninstallAll";
    public static final String DEVICE_CHECK = "deviceCheck";
    public static final String DEVICE_ANDROID_TEST = "device" + VariantType.ANDROID_TEST.getSuffix();
    public static final String CONNECTED_CHECK = "connectedCheck";
    public static final String CONNECTED_ANDROID_TEST = "connected" + VariantType.ANDROID_TEST.getSuffix();
    public static final String ASSEMBLE_ANDROID_TEST = "assembleAndroidTest";
    public static final String LINT = "lint";
    public static final String EXTRACT_PROGUARD_FILES = "extractProguardFiles";
    protected final Project project;
    protected final ProjectOptions projectOptions;
    protected final AndroidBuilder androidBuilder;
    protected final DataBindingBuilder dataBindingBuilder;
    protected final SdkHandler sdkHandler;
    protected final AndroidConfig extension;
    protected final ToolingModelBuilderRegistry toolingRegistry;
    protected final GlobalScope globalScope;
    protected final Recorder recorder;
    protected final AndroidTaskRegistry androidTasks;
    private final Logger logger;
    private final FileCache buildCache;
    public AndroidTask<MockableAndroidJarTask> createMockableJar;

    public TaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        this.globalScope = globalScope;
        this.project = project;
        this.projectOptions = projectOptions;
        this.androidBuilder = androidBuilder;
        this.dataBindingBuilder = dataBindingBuilder;
        this.sdkHandler = sdkHandler;
        this.extension = extension;
        this.toolingRegistry = toolingRegistry;
        this.recorder = recorder;
        this.logger = Logging.getLogger(this.getClass());
        this.androidTasks = new AndroidTaskRegistry();
        this.buildCache = globalScope.getBuildCache();
    }

    public boolean isComponentModelPlugin() {
        return false;
    }

    public DataBindingBuilder getDataBindingBuilder() {
        return this.dataBindingBuilder;
    }

    public abstract void createTasksForVariantScope(TaskFactory var1, VariantScope var2);

    protected Collection<Object> getNdkBuildable(BaseVariantData variantData) {
        if (variantData.ndkCompileTask == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(variantData.ndkCompileTask);
    }

    public void configureScopeForNdk(VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        scope.setNdkSoFolder(Collections.singleton(new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/lib")));
        File objFolder = new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/obj");
        scope.setNdkObjFolder(objFolder);
        for (Abi abi : NdkHandler.getAbiList()) {
            scope.addNdkDebuggableLibraryFolders(abi, new File(objFolder, "local/" + abi.getName()));
        }
    }

    public void createTasksBeforeEvaluate(TaskFactory tasks) {
        this.androidTasks.create(tasks, UNINSTALL_ALL, (Action<Task>)((Action)uninstallAllTask -> {
            uninstallAllTask.setDescription("Uninstall all applications.");
            uninstallAllTask.setGroup(INSTALL_GROUP);
        }));
        this.androidTasks.create(tasks, DEVICE_CHECK, (Action<Task>)((Action)deviceCheckTask -> {
            deviceCheckTask.setDescription("Runs all device checks using Device Providers and Test Servers.");
            deviceCheckTask.setGroup("verification");
        }));
        this.androidTasks.create(tasks, CONNECTED_CHECK, (Action<Task>)((Action)connectedCheckTask -> {
            connectedCheckTask.setDescription("Runs all device checks on currently connected devices.");
            connectedCheckTask.setGroup("verification");
        }));
        this.androidTasks.create(tasks, MAIN_PREBUILD, (Action<Task>)((Action)task -> {}));
        AndroidTask<ExtractProguardFiles> extractProguardFiles = this.androidTasks.create(tasks, EXTRACT_PROGUARD_FILES, ExtractProguardFiles.class, task -> {});
        extractProguardFiles.dependsOn(tasks, (Object)MAIN_PREBUILD);
        this.androidTasks.create(tasks, new SourceSetsTask.ConfigAction(this.extension));
        this.androidTasks.create(tasks, ASSEMBLE_ANDROID_TEST, (Action<Task>)((Action)assembleAndroidTestTask -> {
            assembleAndroidTestTask.setGroup(BUILD_GROUP);
            assembleAndroidTestTask.setDescription("Assembles all the Test applications.");
        }));
        this.androidTasks.create(tasks, new LintCompile.ConfigAction(this.globalScope));
        if (this.buildCache != null) {
            this.androidTasks.create(tasks, new CleanBuildCache.ConfigAction(this.globalScope));
        }
        this.androidTasks.create(tasks, new TaskConfigAction<ConfigAttrTask>(){

            @Override
            public String getName() {
                return "resolveConfigAttr";
            }

            @Override
            public Class<ConfigAttrTask> getType() {
                return ConfigAttrTask.class;
            }

            @Override
            public void execute(ConfigAttrTask task) {
                task.resolvable = true;
            }
        });
        this.androidTasks.create(tasks, new TaskConfigAction<ConfigAttrTask>(){

            @Override
            public String getName() {
                return "consumeConfigAttr";
            }

            @Override
            public Class<ConfigAttrTask> getType() {
                return ConfigAttrTask.class;
            }

            @Override
            public void execute(ConfigAttrTask task) {
                task.consumable = true;
            }
        });
        this.configureCustomLintChecks(tasks);
    }

    private void configureCustomLintChecks(TaskFactory tasks) {
        Configuration lintChecks = (Configuration)this.project.getConfigurations().maybeCreate("lintChecks");
        lintChecks.setVisible(false);
        lintChecks.setDescription("Configuration to apply external lint check jar");
        lintChecks.setCanBeConsumed(false);
        this.globalScope.setLintChecks(lintChecks);
        File lintJar = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{LINT, "lint.jar"});
        AndroidTask<PrepareLintJar> copyLintTask = this.getAndroidTasks().create(tasks, new PrepareLintJar.ConfigAction(this.globalScope, lintJar));
        this.globalScope.addTaskOutput(TaskOutputHolder.TaskOutputType.LINT_JAR, lintJar, copyLintTask.getName());
    }

    public void configureGlobalLintTask(Collection<VariantScope> variants) {
        TaskContainerAdaptor tasks = new TaskContainerAdaptor(this.project.getTasks());
        List<VariantScope> filteredVariants = variants.stream().filter(TaskManager::isLintVariant).collect(Collectors.toList());
        if (filteredVariants.isEmpty()) {
            return;
        }
        this.androidTasks.create(tasks, new LintGlobalTask.GlobalConfigAction(this.globalScope, filteredVariants));
        tasks.named("check", (Action<? super Task>)((Action)it -> it.dependsOn(new Object[]{LINT})));
        FileCollection lintJarCollection = this.globalScope.getOutput(TaskOutputHolder.TaskOutputType.LINT_JAR);
        File lintJar = lintJarCollection.getSingleFile();
        for (VariantScope scope : variants) {
            scope.addTaskOutput(TaskOutputHolder.TaskOutputType.LINT_JAR, lintJar, "prepareLintJar");
        }
    }

    public void createMockableJarTask(TaskFactory tasks) {
        File mockableJar = this.globalScope.getMockableAndroidJarFile();
        this.createMockableJar = this.androidTasks.create(tasks, new MockableAndroidJarTask.ConfigAction(this.globalScope, mockableJar));
        this.globalScope.addTaskOutput(TaskOutputHolder.TaskOutputType.MOCKABLE_JAR, mockableJar, this.createMockableJar.getName());
    }

    public void createAttrFromAndroidJarTask(TaskFactory tasks) {
        File platformRtxt = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"attr", "R.txt"});
        AndroidTask<PlatformAttrExtractorTask> task = this.androidTasks.create(tasks, new PlatformAttrExtractorTask.ConfigAction(this.globalScope, platformRtxt));
        this.globalScope.addTaskOutput(TaskOutputHolder.TaskOutputType.PLATFORM_R_TXT, platformRtxt, task.getName());
    }

    protected void createDependencyStreams(TaskFactory tasks, VariantScope variantScope) {
        this.handleJacocoDependencies(variantScope);
        TransformManager transformManager = variantScope.getTransformManager();
        transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES)).build());
        transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-res-plus-native").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.RESOURCES, ExtendedContentType.NATIVE_LIBS}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.JAVA_RES)).build());
        transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-native").addContentTypes(TransformManager.CONTENT_NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.JNI)).build());
        if (this.extension.getDataBinding().isEnabled()) {
            transformManager.addStream(OriginalStream.builder(this.project, "sub-project-data-binding").addContentTypes(TransformManager.DATA_BINDING_ARTIFACT).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.DATA_BINDING_ARTIFACT)).build());
            transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-data-binding").addContentTypes(TransformManager.DATA_BINDING_ARTIFACT).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.DATA_BINDING_ARTIFACT)).build());
        }
        transformManager.addStream(OriginalStream.builder(this.project, "sub-projects-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.CLASSES)).build());
        transformManager.addStream(OriginalStream.builder(this.project, "sub-projects-res-plus-native").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.RESOURCES, ExtendedContentType.NATIVE_LIBS}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.JAVA_RES)).build());
        transformManager.addStream(OriginalStream.builder(this.project, "sub-projects-native").addContentTypes(TransformManager.CONTENT_NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.JNI)).build());
        transformManager.addStream(OriginalStream.builder(this.project, "provided-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROVIDED_ONLY).setFileCollection(variantScope.getProvidedOnlyClasspath()).build());
        if (variantScope.getTestedVariantData() != null) {
            BaseVariantData testedVariantData = variantScope.getTestedVariantData();
            VariantScope testedVariantScope = testedVariantData.getScope();
            VariantPublishingSpec testedSpec = testedVariantScope.getPublishingSpec().getTestingSpec(variantScope.getVariantConfiguration().getType());
            VariantPublishingSpec.OutputPublishingSpec taskOutputSpec = testedSpec.getSpec(AndroidArtifacts.ArtifactType.CLASSES);
            TaskOutputHolder.OutputType testedOutputType = taskOutputSpec.getOutputType();
            transformManager.addStream(OriginalStream.builder(this.project, "tested-code-classes").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.TESTED_CODE).setFileCollection(testedVariantScope.getOutput(testedOutputType)).build());
            transformManager.addStream(OriginalStream.builder(this.project, "tested-code-deps").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.TESTED_CODE).setArtifactCollection(testedVariantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES)).build());
        }
    }

    public void createMergeApkManifestsTask(TaskFactory tasks, VariantScope variantScope) {
        AndroidArtifactVariantData androidArtifactVariantData = (AndroidArtifactVariantData)variantScope.getVariantData();
        Set<String> screenSizes = androidArtifactVariantData.getCompatibleScreens();
        AndroidTask<CompatibleScreensManifest> csmTask = this.androidTasks.create(tasks, new CompatibleScreensManifest.ConfigAction(variantScope, screenSizes));
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.COMPATIBLE_SCREEN_MANIFEST, variantScope.getCompatibleScreensManifestDirectory(), csmTask.getName());
        ImmutableList.Builder optionalFeatures = ImmutableList.builder();
        if (variantScope.isTestOnly()) {
            optionalFeatures.add((Object)ManifestMerger2.Invoker.Feature.TEST_ONLY);
        }
        if (((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable()) {
            optionalFeatures.add((Object)ManifestMerger2.Invoker.Feature.DEBUGGABLE);
        }
        if (!TaskManager.getAdvancedProfilingTransforms(this.projectOptions).isEmpty() && ((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable()) {
            optionalFeatures.add((Object)ManifestMerger2.Invoker.Feature.ADVANCED_PROFILING);
        }
        AndroidTask<? extends ManifestProcessorTask> processManifestTask = this.createMergeManifestTask(tasks, variantScope, (ImmutableList.Builder<ManifestMerger2.Invoker.Feature>)optionalFeatures);
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, variantScope.getManifestOutputDirectory(), processManifestTask.getName());
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.MANIFEST_METADATA, BuildOutputs.getMetadataFile(variantScope.getManifestOutputDirectory()), processManifestTask.getName());
        variantScope.setManifestProcessorTask(processManifestTask);
        processManifestTask.dependsOn(tasks, variantScope.getCheckManifestTask());
        if (variantScope.getMicroApkTask() != null) {
            processManifestTask.dependsOn(tasks, variantScope.getMicroApkTask());
        }
    }

    private static List<String> getAdvancedProfilingTransforms(ProjectOptions options) {
        String string = options.get(StringOption.IDE_ANDROID_CUSTOM_CLASS_TRANSFORMS);
        if (string == null) {
            return ImmutableList.of();
        }
        return Splitter.on((char)',').splitToList((CharSequence)string);
    }

    private static File computeManifestReportFile(VariantScope variantScope) {
        return FileUtils.join((File)variantScope.getGlobalScope().getOutputsDir(), (String[])new String[]{"logs", "manifest-merger-" + variantScope.getVariantConfiguration().getBaseName() + "-report.txt"});
    }

    protected AndroidTask<? extends ManifestProcessorTask> createMergeManifestTask(TaskFactory tasks, VariantScope variantScope, ImmutableList.Builder<ManifestMerger2.Invoker.Feature> optionalFeatures) {
        if (variantScope.getVariantConfiguration().isInstantRunBuild(this.globalScope)) {
            optionalFeatures.add((Object)ManifestMerger2.Invoker.Feature.INSTANT_RUN_REPLACEMENT);
        }
        File reportFile = TaskManager.computeManifestReportFile(variantScope);
        AndroidTask<MergeManifests> mergeManifestsAndroidTask = this.androidTasks.create(tasks, new MergeManifests.ConfigAction(variantScope, (List<ManifestMerger2.Invoker.Feature>)optionalFeatures.build(), reportFile));
        String name = mergeManifestsAndroidTask.getName();
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS, variantScope.getInstantRunManifestOutputDirectory(), name);
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.MANIFEST_MERGE_REPORT, reportFile, name);
        return mergeManifestsAndroidTask;
    }

    public AndroidTask<ProcessManifest> createMergeLibManifestsTask(TaskFactory tasks, VariantScope scope) {
        File libraryProcessedManifest = new File(scope.getManifestOutputDirectory(), "AndroidManifest.xml");
        File reportFile = TaskManager.computeManifestReportFile(scope);
        AndroidTask<ProcessManifest> processManifest = this.androidTasks.create(tasks, new ProcessManifest.ConfigAction(scope, libraryProcessedManifest, reportFile));
        String taskName = processManifest.getName();
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, scope.getManifestOutputDirectory(), taskName);
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.AAPT_FRIENDLY_MERGED_MANIFESTS, scope.getAaptFriendlyManifestOutputDirectory(), taskName);
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.LIBRARY_MANIFEST, libraryProcessedManifest, taskName);
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.MANIFEST_MERGE_REPORT, reportFile, taskName);
        processManifest.dependsOn(tasks, scope.getCheckManifestTask());
        scope.setManifestProcessorTask(processManifest);
        return processManifest;
    }

    protected void createProcessTestManifestTask(TaskFactory tasks, VariantScope scope, VariantScope testedScope) {
        AndroidTask<ProcessTestManifest> processTestManifestTask = this.androidTasks.create(tasks, new ProcessTestManifest.ConfigAction(scope, testedScope.getOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS)));
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, scope.getManifestOutputDirectory(), processTestManifestTask.getName());
        processTestManifestTask.optionalDependsOn(tasks, scope.getCheckManifestTask());
        scope.setManifestProcessorTask(processTestManifestTask);
    }

    public void createRenderscriptTask(TaskFactory tasks, VariantScope scope) {
        scope.setRenderscriptCompileTask(this.androidTasks.create(tasks, new RenderscriptCompile.ConfigAction(scope)));
        GradleVariantConfiguration config = scope.getVariantConfiguration();
        if (config.getType().isForTesting()) {
            scope.getRenderscriptCompileTask().dependsOn(tasks, scope.getManifestProcessorTask());
        } else {
            scope.getRenderscriptCompileTask().dependsOn(tasks, scope.getPreBuildTask());
        }
        scope.getResourceGenTask().dependsOn(tasks, scope.getRenderscriptCompileTask());
        if (!config.getRenderscriptNdkModeEnabled()) {
            scope.getSourceGenTask().dependsOn(tasks, scope.getRenderscriptCompileTask());
        }
    }

    public AndroidTask<MergeResources> createMergeResourcesTask(TaskFactory tasks, VariantScope scope, boolean processResources) {
        boolean alsoOutputNotCompiledResources = scope.useResourceShrinker() || this.globalScope.getExtension().getTestOptions().getUnitTests().isIncludeAndroidResources();
        AndroidTask<MergeResources> task = this.basicCreateMergeResourcesTask(tasks, scope, MergeType.MERGE, null, true, processResources, alsoOutputNotCompiledResources);
        return task;
    }

    public AndroidTask<MergeResources> basicCreateMergeResourcesTask(TaskFactory tasks, VariantScope scope, MergeType mergeType, File outputLocation, boolean includeDependencies, boolean processResources, boolean alsoOutputNotCompiledResources) {
        File mergedOutputDir = (File)MoreObjects.firstNonNull((Object)outputLocation, (Object)scope.getDefaultMergeResourcesOutputDir());
        String taskNamePrefix = mergeType.name().toLowerCase(Locale.ENGLISH);
        File mergedNotCompiledDir = alsoOutputNotCompiledResources ? new File(this.globalScope.getIntermediatesDir() + "/merged-not-compiled-resources/" + scope.getVariantConfiguration().getDirName()) : null;
        AndroidTask<MergeResources> mergeResourcesTask = this.androidTasks.create(tasks, new MergeResources.ConfigAction(scope, taskNamePrefix, mergedOutputDir, mergedNotCompiledDir, includeDependencies, processResources));
        scope.addTaskOutput(mergeType.getOutputType(), mergedOutputDir, mergeResourcesTask.getName());
        if (alsoOutputNotCompiledResources) {
            scope.addTaskOutput(TaskOutputHolder.TaskOutputType.MERGED_NOT_COMPILED_RES, mergedNotCompiledDir, mergeResourcesTask.getName());
        }
        mergeResourcesTask.dependsOn(tasks, scope.getResourceGenTask());
        scope.setMergeResourcesTask(mergeResourcesTask);
        scope.setResourceOutputDir(mergedOutputDir);
        scope.setMergeResourceOutputDir(outputLocation);
        return scope.getMergeResourcesTask();
    }

    public AndroidTask<MergeSourceSetFolders> createMergeAssetsTask(TaskFactory tasks, VariantScope scope, BiConsumer<AndroidTask<MergeSourceSetFolders>, File> consumer) {
        GradleVariantConfiguration variantConfiguration = scope.getVariantConfiguration();
        File outputDir = variantConfiguration.isBundled() ? new File(scope.getBaseBundleDir(), "assets") : FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"assets", variantConfiguration.getDirName()});
        AndroidTask<MergeSourceSetFolders> mergeAssetsTask = this.androidTasks.create(tasks, new MergeSourceSetFolders.MergeAssetConfigAction(scope, outputDir));
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.MERGED_ASSETS, outputDir, mergeAssetsTask.getName());
        if (consumer != null) {
            consumer.accept(mergeAssetsTask, outputDir);
        }
        mergeAssetsTask.dependsOn(tasks, scope.getAssetGenTask());
        scope.setMergeAssetsTask(mergeAssetsTask);
        return mergeAssetsTask;
    }

    public Optional<AndroidTask<TransformTask>> createMergeJniLibFoldersTasks(TaskFactory tasks, VariantScope variantScope) {
        AndroidTask<MergeSourceSetFolders> mergeJniLibFoldersTask = this.androidTasks.create(tasks, new MergeSourceSetFolders.MergeJniLibFoldersConfigAction(variantScope));
        mergeJniLibFoldersTask.dependsOn(tasks, variantScope.getAssetGenTask());
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "mergedJniFolder").addContentType(ExtendedContentType.NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFolder(variantScope.getMergeNativeLibsOutputDir()).setDependency(mergeJniLibFoldersTask.getName()).build());
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "local-ndk-build").addContentType(ExtendedContentType.NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFolders(variantScope::getNdkSoFolder).setDependency(this.getNdkBuildable(variantScope.getVariantData())).build());
        if (variantScope.getExternalNativeJsonGenerator() != null) {
            variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "external-native-build").addContentType(ExtendedContentType.NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFolder(variantScope.getExternalNativeJsonGenerator().getObjFolder()).setDependency(variantScope.getExternalNativeBuildTask().getName()).build());
        }
        if (variantScope.getVariantConfiguration().getRenderscriptSupportModeEnabled()) {
            Supplier<Collection<File>> supplier = () -> {
                File rsLibs;
                ImmutableList.Builder builder = ImmutableList.builder();
                if (variantScope.getRenderscriptLibOutputDir().isDirectory()) {
                    builder.add((Object)variantScope.getRenderscriptLibOutputDir());
                }
                if ((rsLibs = variantScope.getGlobalScope().getAndroidBuilder().getSupportNativeLibFolder()) != null && rsLibs.isDirectory()) {
                    builder.add((Object)rsLibs);
                }
                if (variantScope.getVariantConfiguration().getRenderscriptSupportModeBlasEnabled()) {
                    File rsBlasLib = variantScope.getGlobalScope().getAndroidBuilder().getSupportBlasLibFolder();
                    if (rsBlasLib == null || !rsBlasLib.isDirectory()) {
                        throw new GradleException("Renderscript BLAS support mode is not supported in BuildTools" + rsBlasLib);
                    }
                    builder.add((Object)rsBlasLib);
                }
                return builder.build();
            };
            variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "rs-support-mode-output").addContentType(ExtendedContentType.NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFolders(supplier).setDependency(variantScope.getRenderscriptCompileTask().getName()).build());
        }
        Set<? super QualifiedContent.Scope> mergeScopes = this.getResMergingScopes(variantScope);
        MergeJavaResourcesTransform mergeTransform = new MergeJavaResourcesTransform(variantScope.getGlobalScope().getExtension().getPackagingOptions(), mergeScopes, ExtendedContentType.NATIVE_LIBS, "mergeJniLibs", variantScope);
        Optional<AndroidTask<TransformTask>> transformTask = variantScope.getTransformManager().addTransform(tasks, variantScope, mergeTransform);
        return transformTask;
    }

    public void createBuildConfigTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<GenerateBuildConfig> generateBuildConfigTask = this.androidTasks.create(tasks, new GenerateBuildConfig.ConfigAction(scope));
        scope.setGenerateBuildConfigTask(generateBuildConfigTask);
        scope.getSourceGenTask().dependsOn(tasks, (Object)generateBuildConfigTask.getName());
        if (scope.getVariantConfiguration().getType().isForTesting()) {
            generateBuildConfigTask.dependsOn(tasks, scope.getManifestProcessorTask());
        } else {
            generateBuildConfigTask.dependsOn(tasks, scope.getCheckManifestTask());
        }
    }

    public void createGenerateResValuesTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<GenerateResValues> generateResValuesTask = this.androidTasks.create(tasks, new GenerateResValues.ConfigAction(scope));
        scope.getResourceGenTask().dependsOn(tasks, generateResValuesTask);
    }

    public void createApkProcessResTask(TaskFactory tasks, VariantScope scope) {
        this.createProcessResTask(tasks, scope, () -> new File(this.globalScope.getIntermediatesDir(), "symbols/" + scope.getVariantData().getVariantConfiguration().getDirName()), scope.getProcessResourcePackageOutputDirectory(), MergeType.MERGE, scope.getGlobalScope().getProjectBaseName());
    }

    protected boolean isLibrary() {
        return false;
    }

    public AndroidTask<ProcessAndroidResources> createProcessResTask(TaskFactory tasks, VariantScope scope, Supplier<File> symbolLocation, File resPackageOutputFolder, MergeType mergeType, String baseName) {
        boolean useAaptToGenerateLegacyMultidexMainDexProguardRules;
        BaseVariantData variantData = scope.getVariantData();
        variantData.calculateFilters(scope.getGlobalScope().getExtension().getSplits());
        boolean bl = useAaptToGenerateLegacyMultidexMainDexProguardRules = scope.getDexingType() == DexingType.LEGACY_MULTIDEX;
        if (!this.isLibrary()) {
            File splitListOutputFile = new File(scope.getSplitSupportDirectory(), "split-list.gson");
            AndroidTask<SplitsDiscovery> splitsDiscoveryAndroidTask = this.androidTasks.create(tasks, new SplitsDiscovery.ConfigAction(scope, splitListOutputFile));
            scope.addTaskOutput(TaskOutputHolder.TaskOutputType.SPLIT_LIST, splitListOutputFile, splitsDiscoveryAndroidTask.getName());
        }
        File symbolTableWithPackageName = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"res", "symbol-table-with-package", scope.getVariantConfiguration().getDirName(), "package-aware-r.txt"});
        AndroidTask<ProcessAndroidResources> processAndroidResources = this.androidTasks.create(tasks, this.createProcessAndroidResourcesConfigAction(scope, symbolLocation, symbolTableWithPackageName, resPackageOutputFolder, useAaptToGenerateLegacyMultidexMainDexProguardRules, mergeType, baseName));
        String taskName = processAndroidResources.getName();
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.PROCESSED_RES, resPackageOutputFolder, taskName);
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.SYMBOL_LIST, new File(symbolLocation.get(), "R.txt"), taskName);
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.SYMBOL_LIST_WITH_PACKAGE_NAME, symbolTableWithPackageName, taskName);
        scope.setProcessResourcesTask(processAndroidResources);
        scope.getSourceGenTask().optionalDependsOn(tasks, processAndroidResources);
        return processAndroidResources;
    }

    protected ProcessAndroidResources.ConfigAction createProcessAndroidResourcesConfigAction(VariantScope scope, Supplier<File> symbolLocation, File symbolWithPackageName, File resPackageOutputFolder, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules, MergeType sourceTaskOutputType, String baseName) {
        return new ProcessAndroidResources.ConfigAction(scope, symbolLocation, symbolWithPackageName, resPackageOutputFolder, useAaptToGenerateLegacyMultidexMainDexProguardRules, sourceTaskOutputType, baseName, this.isLibrary());
    }

    public AndroidTask<PackageSplitRes> createSplitResourcesTasks(TaskFactory tasks, VariantScope scope, PackagingScope packagingScope) {
        BaseVariantData variantData = scope.getVariantData();
        Preconditions.checkState((boolean)variantData.getOutputScope().getMultiOutputPolicy().equals((Object)MultiOutputPolicy.SPLITS), (Object)"Can only create split resources tasks for pure splits.");
        File densityOrLanguagesPackages = scope.getSplitDensityOrLanguagesPackagesOutputDirectory();
        AndroidTask<PackageSplitRes> packageSplitRes = this.androidTasks.create(tasks, new PackageSplitRes.ConfigAction(scope, densityOrLanguagesPackages));
        variantData.packageSplitResourcesTask = packageSplitRes;
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, densityOrLanguagesPackages, packageSplitRes.getName());
        if (packagingScope.getSigningConfig() != null) {
            packageSplitRes.dependsOn(tasks, this.getValidateSigningTask(tasks, packagingScope));
        }
        return packageSplitRes;
    }

    public AndroidTask<PackageSplitAbi> createSplitAbiTasks(TaskFactory tasks, VariantScope scope, PackagingScope packagingScope) {
        BaseVariantData variantData = scope.getVariantData();
        Preconditions.checkState((boolean)variantData.getOutputScope().getMultiOutputPolicy().equals((Object)MultiOutputPolicy.SPLITS), (Object)"split ABI tasks are only compatible with pure splits.");
        ImmutableSet<String> filters = AbiSplitOptions.getAbiFilters(this.extension.getSplits().getAbiFilters());
        if (filters.isEmpty()) {
            return null;
        }
        List<ApkData> fullApkDatas = variantData.getOutputScope().getSplitsByType(VariantOutput.OutputType.FULL_SPLIT);
        if (!fullApkDatas.isEmpty()) {
            throw new RuntimeException("In release 21 and later, there cannot be full splits and pure splits, found " + Joiner.on((String)",").join(fullApkDatas) + " and abi filters " + Joiner.on((String)",").join(filters));
        }
        File generateSplitAbiResOutputDirectory = scope.getGenerateSplitAbiResOutputDirectory();
        AndroidTask<GenerateSplitAbiRes> generateSplitAbiRes = this.androidTasks.create(tasks, new GenerateSplitAbiRes.ConfigAction(scope, generateSplitAbiResOutputDirectory));
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.ABI_PROCESSED_SPLIT_RES, generateSplitAbiResOutputDirectory, generateSplitAbiRes.getName());
        File generateSplitAbiPackagesOutputDirectory = scope.getSplitAbiPackagesOutputDirectory();
        AndroidTask<PackageSplitAbi> packageSplitAbiTask = this.androidTasks.create(tasks, new PackageSplitAbi.ConfigAction(scope, generateSplitAbiPackagesOutputDirectory, scope.getOutput(TaskOutputHolder.TaskOutputType.ABI_PROCESSED_SPLIT_RES)));
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.ABI_PACKAGED_SPLIT, generateSplitAbiPackagesOutputDirectory, packageSplitAbiTask.getName());
        variantData.packageSplitAbiTask = packageSplitAbiTask;
        packageSplitAbiTask.dependsOn(tasks, (Object)scope.getNdkBuildable());
        if (packagingScope.getSigningConfig() != null) {
            packageSplitAbiTask.dependsOn(tasks, this.getValidateSigningTask(tasks, packagingScope));
        }
        if (scope.getExternalNativeBuildTask() != null) {
            packageSplitAbiTask.dependsOn(tasks, scope.getExternalNativeBuildTask());
        }
        return packageSplitAbiTask;
    }

    public void createSplitTasks(TaskFactory tasks, VariantScope variantScope) {
        DefaultGradlePackagingScope packagingScope = new DefaultGradlePackagingScope(variantScope);
        this.createSplitResourcesTasks(tasks, variantScope, packagingScope);
        this.createSplitAbiTasks(tasks, variantScope, packagingScope);
    }

    protected abstract Set<? super QualifiedContent.Scope> getResMergingScopes(VariantScope var1);

    public void createProcessJavaResTask(TaskFactory tasks, VariantScope variantScope) {
        File destinationDir = variantScope.getSourceFoldersJavaResDestinationDir();
        AndroidTask<Sync> processJavaResourcesTask = this.androidTasks.create(tasks, new ProcessJavaResConfigAction(variantScope, destinationDir));
        variantScope.setProcessJavaResourcesTask(processJavaResourcesTask);
        processJavaResourcesTask.configure(tasks, (Action<Sync>)((Action)t -> {
            variantScope.getVariantData().processJavaResourcesTask = t;
        }));
        processJavaResourcesTask.dependsOn(tasks, variantScope.getPreBuildTask());
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.JAVA_RES, destinationDir, processJavaResourcesTask.getName());
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "processed-java-res").addContentType((QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFolder(destinationDir).setDependency(processJavaResourcesTask.getName()).build());
    }

    public void createMergeJavaResTransform(TaskFactory tasks, VariantScope variantScope) {
        TransformManager transformManager = variantScope.getTransformManager();
        Set<? super QualifiedContent.Scope> mergeScopes = this.getResMergingScopes(variantScope);
        MergeJavaResourcesTransform mergeTransform = new MergeJavaResourcesTransform(variantScope.getGlobalScope().getExtension().getPackagingOptions(), mergeScopes, (QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES, "mergeJavaRes", variantScope);
        variantScope.setMergeJavaResourcesTask(transformManager.addTransform(tasks, variantScope, mergeTransform).orElse(null));
    }

    public AndroidTask<AidlCompile> createAidlTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<AidlCompile> aidlCompileTask = this.androidTasks.create(tasks, new AidlCompile.ConfigAction(scope));
        scope.setAidlCompileTask(aidlCompileTask);
        scope.getSourceGenTask().dependsOn(tasks, aidlCompileTask);
        aidlCompileTask.dependsOn(tasks, scope.getPreBuildTask());
        return aidlCompileTask;
    }

    public void createShaderTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<MergeSourceSetFolders> mergeShadersTask = this.androidTasks.create(tasks, new MergeSourceSetFolders.MergeShaderSourceFoldersConfigAction(scope));
        AndroidTask<ShaderCompile> shaderCompileTask = this.androidTasks.create(tasks, new ShaderCompile.ConfigAction(scope));
        shaderCompileTask.dependsOn(tasks, mergeShadersTask);
        scope.getAssetGenTask().dependsOn(tasks, shaderCompileTask);
    }

    protected abstract void postJavacCreation(TaskFactory var1, VariantScope var2);

    public AndroidTask<? extends JavaCompile> createJavacTask(TaskFactory tasks, VariantScope scope) {
        File processorListFile = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"javaPrecompile", scope.getDirName(), "annotationProcessors.json"});
        AndroidTask<JavaPreCompileTask> preCompileTask = this.androidTasks.create(tasks, new JavaPreCompileTask.ConfigAction(scope, processorListFile));
        preCompileTask.dependsOn(tasks, scope.getPreBuildTask());
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.ANNOTATION_PROCESSOR_LIST, processorListFile, preCompileTask.getName());
        File outputFolder = new File(this.globalScope.getIntermediatesDir(), "/classes/" + scope.getVariantConfiguration().getDirName());
        AndroidTask<AndroidJavaCompile> javacTask = this.androidTasks.create(tasks, new JavaCompileConfigAction(scope, outputFolder));
        scope.setJavacTask(javacTask);
        TaskManager.setupCompileTaskDependencies(tasks, scope, javacTask);
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.JAVAC, outputFolder, javacTask.getName());
        this.postJavacCreation(tasks, scope);
        if (this.extension.getDataBinding().isEnabled()) {
            scope.addTaskOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_ARTIFACT, scope.getBundleFolderForDataBinding(), javacTask.getName());
        }
        return javacTask;
    }

    public void addJavacClassesStream(VariantScope scope) {
        scope.getTransformManager().addStream(OriginalStream.builder(this.project, "javac-output").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES, QualifiedContent.DefaultContentType.RESOURCES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection(scope.getOutput(TaskOutputHolder.TaskOutputType.JAVAC)).build());
        scope.getTransformManager().addStream(OriginalStream.builder(this.project, "pre-javac-generated-bytecode").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES, QualifiedContent.DefaultContentType.RESOURCES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection(scope.getVariantData().getAllPreJavacGeneratedBytecode()).build());
        scope.getTransformManager().addStream(OriginalStream.builder(this.project, "post-javac-generated-bytecode").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES, QualifiedContent.DefaultContentType.RESOURCES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection(scope.getVariantData().getAllPostJavacGeneratedBytecode()).build());
    }

    private static void setupCompileTaskDependencies(TaskFactory tasks, VariantScope scope, AndroidTask<?> compileTask) {
        compileTask.optionalDependsOn(tasks, scope.getSourceGenTask());
    }

    public static void setJavaCompilerTask(AndroidTask<? extends Task> javaCompilerTask, TaskFactory tasks, VariantScope scope) {
        scope.getCompileTask().dependsOn(tasks, javaCompilerTask);
    }

    public void createGenerateMicroApkDataTask(TaskFactory tasks, VariantScope scope, FileCollection config) {
        AndroidTask<GenerateApkDataTask> generateMicroApkTask = this.androidTasks.create(tasks, new GenerateApkDataTask.ConfigAction(scope, config));
        scope.setMicroApkTask(generateMicroApkTask);
        scope.getResourceGenTask().dependsOn(tasks, generateMicroApkTask);
    }

    public void createExternalNativeBuildJsonGenerators(VariantScope scope) {
        CoreExternalNativeBuild externalNativeBuild = this.extension.getExternalNativeBuild();
        ExternalNativeBuildTaskUtils.ExternalNativeBuildProjectPathResolution pathResolution = ExternalNativeBuildTaskUtils.getProjectPath(externalNativeBuild);
        if (pathResolution.errorText != null) {
            this.androidBuilder.getErrorReporter().handleSyncError(scope.getVariantConfiguration().getFullName(), 16, pathResolution.errorText);
            return;
        }
        if (pathResolution.makeFile == null) {
            return;
        }
        scope.setExternalNativeJsonGenerator(ExternalNativeJsonGenerator.create(this.project.getProjectDir(), this.project.getBuildDir(), pathResolution.externalNativeBuildDir, pathResolution.buildSystem, pathResolution.makeFile, this.androidBuilder, this.sdkHandler, scope));
    }

    public void createExternalNativeBuildTasks(TaskFactory tasks, VariantScope scope) {
        ExternalNativeJsonGenerator generator = scope.getExternalNativeJsonGenerator();
        if (generator == null) {
            return;
        }
        AndroidTask<ExternalNativeBuildJsonTask> generateTask = this.androidTasks.create(tasks, ExternalNativeBuildJsonTask.createTaskConfigAction(generator, scope));
        generateTask.dependsOn(tasks, scope.getPreBuildTask());
        ProjectOptions projectOptions = this.globalScope.getProjectOptions();
        String targetAbi = projectOptions.get(BooleanOption.BUILD_ONLY_TARGET_ABI) ? projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI) : null;
        AndroidTask<ExternalNativeBuildTask> buildTask = this.androidTasks.create(tasks, new ExternalNativeBuildTask.ConfigAction(targetAbi, generator, scope, this.androidBuilder));
        buildTask.dependsOn(tasks, generateTask);
        scope.setExternalNativeBuildTask(buildTask);
        scope.getCompileTask().dependsOn(tasks, buildTask);
        Task cleanTask = (Task)Preconditions.checkNotNull((Object)tasks.named("clean"));
        cleanTask.dependsOn(new Object[]{this.androidTasks.create(tasks, new ExternalNativeCleanTask.ConfigAction(generator, scope, this.androidBuilder)).getName()});
    }

    public void createNdkTasks(TaskFactory tasks, VariantScope scope) {
        if (ExternalNativeBuildTaskUtils.isExternalNativeBuildEnabled(this.extension.getExternalNativeBuild())) {
            return;
        }
        AndroidTask<NdkCompile> ndkCompileTask = this.androidTasks.create(tasks, new NdkCompile.ConfigAction(scope));
        ndkCompileTask.dependsOn(tasks, scope.getPreBuildTask());
        if (Boolean.TRUE.equals(scope.getVariantData().getVariantConfiguration().getMergedFlavor().getRenderscriptNdkModeEnabled())) {
            ndkCompileTask.dependsOn(tasks, scope.getRenderscriptCompileTask());
        }
        scope.getCompileTask().dependsOn(tasks, ndkCompileTask);
    }

    public static void createStripNativeLibraryTask(TaskFactory tasks, VariantScope scope) {
        if (!scope.getGlobalScope().getNdkHandler().isConfigured()) {
            return;
        }
        TransformManager transformManager = scope.getTransformManager();
        GlobalScope globalScope = scope.getGlobalScope();
        transformManager.addTransform(tasks, scope, new StripDebugSymbolTransform(globalScope.getProject(), globalScope.getNdkHandler(), globalScope.getExtension().getPackagingOptions().getDoNotStrip(), scope.getVariantConfiguration().getType() == VariantType.LIBRARY));
    }

    public void createUnitTestVariantTasks(TaskFactory tasks, TestVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        BaseVariantData testedVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)variantScope.getTestedVariantData(), (Object)"Not a unit test variant");
        VariantScope testedVariantScope = testedVariantData.getScope();
        this.createPreBuildTasks(tasks, variantScope);
        this.createDependencyStreams(tasks, variantScope);
        this.createProcessJavaResTask(tasks, variantScope);
        this.createCompileAnchorTask(tasks, variantScope);
        if (this.extension.getTestOptions().getUnitTests().isIncludeAndroidResources()) {
            File unitTestConfigDir = new File(this.globalScope.getIntermediatesDir(), "unitTestConfig/" + variantData.getVariantConfiguration().getDirName());
            AndroidTask<GenerateTestConfig> generateTestConfig = this.androidTasks.create(tasks, new GenerateTestConfig.ConfigAction(variantScope, unitTestConfigDir));
            variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.UNIT_TEST_CONFIG_DIRECTORY, unitTestConfigDir, generateTestConfig.getName());
            variantScope.getCompileTask().dependsOn(tasks, generateTestConfig);
        }
        AndroidTask<Task> compileTask = variantScope.getCompileTask();
        compileTask.dependsOn(tasks, (Object)variantScope.getProcessJavaResourcesTask(), (Object)testedVariantScope.getProcessJavaResourcesTask());
        if (this.extension.getTestOptions().getUnitTests().isIncludeAndroidResources()) {
            compileTask.dependsOn(tasks, testedVariantScope.getMergeResourcesTask());
            compileTask.dependsOn(tasks, testedVariantScope.getMergeAssetsTask());
            compileTask.dependsOn(tasks, testedVariantScope.getManifestProcessorTask());
        }
        AndroidTask<? extends JavaCompile> javacTask = this.createJavacTask(tasks, variantScope);
        this.addJavacClassesStream(variantScope);
        TaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
        javacTask.dependsOn(tasks, testedVariantScope.getJavacTask());
        this.createMergeJavaResTransform(tasks, variantScope);
        this.createRunUnitTestTask(tasks, variantScope);
        AndroidTask<DefaultTask> assembleUnitTests = variantScope.getAssembleTask();
        assembleUnitTests.dependsOn(tasks, this.createMockableJar);
        assembleUnitTests.configure(tasks, (Action<DefaultTask>)((Action)task -> task.setGroup(null)));
    }

    public void createAndroidTestVariantTasks(TaskFactory tasks, TestVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        this.createAnchorTasks(tasks, variantScope);
        this.createDependencyStreams(tasks, variantScope);
        this.createProcessTestManifestTask(tasks, variantScope, variantScope.getTestedVariantData().getScope());
        this.createGenerateResValuesTask(tasks, variantScope);
        this.createRenderscriptTask(tasks, variantScope);
        this.createMergeResourcesTask(tasks, variantScope, true);
        this.createMergeAssetsTask(tasks, variantScope, null);
        this.createBuildConfigTask(tasks, variantScope);
        this.createApkProcessResTask(tasks, variantScope);
        this.createProcessJavaResTask(tasks, variantScope);
        this.createAidlTask(tasks, variantScope);
        this.createShaderTask(tasks, variantScope);
        if (!this.isComponentModelPlugin()) {
            this.createNdkTasks(tasks, variantScope);
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        this.createMergeJniLibFoldersTasks(tasks, variantScope);
        this.createDataBindingMergeArtifactsTaskIfNecessary(tasks, variantScope);
        this.createDataBindingTasksIfNecessary(tasks, variantScope);
        AndroidTask<? extends JavaCompile> javacTask = this.createJavacTask(tasks, variantScope);
        this.addJavacClassesStream(variantScope);
        TaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
        this.createPostCompilationTasks(tasks, variantScope);
        this.createPackagingTask(tasks, variantScope, null);
        tasks.named(ASSEMBLE_ANDROID_TEST, (Action<? super Task>)((Action)assembleTest -> assembleTest.dependsOn(new Object[]{variantData.getScope().getAssembleTask().getName()})));
        this.createConnectedTestForVariant(tasks, variantScope);
    }

    private static boolean isLintVariant(VariantScope variantScope) {
        VariantType variantType = variantScope.getVariantConfiguration().getType();
        return !variantType.isForTesting() && variantType != VariantType.FEATURE;
    }

    public void createLintTasks(TaskFactory tasks, VariantScope scope) {
        if (!TaskManager.isLintVariant(scope)) {
            return;
        }
        this.androidTasks.create(tasks, new LintPerVariantTask.ConfigAction(scope));
    }

    private String getTaskPath(String taskName) {
        return this.project.getRootProject() == this.project ? ':' + taskName : this.project.getPath() + ':' + taskName;
    }

    private void maybeCreateLintVitalTask(TaskFactory tasks, ApkVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        if (!TaskManager.isLintVariant(variantScope) || variantScope.getInstantRunBuildContext().isInInstantRunMode() || ((CoreBuildType)variantConfig.getBuildType()).isDebuggable() || !this.extension.getLintOptions().isCheckReleaseBuilds()) {
            return;
        }
        AndroidTask<LintPerVariantTask> lintReleaseCheck = this.androidTasks.create(tasks, new LintPerVariantTask.VitalConfigAction(variantScope));
        lintReleaseCheck.optionalDependsOn(tasks, variantData.javacTask);
        variantScope.getAssembleTask().dependsOn(tasks, lintReleaseCheck);
        this.project.getGradle().getTaskGraph().whenReady(taskGraph -> {
            if (taskGraph.hasTask(this.getTaskPath(LINT))) {
                this.project.getTasks().getByName(lintReleaseCheck.getName()).setEnabled(false);
            }
        });
    }

    private void createRunUnitTestTask(TaskFactory tasks, VariantScope variantScope) {
        AndroidTask<AndroidUnitTest> runTestsTask = this.androidTasks.create(tasks, new AndroidUnitTest.ConfigAction(variantScope));
        tasks.named("test", (Action<? super Task>)((Action)test -> test.dependsOn(new Object[]{runTestsTask.getName()})));
    }

    public void createTopLevelTestTasks(TaskFactory tasks, boolean hasFlavors) {
        AndroidTask<DefaultTask> deviceAndroidTestTask;
        AndroidTask<DefaultTask> connectedAndroidTestTask;
        this.createMockableJarTask(tasks);
        this.createAttrFromAndroidJarTask(tasks);
        ArrayList reportTasks = Lists.newArrayListWithExpectedSize((int)2);
        List<DeviceProvider> providers = this.extension.getDeviceProviders();
        if (hasFlavors) {
            connectedAndroidTestTask = this.androidTasks.create(tasks, new AndroidReportTask.ConfigAction(this.globalScope, AndroidReportTask.ConfigAction.TaskKind.CONNECTED));
            reportTasks.add(connectedAndroidTestTask.getName());
        } else {
            connectedAndroidTestTask = this.androidTasks.create(tasks, CONNECTED_ANDROID_TEST, (Action<Task>)((Action)connectedTask -> {
                connectedTask.setGroup("verification");
                connectedTask.setDescription("Installs and runs instrumentation tests for all flavors on connected devices.");
            }));
        }
        tasks.named(CONNECTED_CHECK, (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{connectedAndroidTestTask.getName()})));
        if (providers.size() > 1 || hasFlavors) {
            deviceAndroidTestTask = this.androidTasks.create(tasks, new AndroidReportTask.ConfigAction(this.globalScope, AndroidReportTask.ConfigAction.TaskKind.DEVICE_PROVIDER));
            reportTasks.add(deviceAndroidTestTask.getName());
        } else {
            deviceAndroidTestTask = this.androidTasks.create(tasks, DEVICE_ANDROID_TEST, (Action<Task>)((Action)providerTask -> {
                providerTask.setGroup("verification");
                providerTask.setDescription("Installs and runs instrumentation tests using all Device Providers.");
            }));
        }
        tasks.named(DEVICE_CHECK, (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{deviceAndroidTestTask.getName()})));
        this.androidTasks.create(tasks, "test", (Action<Task>)((Action)unitTestTask -> {
            unitTestTask.setGroup("verification");
            unitTestTask.setDescription("Run unit tests for all variants.");
        }));
        tasks.named("check", (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{"test"})));
        if (!reportTasks.isEmpty() && this.project.getGradle().getStartParameter().isContinueOnFailure()) {
            this.project.getGradle().getTaskGraph().whenReady(taskGraph -> {
                for (String reportTask : reportTasks) {
                    if (!taskGraph.hasTask(this.getTaskPath(reportTask))) continue;
                    tasks.named(reportTask, (Action<? super Task>)((Action)task -> ((AndroidReportTask)task).setWillRun()));
                }
            });
        }
    }

    protected void createConnectedTestForVariant(TaskFactory tasks, VariantScope variantScope) {
        BaseVariantData baseVariantData = variantScope.getTestedVariantData();
        TestVariantData testVariantData = (TestVariantData)variantScope.getVariantData();
        boolean isLibrary = baseVariantData.getVariantConfiguration().getType() == VariantType.LIBRARY;
        TestDataImpl testData = new TestDataImpl(testVariantData, variantScope.getOutput(TaskOutputHolder.TaskOutputType.APK), isLibrary ? null : testVariantData.getTestedVariantData().getScope().getOutput(TaskOutputHolder.TaskOutputType.APK));
        testData.setExtraInstrumentationTestRunnerArgs(this.projectOptions.getExtraInstrumentationTestRunnerArgs());
        this.configureTestData(testData);
        ImmutableList artifactsTasks = ImmutableList.of(variantScope.getAssembleTask(), testVariantData.getTestedVariantData().getScope().getAssembleTask());
        AndroidTask<DeviceProviderInstrumentTestTask> connectedTask = this.androidTasks.create(tasks, new DeviceProviderInstrumentTestTask.ConfigAction(testVariantData.getScope(), (DeviceProvider)new ConnectedDeviceProvider(this.sdkHandler.getSdkInfo().getAdb(), this.extension.getAdbOptions().getTimeOutInMs(), (ILogger)new LoggerWrapper(this.logger)), testData, (FileCollection)this.project.files(new Object[0])));
        connectedTask.dependsOn(tasks, artifactsTasks.toArray());
        tasks.named(CONNECTED_ANDROID_TEST, (Action<? super Task>)((Action)connectedAndroidTest -> connectedAndroidTest.dependsOn(new Object[]{connectedTask.getName()})));
        if (((CoreBuildType)baseVariantData.getVariantConfiguration().getBuildType()).isTestCoverageEnabled()) {
            AndroidTask<JacocoReportTask> reportTask = this.androidTasks.create(tasks, new JacocoReportTask.ConfigAction(variantScope));
            reportTask.dependsOn(tasks, (Object)this.project.getConfigurations().getAt("androidJacocoAnt"));
            reportTask.dependsOn(tasks, (Object)connectedTask.getName());
            variantScope.setCoverageReportTask(reportTask);
            baseVariantData.getScope().getCoverageReportTask().dependsOn(tasks, reportTask);
            tasks.named(CONNECTED_ANDROID_TEST, (Action<? super Task>)((Action)connectedAndroidTest -> connectedAndroidTest.dependsOn(new Object[]{reportTask.getName()})));
        }
        List<DeviceProvider> providers = this.extension.getDeviceProviders();
        for (DeviceProvider deviceProvider : providers) {
            AndroidTask<DeviceProviderInstrumentTestTask> providerTask = this.androidTasks.create(tasks, new DeviceProviderInstrumentTestTask.ConfigAction(testVariantData.getScope(), deviceProvider, testData, (FileCollection)this.project.files(new Object[0])));
            providerTask.dependsOn(tasks, artifactsTasks.toArray());
            tasks.named(DEVICE_ANDROID_TEST, (Action<? super Task>)((Action)deviceAndroidTest -> deviceAndroidTest.dependsOn(new Object[]{providerTask.getName()})));
        }
        List<TestServer> servers = this.extension.getTestServers();
        for (TestServer testServer : servers) {
            AndroidTask<TestServerTask> serverTask = this.androidTasks.create(tasks, new TestServerTaskConfigAction(variantScope, testServer));
            serverTask.dependsOn(tasks, variantScope.getAssembleTask());
            tasks.named(DEVICE_CHECK, (Action<? super Task>)((Action)deviceAndroidTest -> deviceAndroidTest.dependsOn(new Object[]{serverTask.getName()})));
        }
    }

    public void createPostCompilationTasks(TaskFactory tasks, VariantScope variantScope) {
        Optional<Object> multiDexClassListTask;
        DexingType dexingType;
        boolean isTestCoverageEnabled;
        Preconditions.checkNotNull(variantScope.getJavacTask());
        BaseVariantData variantData = variantScope.getVariantData();
        GradleVariantConfiguration config = variantData.getVariantConfiguration();
        TransformManager transformManager = variantScope.getTransformManager();
        boolean bl = isTestCoverageEnabled = ((CoreBuildType)config.getBuildType()).isTestCoverageEnabled() && !config.getType().isForTesting() && !variantScope.getInstantRunBuildContext().isInInstantRunMode();
        if (isTestCoverageEnabled) {
            this.createJacocoTransform(tasks, variantScope);
        }
        this.maybeCreateDesugarTask(tasks, variantScope, config.getMinSdkVersion(), transformManager);
        AndroidConfig extension = variantScope.getGlobalScope().getExtension();
        this.createMergeJavaResTransform(tasks, variantScope);
        List<Transform> customTransforms = extension.getTransforms();
        List<List<Object>> customTransformsDependencies = extension.getTransformsDependencies();
        int count = customTransforms.size();
        for (int i = 0; i < count; ++i) {
            Transform transform = customTransforms.get(i);
            List<Object> deps = customTransformsDependencies.get(i);
            transformManager.addTransform(tasks, variantScope, transform).ifPresent(t -> {
                if (!deps.isEmpty()) {
                    t.dependsOn(tasks, (Object)deps);
                }
                if (transform.getScopes().isEmpty()) {
                    variantScope.getAssembleTask().dependsOn(tasks, (AndroidTask<?>)t);
                }
            });
        }
        for (String jar : TaskManager.getAdvancedProfilingTransforms(this.projectOptions)) {
            if (!((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable() || !variantData.getType().equals((Object)VariantType.DEFAULT) || jar == null) continue;
            transformManager.addTransform(tasks, variantScope, new CustomClassTransform(jar));
        }
        this.maybeCreateJavaCodeShrinkerTransform(tasks, variantScope);
        this.maybeCreateResourcesShrinkerTransform(tasks, variantScope);
        AndroidTask<PreColdSwapTask> preColdSwapTask = null;
        if (variantScope.getInstantRunBuildContext().isInInstantRunMode()) {
            AndroidTask<DefaultTask> allActionsAnchorTask = this.createInstantRunAllActionsTasks(tasks, variantScope);
            assert (variantScope.getInstantRunTaskManager() != null);
            preColdSwapTask = variantScope.getInstantRunTaskManager().createPreColdswapTask(this.projectOptions);
            preColdSwapTask.dependsOn(tasks, allActionsAnchorTask);
            if (InstantRunPatchingPolicy.PRE_LOLLIPOP != variantScope.getInstantRunBuildContext().getPatchingPolicy()) {
                extension.getDexOptions().setPreDexLibraries(true);
                variantScope.getInstantRunTaskManager().createSlicerTask();
            }
            extension.getDexOptions().setJumboMode(true);
        }
        if ((dexingType = variantScope.getDexingType()) == DexingType.LEGACY_MULTIDEX && variantScope.getVariantConfiguration().isMultiDexEnabled() && variantScope.getVariantConfiguration().getMinSdkVersionWithTargetDeviceApi().getFeatureLevel() >= 21) {
            dexingType = DexingType.NATIVE_MULTIDEX;
        }
        if (dexingType == DexingType.LEGACY_MULTIDEX) {
            boolean proguardInPipeline;
            boolean bl2 = proguardInPipeline = variantScope.getCodeShrinker() == CodeShrinker.PROGUARD;
            if (!proguardInPipeline && !this.usingIncrementalDexing(variantScope)) {
                JarMergingTransform jarMergingTransform = new JarMergingTransform(TransformManager.SCOPE_FULL_PROJECT);
                transformManager.addTransform(tasks, variantScope, jarMergingTransform).ifPresent(variantScope::addColdSwapBuildTask);
            }
            BaseProguardAction multiDexTransform = this.usingIncrementalDexing(variantScope) ? new MainDexListTransform(variantScope, extension.getDexOptions()) : new MultiDexTransform(variantScope, extension.getDexOptions());
            multiDexClassListTask = transformManager.addTransform(tasks, variantScope, multiDexTransform);
            multiDexClassListTask.ifPresent(variantScope::addColdSwapBuildTask);
        } else {
            multiDexClassListTask = Optional.empty();
        }
        if (this.usingIncrementalDexing(variantScope)) {
            this.createNewDexTasks(tasks, variantScope, multiDexClassListTask.orElse(null), dexingType);
        } else {
            this.createDexTasks(tasks, variantScope, multiDexClassListTask.orElse(null), dexingType);
        }
        if (preColdSwapTask != null) {
            for (AndroidTask<? extends DefaultTask> task : variantScope.getColdSwapBuildTasks()) {
                task.dependsOn(tasks, preColdSwapTask);
            }
        }
    }

    private void maybeCreateDesugarTask(TaskFactory tasks, VariantScope variantScope, AndroidVersion minSdk, TransformManager transformManager) {
        if (variantScope.getJava8LangSupportType() == VariantScope.Java8LangSupport.DESUGAR) {
            FileCache userCache = this.getUserIntermediatesCache();
            FixStackFramesTransform fixFrames = new FixStackFramesTransform(() -> this.androidBuilder.getBootClasspath(true), System.getProperty("sun.boot.class.path"), userCache);
            transformManager.addTransform(tasks, variantScope, fixFrames);
            DesugarTransform desugarTransform = new DesugarTransform(() -> this.androidBuilder.getBootClasspath(true), System.getProperty("sun.boot.class.path"), userCache, minSdk.getFeatureLevel(), this.androidBuilder.getJavaProcessExecutor(), this.project.getLogger().isEnabled(LogLevel.INFO), this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_GRADLE_WORKERS), variantScope.getGlobalScope().getTmpFolder().toPath());
            transformManager.addTransform(tasks, variantScope, desugarTransform);
            if (minSdk.getFeatureLevel() < 19) {
                String taskName = variantScope.getTaskName("extractTryWithResourcesSupportJar");
                AndroidTask<ExtractTryWithResourcesSupportJar> extractTryWithResources = this.androidTasks.create(tasks, new ExtractTryWithResourcesSupportJar.ConfigAction(variantScope.getTryWithResourceRuntimeSupportJar(), taskName, variantScope.getFullVariantName()));
                variantScope.getTryWithResourceRuntimeSupportJar().builtBy(new Object[]{extractTryWithResources.get(tasks)});
                transformManager.addStream(OriginalStream.builder(this.project, "runtime-deps-try-with-resources").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setFileCollection((FileCollection)variantScope.getTryWithResourceRuntimeSupportJar()).build());
            }
        }
    }

    private void createNewDexTasks(TaskFactory tasks, VariantScope variantScope, AndroidTask<TransformTask> multiDexClassListTask, DexingType dexingType) {
        DexOptions dexOptions;
        TransformManager transformManager = variantScope.getTransformManager();
        if (variantScope.getVariantData().getType().isForTesting()) {
            dexOptions = DefaultDexOptions.copyOf((com.android.builder.core.DexOptions)this.extension.getDexOptions());
            dexOptions.setAdditionalParameters((List)ImmutableList.of());
        } else {
            dexOptions = this.extension.getDexOptions();
        }
        boolean minified = this.runJavaCodeShrinker(variantScope);
        FileCache userLevelCache = this.getUserDexCache(minified, dexOptions.getPreDexLibraries());
        DexArchiveBuilderTransform preDexTransform = new DexArchiveBuilderTransform((com.android.builder.core.DexOptions)dexOptions, variantScope.getGlobalScope().getAndroidBuilder().getErrorReporter(), userLevelCache, variantScope.getMinSdkVersion().getFeatureLevel(), variantScope.getDexer(), this.projectOptions.get(BooleanOption.ENABLE_GRADLE_WORKERS), this.projectOptions.get(IntegerOption.DEXING_READ_BUFFER_SIZE), this.projectOptions.get(IntegerOption.DEXING_WRITE_BUFFER_SIZE), ((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable());
        transformManager.addTransform(tasks, variantScope, preDexTransform).ifPresent(variantScope::addColdSwapBuildTask);
        if (dexingType != DexingType.LEGACY_MULTIDEX && variantScope.getCodeShrinker() == null && this.extension.getTransforms().isEmpty()) {
            ExternalLibsMergerTransform externalLibsMergerTransform = new ExternalLibsMergerTransform(dexingType, variantScope.getDexMerger(), variantScope.getMinSdkVersion().getFeatureLevel(), ((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable(), variantScope.getGlobalScope().getAndroidBuilder().getErrorReporter(), DexMergerTransformCallable::new);
            transformManager.addTransform(tasks, variantScope, externalLibsMergerTransform);
        }
        DexMergerTransform dexTransform = new DexMergerTransform(dexingType, (FileCollection)(dexingType == DexingType.LEGACY_MULTIDEX ? this.project.files(new Object[]{variantScope.getMainDexListFile()}) : null), variantScope.getGlobalScope().getAndroidBuilder().getErrorReporter(), variantScope.getDexMerger(), variantScope.getMinSdkVersion().getFeatureLevel(), ((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable());
        Optional<AndroidTask<TransformTask>> dexTask = transformManager.addTransform(tasks, variantScope, dexTransform);
        dexTask.ifPresent(t -> {
            t.optionalDependsOn(tasks, multiDexClassListTask);
            variantScope.addColdSwapBuildTask((AndroidTask<? extends DefaultTask>)t);
        });
    }

    private boolean usingIncrementalDexing(VariantScope variantScope) {
        if (!this.projectOptions.get(BooleanOption.ENABLE_DEX_ARCHIVE)) {
            return false;
        }
        if (((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable()) {
            return true;
        }
        return this.projectOptions.get(BooleanOption.ENABLE_D8);
    }

    private FileCache getUserDexCache(boolean isMinifiedEnabled, boolean preDexLibraries) {
        if (!preDexLibraries || isMinifiedEnabled) {
            return null;
        }
        return this.getUserIntermediatesCache();
    }

    private FileCache getUserIntermediatesCache() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_INTERMEDIATE_ARTIFACTS_CACHE)) {
            return this.globalScope.getBuildCache();
        }
        return null;
    }

    private void createDexTasks(TaskFactory tasks, VariantScope variantScope, AndroidTask<TransformTask> multiDexClassListTask, DexingType dexingType) {
        boolean preDexEnabled;
        DexOptions dexOptions;
        TransformManager transformManager = variantScope.getTransformManager();
        AndroidBuilder androidBuilder = variantScope.getGlobalScope().getAndroidBuilder();
        if (variantScope.getVariantData().getType().isForTesting()) {
            dexOptions = DefaultDexOptions.copyOf((com.android.builder.core.DexOptions)this.extension.getDexOptions());
            dexOptions.setAdditionalParameters((List)ImmutableList.of());
        } else {
            dexOptions = this.extension.getDexOptions();
        }
        boolean cachePreDex = dexingType.isPreDex() && dexOptions.getPreDexLibraries() && !this.runJavaCodeShrinker(variantScope);
        boolean bl = preDexEnabled = variantScope.getInstantRunBuildContext().isInInstantRunMode() || cachePreDex;
        if (preDexEnabled) {
            FileCache buildCache = cachePreDex && this.projectOptions.get(BooleanOption.ENABLE_INTERMEDIATE_ARTIFACTS_CACHE) ? this.buildCache : null;
            PreDexTransform preDexTransform = new PreDexTransform((com.android.builder.core.DexOptions)dexOptions, androidBuilder, buildCache, dexingType, variantScope.getMinSdkVersion().getFeatureLevel());
            transformManager.addTransform(tasks, variantScope, preDexTransform).ifPresent(variantScope::addColdSwapBuildTask);
        }
        if (!preDexEnabled || dexingType != DexingType.NATIVE_MULTIDEX) {
            DexTransform dexTransform = new DexTransform((com.android.builder.core.DexOptions)dexOptions, dexingType, preDexEnabled, (FileCollection)this.project.files(new Object[]{variantScope.getMainDexListFile()}), (TargetInfo)Verify.verifyNotNull((Object)androidBuilder.getTargetInfo(), (String)"Target Info not set.", (Object[])new Object[0]), androidBuilder.getDexByteCodeConverter(), androidBuilder.getErrorReporter(), variantScope.getMinSdkVersion().getFeatureLevel());
            Optional<AndroidTask<TransformTask>> dexTask = transformManager.addTransform(tasks, variantScope, dexTransform);
            dexTask.ifPresent(t -> {
                t.optionalDependsOn(tasks, multiDexClassListTask);
                variantScope.addColdSwapBuildTask((AndroidTask<? extends DefaultTask>)t);
            });
        }
    }

    private boolean runJavaCodeShrinker(VariantScope variantScope) {
        return variantScope.getCodeShrinker() != null || this.isTestedAppObfuscated(variantScope);
    }

    protected boolean isTestedAppObfuscated(VariantScope variantScope) {
        return false;
    }

    private AndroidTask<DefaultTask> createInstantRunAllActionsTasks(TaskFactory tasks, VariantScope variantScope) {
        AndroidTask<DefaultTask> allActionAnchorTask = this.getAndroidTasks().create(tasks, new InstantRunAnchorTaskConfigAction(variantScope));
        TransformManager transformManager = variantScope.getTransformManager();
        ExtractJarsTransform extractJarsTransform = new ExtractJarsTransform((Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES), (Set<QualifiedContent.Scope>)ImmutableSet.of((Object)QualifiedContent.Scope.SUB_PROJECTS));
        Optional<AndroidTask<TransformTask>> extractJarsTask = transformManager.addTransform(tasks, variantScope, extractJarsTransform);
        InstantRunTaskManager instantRunTaskManager = new InstantRunTaskManager(this.getLogger(), variantScope, variantScope.getTransformManager(), this.androidTasks, tasks, this.recorder);
        FileCollection instantRunMergedManifests = variantScope.getOutput(TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS);
        FileCollection processedResources = variantScope.getOutput(TaskOutputHolder.TaskOutputType.PROCESSED_RES);
        variantScope.setInstantRunTaskManager(instantRunTaskManager);
        AndroidVersion minSdkForDx = variantScope.getMinSdkVersion();
        AndroidTask<BuildInfoLoaderTask> buildInfoLoaderTask = instantRunTaskManager.createInstantRunAllTasks((com.android.builder.core.DexOptions)variantScope.getGlobalScope().getExtension().getDexOptions(), () -> ((AndroidBuilder)this.androidBuilder).getDexByteCodeConverter(), extractJarsTask.orElse(null), allActionAnchorTask, this.getResMergingScopes(variantScope), instantRunMergedManifests, processedResources, true, minSdkForDx.getFeatureLevel());
        if (variantScope.getSourceGenTask() != null) {
            variantScope.getSourceGenTask().dependsOn(tasks, buildInfoLoaderTask);
        }
        return allActionAnchorTask;
    }

    protected void handleJacocoDependencies(VariantScope variantScope) {
        boolean isTestCoverageEnabled;
        GradleVariantConfiguration config = variantScope.getVariantConfiguration();
        boolean bl = isTestCoverageEnabled = ((CoreBuildType)config.getBuildType()).isTestCoverageEnabled() && !variantScope.getInstantRunBuildContext().isInInstantRunMode() && (!config.getType().isForTesting() || config.getTestedConfig() != null && config.getTestedConfig().getType() == VariantType.LIBRARY);
        if (isTestCoverageEnabled) {
            Configuration agentConfiguration = this.project.getConfigurations().getByName("androidJacocoAgent");
            variantScope.getVariantDependencies().getRuntimeClasspath().extendsFrom(new Configuration[]{agentConfiguration});
            String jacocoAgentRuntimeDependency = ((JacocoPlugin)this.project.getPlugins().getPlugin(JacocoPlugin.class)).getAgentRuntimeDependency();
            variantScope.getVariantDependencies().getRuntimeClasspath().resolutionStrategy(r -> r.force(new Object[]{jacocoAgentRuntimeDependency}));
        }
    }

    public void createJacocoTransform(TaskFactory taskFactory, VariantScope variantScope) {
        JacocoTransform jacocoTransform = new JacocoTransform();
        variantScope.getTransformManager().addTransform(taskFactory, variantScope, jacocoTransform);
    }

    protected void createDataBindingMergeArtifactsTaskIfNecessary(TaskFactory tasks, VariantScope variantScope) {
        BaseVariantData testedVariantData;
        boolean isTest;
        if (!this.extension.getDataBinding().isEnabled()) {
            return;
        }
        BaseVariantData variantData = variantScope.getVariantData();
        VariantType type = variantData.getType();
        boolean bl = isTest = type == VariantType.ANDROID_TEST || type == VariantType.UNIT_TEST;
        if (isTest && !this.extension.getDataBinding().isEnabledForTests() && (testedVariantData = variantScope.getTestedVariantData()).getType() != VariantType.LIBRARY) {
            return;
        }
        this.setDataBindingAnnotationProcessorParams(variantScope);
        File outFolder = new File(variantScope.getBuildFolderForDataBindingCompiler(), "dependent-lib-artifacts");
        Optional<AndroidTask<TransformTask>> dataBindingMergeTask = variantScope.getTransformManager().addTransform(tasks, variantScope, new DataBindingMergeArtifactsTransform(this.getLogger(), outFolder));
        dataBindingMergeTask.ifPresent(task -> variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_DEPENDENCY_ARTIFACTS, outFolder, task.getName()));
    }

    protected void createDataBindingTasksIfNecessary(TaskFactory tasks, VariantScope scope) {
        BaseVariantData testedVariantData;
        boolean isTest;
        if (!this.extension.getDataBinding().isEnabled()) {
            return;
        }
        VariantType type = scope.getVariantData().getType();
        boolean bl = isTest = type == VariantType.ANDROID_TEST || type == VariantType.UNIT_TEST;
        if (isTest && !this.extension.getDataBinding().isEnabledForTests() && (testedVariantData = scope.getTestedVariantData()).getType() != VariantType.LIBRARY) {
            return;
        }
        this.dataBindingBuilder.setDebugLogEnabled(this.getLogger().isDebugEnabled());
        AndroidTask<DataBindingExportBuildInfoTask> exportBuildInfo = this.androidTasks.create(tasks, new DataBindingExportBuildInfoTask.ConfigAction(scope));
        exportBuildInfo.dependsOn(tasks, scope.getMergeResourcesTask());
        exportBuildInfo.dependsOn(tasks, scope.getSourceGenTask());
        scope.setDataBindingExportBuildInfoTask(exportBuildInfo);
    }

    private void setDataBindingAnnotationProcessorParams(VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        JavaCompileOptions javaCompileOptions = variantConfiguration.getJavaCompileOptions();
        com.android.build.gradle.api.AnnotationProcessorOptions processorOptions = javaCompileOptions.getAnnotationProcessorOptions();
        if (processorOptions instanceof AnnotationProcessorOptions) {
            boolean isTest;
            BaseVariantData artifactVariantData;
            AnnotationProcessorOptions ots = (AnnotationProcessorOptions)processorOptions;
            if (!ots.getClassNames().isEmpty() && !ots.getClassNames().contains("android.databinding.annotationprocessor.ProcessDataBinding")) {
                ots.className("android.databinding.annotationprocessor.ProcessDataBinding");
            }
            String packageName = variantConfiguration.getOriginalApplicationId();
            if (variantData.getType() == VariantType.ANDROID_TEST) {
                artifactVariantData = scope.getTestedVariantData();
                isTest = true;
            } else {
                artifactVariantData = variantData;
                isTest = false;
            }
            DataBindingCompilerArgs.Type type = artifactVariantData.getType() == VariantType.LIBRARY ? DataBindingCompilerArgs.Type.LIBRARY : DataBindingCompilerArgs.Type.APPLICATION;
            int minApi = variantConfiguration.getMinSdkVersion().getApiLevel();
            DataBindingCompilerArgs args = DataBindingCompilerArgs.builder().bundleFolder(scope.getBundleFolderForDataBinding()).enabledForTests(this.extension.getDataBinding().isEnabledForTests()).enableDebugLogs(this.getLogger().isDebugEnabled()).buildFolder(scope.getBuildFolderForDataBindingCompiler()).sdkDir(scope.getGlobalScope().getSdkHandler().getSdkFolder()).xmlOutDir(scope.getLayoutInfoOutputForDataBinding()).exportClassListTo(variantData.getType().isExportDataBindingClassList() ? scope.getGeneratedClassListOutputFileForDataBinding() : null).printEncodedErrorLogs(this.dataBindingBuilder.getPrintMachineReadableOutput()).modulePackage(packageName).minApi(minApi).testVariant(isTest).type(type).build();
            ots.arguments(args.toMap());
        } else {
            this.getLogger().error("Cannot setup data binding for %s because java compiler options is not an instance of AnnotationProcessorOptions", (Object)processorOptions);
        }
    }

    public void createPackagingTask(TaskFactory tasks, VariantScope variantScope, AndroidTask<BuildInfoWriterTask> fullBuildInfoGeneratorTask) {
        CoreSigningConfig signingConfig;
        ApkVariantData variantData = (ApkVariantData)variantScope.getVariantData();
        boolean signedApk = variantData.isSigned();
        GradleVariantConfiguration variantConfiguration = variantScope.getVariantConfiguration();
        InstantRunPatchingPolicy patchingPolicy = variantScope.getInstantRunBuildContext().getPatchingPolicy();
        DefaultGradlePackagingScope packagingScope = new DefaultGradlePackagingScope(variantScope);
        TaskOutputHolder.TaskOutputType manifestType = variantScope.getInstantRunBuildContext().isInInstantRunMode() ? TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS : TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS;
        boolean splitsArePossible = variantScope.getOutputScope().getMultiOutputPolicy() == MultiOutputPolicy.SPLITS;
        FileCollection manifests = variantScope.getOutput(manifestType);
        File finalApkLocation = variantScope.getApkLocation();
        File outputDirectory = splitsArePossible ? variantScope.getFullApkPackagesOutputDirectory() : finalApkLocation;
        TaskOutputHolder.TaskOutputType taskOutputType = splitsArePossible ? TaskOutputHolder.TaskOutputType.FULL_APK : TaskOutputHolder.TaskOutputType.APK;
        TaskOutputHolder.TaskOutputType resourceFilesInputType = variantScope.useResourceShrinker() ? TaskOutputHolder.TaskOutputType.SHRUNK_PROCESSED_RES : TaskOutputHolder.TaskOutputType.PROCESSED_RES;
        AndroidTask<PackageApplication> packageApp = this.androidTasks.create(tasks, new PackageApplication.StandardConfigAction(packagingScope, outputDirectory, patchingPolicy, resourceFilesInputType, variantScope.getOutput(resourceFilesInputType), manifests, manifestType, variantScope.getOutputScope(), this.globalScope.getBuildCache(), taskOutputType));
        variantScope.addTaskOutput(taskOutputType, outputDirectory, packageApp.getName());
        AndroidTask<BaseTask> packageInstantRunResources = null;
        if (variantScope.getInstantRunBuildContext().isInInstantRunMode()) {
            if (variantScope.getInstantRunBuildContext().getPatchingPolicy() == InstantRunPatchingPolicy.MULTI_APK_SEPARATE_RESOURCES) {
                packageInstantRunResources = this.androidTasks.create(tasks, new InstantRunResourcesApkBuilder.ConfigAction(resourceFilesInputType, variantScope.getOutput(resourceFilesInputType), packagingScope));
                packageInstantRunResources.dependsOn(tasks, this.getValidateSigningTask(tasks, packagingScope));
            } else {
                packageInstantRunResources = this.androidTasks.create(tasks, new PackageApplication.InstantRunResourcesConfigAction(variantScope.getInstantRunResourcesFile(), packagingScope, patchingPolicy, resourceFilesInputType, variantScope.getOutput(resourceFilesInputType), manifests, TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS, this.globalScope.getBuildCache(), variantScope.getOutputScope()));
            }
            packageApp.dependsOn(tasks, packageInstantRunResources);
        }
        Consumer<AndroidTask> configureResourcesAndAssetsDependencies = task -> {
            task.dependsOn(tasks, variantScope.getMergeAssetsTask());
            task.dependsOn(tasks, variantScope.getProcessResourcesTask());
        };
        configureResourcesAndAssetsDependencies.accept(packageApp);
        if (packageInstantRunResources != null) {
            configureResourcesAndAssetsDependencies.accept(packageInstantRunResources);
        }
        if ((signingConfig = packagingScope.getSigningConfig()) != null) {
            packageApp.dependsOn(tasks, this.getValidateSigningTask(tasks, packagingScope));
        }
        packageApp.optionalDependsOn(tasks, variantScope.getJavacTask(), variantData.packageSplitResourcesTask, variantData.packageSplitAbiTask);
        variantScope.setPackageApplicationTask(packageApp);
        variantScope.getAssembleTask().dependsOn(tasks, (Object)packageApp.getName());
        Preconditions.checkState((variantScope.getAssembleTask() != null ? 1 : 0) != 0);
        if (fullBuildInfoGeneratorTask != null) {
            AndroidTask<BaseTask> finalPackageInstantRunResources = packageInstantRunResources;
            fullBuildInfoGeneratorTask.configure(tasks, (Action<BuildInfoWriterTask>)((Action)task -> {
                task.mustRunAfter(new Object[]{packageApp.getName()});
                if (finalPackageInstantRunResources != null) {
                    task.mustRunAfter(new Object[]{finalPackageInstantRunResources.getName()});
                }
            }));
            variantScope.getAssembleTask().dependsOn(tasks, (Object)fullBuildInfoGeneratorTask.getName());
        }
        if (splitsArePossible) {
            AndroidTask<CopyOutputs> copyOutputsTask = this.androidTasks.create(tasks, new CopyOutputs.ConfigAction(new DefaultGradlePackagingScope(variantScope), finalApkLocation));
            variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.APK, finalApkLocation, copyOutputsTask.getName());
            variantScope.getAssembleTask().dependsOn(tasks, copyOutputsTask);
        }
        if (signedApk) {
            AndroidTask<InstallVariantTask> installTask = this.androidTasks.create(tasks, new InstallVariantTask.ConfigAction(variantScope));
            installTask.dependsOn(tasks, variantScope.getAssembleTask());
        }
        this.maybeCreateLintVitalTask(tasks, variantData);
        AndroidTask<UninstallTask> uninstallTask = this.androidTasks.create(tasks, new UninstallTask.ConfigAction(variantScope));
        tasks.named(UNINSTALL_ALL, (Action<? super Task>)((Action)uninstallAll -> uninstallAll.dependsOn(new Object[]{uninstallTask.getName()})));
    }

    protected AndroidTask<?> getValidateSigningTask(TaskFactory tasks, PackagingScope packagingScope) {
        ValidateSigningTask.ConfigAction configAction = new ValidateSigningTask.ConfigAction(packagingScope);
        AndroidTask<Object> validateSigningTask = this.androidTasks.get(configAction.getName());
        if (validateSigningTask == null) {
            validateSigningTask = this.androidTasks.create(tasks, configAction);
        }
        return validateSigningTask;
    }

    public AndroidTask<DefaultTask> createAssembleTask(TaskFactory tasks, BaseVariantData variantData) {
        return this.androidTasks.create(tasks, variantData.getScope().getTaskName("assemble"), (Action<Task>)((Action)task -> variantData.addTask(TaskContainer.TaskKind.ASSEMBLE, (Task)task)));
    }

    public AndroidTask<DefaultTask> createAssembleTask(TaskFactory tasks, VariantDimensionData dimensionData) {
        String sourceSetName = StringHelper.capitalize((String)dimensionData.getSourceSet().getName());
        return this.androidTasks.create(tasks, "assemble" + sourceSetName, (Action<Task>)((Action)assembleTask -> {
            assembleTask.setDescription("Assembles all " + sourceSetName + " builds.");
            assembleTask.setGroup(BUILD_GROUP);
        }));
    }

    protected void maybeCreateJavaCodeShrinkerTransform(TaskFactory taskFactory, VariantScope variantScope) {
        CodeShrinker codeShrinker = variantScope.getCodeShrinker();
        if (codeShrinker != null) {
            this.doCreateJavaCodeShrinkerTransform(taskFactory, variantScope, codeShrinker, null);
        }
    }

    protected final void doCreateJavaCodeShrinkerTransform(TaskFactory taskFactory, VariantScope variantScope, CodeShrinker codeShrinker, FileCollection mappingFileCollection) {
        Optional<AndroidTask<TransformTask>> transformTask;
        switch (codeShrinker) {
            case PROGUARD: {
                transformTask = this.createProguardTransform(taskFactory, variantScope, mappingFileCollection);
                break;
            }
            case ANDROID_GRADLE: {
                transformTask = this.createBuiltInShrinkerTransform(variantScope, taskFactory);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown value " + (Object)((Object)codeShrinker)));
            }
        }
        if (variantScope.getPostprocessingFeatures() != null && transformTask.isPresent()) {
            AndroidTask<CheckProguardFiles> checkFilesTask = this.androidTasks.create(taskFactory, new CheckProguardFiles.ConfigAction(variantScope));
            transformTask.get().dependsOn(taskFactory, checkFilesTask);
        }
    }

    private Optional<AndroidTask<TransformTask>> createBuiltInShrinkerTransform(VariantScope scope, TaskFactory taskFactory) {
        BuiltInShrinkerTransform transform = new BuiltInShrinkerTransform(scope);
        this.applyProguardConfig(transform, scope);
        if (scope.getInstantRunBuildContext().isInInstantRunMode()) {
            transform.keep("class ** extends android.app.Application {*;}");
            transform.keep("class com.android.tools.ir.** {*;}");
        }
        return scope.getTransformManager().addTransform(taskFactory, scope, transform);
    }

    private Optional<AndroidTask<TransformTask>> createProguardTransform(TaskFactory taskFactory, VariantScope variantScope, FileCollection mappingFileCollection) {
        if (variantScope.getInstantRunBuildContext().isInInstantRunMode()) {
            this.logger.warn("ProGuard is disabled for variant {} because it is not compatible with Instant Run. See http://d.android.com/r/studio-ui/shrink-code-with-ir.html for details on how to enable a code shrinker that's compatible with Instant Run.", (Object)variantScope.getVariantConfiguration().getFullName());
            return Optional.empty();
        }
        BaseVariantData testedVariantData = variantScope.getTestedVariantData();
        ProGuardTransform transform = new ProGuardTransform(variantScope);
        if (testedVariantData != null) {
            TaskManager.applyProguardDefaultsForTest(transform);
            Object[] objectArray = new Object[2];
            objectArray[0] = TaskInputHelper.bypassFileCallable(testedVariantData.getScope()::getTestProguardFiles);
            objectArray[1] = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.PROGUARD_RULES);
            transform.setConfigurationFiles((FileCollection)this.project.files(objectArray));
            VariantScope testedScope = testedVariantData.getScope();
            transform.applyTestedMapping(testedScope.hasOutput(TaskOutputHolder.TaskOutputType.APK_MAPPING) ? testedScope.getOutput(TaskOutputHolder.TaskOutputType.APK_MAPPING) : null);
        } else if (this.isTestedAppObfuscated(variantScope)) {
            TaskManager.applyProguardDefaultsForTest(transform);
            Object[] objectArray = new Object[2];
            objectArray[0] = TaskInputHelper.bypassFileCallable(variantScope::getTestProguardFiles);
            objectArray[1] = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.PROGUARD_RULES);
            transform.setConfigurationFiles((FileCollection)this.project.files(objectArray));
            transform.applyTestedMapping(mappingFileCollection);
        } else {
            this.applyProguardConfig(transform, variantScope);
            if (mappingFileCollection != null) {
                transform.applyTestedMapping(mappingFileCollection);
            }
        }
        Optional<AndroidTask<TransformTask>> task = variantScope.getTransformManager().addTransform(taskFactory, variantScope, transform);
        task.ifPresent(t -> {
            variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.APK_MAPPING, transform.getMappingFile(), t.getName());
            t.optionalDependsOn(taskFactory, mappingFileCollection);
            if (testedVariantData != null) {
                t.dependsOn(taskFactory, testedVariantData.getScope().getAssembleTask());
            }
        });
        return task;
    }

    private static void applyProguardDefaultsForTest(ProGuardTransform transform) {
        transform.setActions(PostprocessingFeatures.create(false, true, false));
        transform.keep("class * {*;}");
        transform.keep("interface * {*;}");
        transform.keep("enum * {*;}");
        transform.keepattributes();
    }

    protected void maybeCreateResourcesShrinkerTransform(TaskFactory taskFactory, VariantScope scope) {
        if (!scope.useResourceShrinker()) {
            return;
        }
        File shrinkerOutput = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"res_stripped", scope.getVariantConfiguration().getDirName()});
        ShrinkResourcesTransform shrinkResTransform = new ShrinkResourcesTransform(scope.getVariantData(), scope.getOutput(TaskOutputHolder.TaskOutputType.PROCESSED_RES), shrinkerOutput, AaptGeneration.fromProjectOptions(this.projectOptions), scope.getOutput(TaskOutputHolder.TaskOutputType.SPLIT_LIST), this.logger);
        Optional<AndroidTask<TransformTask>> shrinkTask = scope.getTransformManager().addTransform(taskFactory, scope, shrinkResTransform);
        if (shrinkTask.isPresent()) {
            scope.addTaskOutput(TaskOutputHolder.TaskOutputType.SHRUNK_PROCESSED_RES, shrinkerOutput, shrinkTask.get().getName());
        } else {
            this.androidBuilder.getErrorReporter().handleSyncError(null, 0, "Internal error, could not add the ShrinkResourcesTransform");
        }
    }

    private void applyProguardConfig(ProguardConfigurable transform, VariantScope scope) {
        GradleVariantConfiguration variantConfig = scope.getVariantConfiguration();
        PostprocessingFeatures postprocessingFeatures = scope.getPostprocessingFeatures();
        if (postprocessingFeatures != null) {
            transform.setActions(postprocessingFeatures);
        }
        Supplier<Collection<File>> proguardConfigFiles = () -> {
            HashSet proguardFiles = Sets.newHashSet(scope.getProguardFiles());
            proguardFiles.add(scope.getProcessAndroidResourcesProguardOutputFile());
            return proguardFiles;
        };
        transform.setConfigurationFiles((FileCollection)this.project.files(new Object[]{TaskInputHelper.bypassFileCallable(proguardConfigFiles), scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.PROGUARD_RULES)}));
        if (scope.getVariantData().getType() == VariantType.LIBRARY) {
            transform.keep("class **.R");
            transform.keep("class **.R$*");
        }
        if (variantConfig.isTestCoverageEnabled()) {
            transform.keep("class com.vladium.** {*;}");
            transform.keep("class org.jacoco.** {*;}");
            transform.keep("interface org.jacoco.** {*;}");
            transform.dontwarn("org.jacoco.**");
        }
    }

    public void createReportTasks(TaskFactory tasks, List<VariantScope> variantScopes) {
        this.androidTasks.create(tasks, "androidDependencies", DependencyReportTask.class, task -> {
            task.setDescription("Displays the Android dependencies of the project.");
            task.setVariants(variantScopes);
            task.setGroup(ANDROID_GROUP);
        });
        this.androidTasks.create(tasks, "signingReport", SigningReportTask.class, task -> {
            task.setDescription("Displays the signing info for each variant.");
            task.setVariants(variantScopes);
            task.setGroup(ANDROID_GROUP);
        });
    }

    public void createAnchorTasks(TaskFactory tasks, VariantScope scope) {
        this.createPreBuildTasks(tasks, scope);
        BaseVariantData variantData = scope.getVariantData();
        scope.setSourceGenTask(this.androidTasks.create(tasks, scope.getTaskName("generate", "Sources"), Task.class, task -> {
            variantData.sourceGenTask = task;
        }));
        scope.setResourceGenTask(this.androidTasks.create(tasks, scope.getTaskName("generate", "Resources"), Task.class, task -> {
            variantData.resourceGenTask = task;
        }));
        scope.setAssetGenTask(this.androidTasks.create(tasks, scope.getTaskName("generate", "Assets"), Task.class, task -> {
            variantData.assetGenTask = task;
        }));
        if (!variantData.getType().isForTesting() && ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isTestCoverageEnabled()) {
            scope.setCoverageReportTask(this.androidTasks.create(tasks, scope.getTaskName("create", "CoverageReport"), Task.class, task -> {
                task.setGroup("verification");
                task.setDescription(String.format("Creates test coverage reports for the %s variant.", variantData.getName()));
            }));
        }
        this.createCompileAnchorTask(tasks, scope);
    }

    protected AndroidTask<? extends DefaultTask> createVariantPreBuildTask(TaskFactory tasks, VariantScope scope) {
        return this.createDefaultPreBuildTask(tasks, scope);
    }

    protected AndroidTask<? extends DefaultTask> createDefaultPreBuildTask(TaskFactory tasks, VariantScope scope) {
        return this.getAndroidTasks().create(tasks, scope.getTaskName("pre", "Build"), (Action<Task>)((Action)task -> {
            scope.getVariantData().preBuildTask = task;
        }));
    }

    private void createPreBuildTasks(TaskFactory tasks, VariantScope scope) {
        scope.setPreBuildTask(this.createVariantPreBuildTask(tasks, scope));
        scope.getPreBuildTask().dependsOn(tasks, (Object)MAIN_PREBUILD);
        if (this.runJavaCodeShrinker(scope)) {
            scope.getPreBuildTask().dependsOn(tasks, (Object)EXTRACT_PROGUARD_FILES);
        }
    }

    private void createCompileAnchorTask(TaskFactory tasks, final VariantScope scope) {
        final BaseVariantData variantData = scope.getVariantData();
        scope.setCompileTask(this.androidTasks.create(tasks, new TaskConfigAction<Task>(){

            @Override
            public String getName() {
                return scope.getTaskName("compile", "Sources");
            }

            @Override
            public Class<Task> getType() {
                return Task.class;
            }

            @Override
            public void execute(Task task) {
                variantData.compileTask = task;
                variantData.compileTask.setGroup(TaskManager.BUILD_GROUP);
            }
        }));
        scope.getAssembleTask().dependsOn(tasks, scope.getCompileTask());
    }

    public void createCheckManifestTask(TaskFactory tasks, VariantScope scope) {
        scope.setCheckManifestTask(this.androidTasks.create(tasks, this.getCheckManifestConfig(scope)));
        scope.getCheckManifestTask().dependsOn(tasks, scope.getPreBuildTask());
    }

    protected CheckManifest.ConfigAction getCheckManifestConfig(VariantScope scope) {
        return new CheckManifest.ConfigAction(scope, false);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public AndroidTaskRegistry getAndroidTasks() {
        return this.androidTasks;
    }

    public void addDataBindingDependenciesIfNecessary(DataBindingOptions options) {
        if (!options.isEnabled()) {
            return;
        }
        String version = (String)MoreObjects.firstNonNull((Object)options.getVersion(), (Object)this.dataBindingBuilder.getCompilerVersion());
        this.project.getDependencies().add("api", (Object)("com.android.databinding:library:" + this.dataBindingBuilder.getLibraryVersion(version)));
        this.project.getDependencies().add("api", (Object)("com.android.databinding:baseLibrary:" + this.dataBindingBuilder.getBaseLibraryVersion(version)));
        this.project.getDependencies().add("annotationProcessor", (Object)("com.android.databinding:compiler:" + version));
        if (options.isEnabledForTests() || this instanceof LibraryTaskManager) {
            this.project.getDependencies().add("androidTestAnnotationProcessor", (Object)("com.android.databinding:compiler:" + version));
        }
        if (options.getAddDefaultAdapters()) {
            this.project.getDependencies().add("api", (Object)("com.android.databinding:adapters:" + this.dataBindingBuilder.getBaseAdaptersVersion(version)));
        }
    }

    protected void configureTestData(AbstractTestDataImpl testData) {
        testData.setAnimationsDisabled(this.extension.getTestOptions().getAnimationsDisabled());
    }

    public static enum MergeType {
        MERGE{

            @Override
            public TaskOutputHolder.TaskOutputType getOutputType() {
                return TaskOutputHolder.TaskOutputType.MERGED_RES;
            }
        }
        ,
        PACKAGE{

            @Override
            public TaskOutputHolder.TaskOutputType getOutputType() {
                return TaskOutputHolder.TaskOutputType.PACKAGED_RES;
            }
        };


        public abstract TaskOutputHolder.TaskOutputType getOutputType();
    }

    public static class ConfigAttrTask
    extends DefaultTask {
        boolean consumable = false;
        boolean resolvable = false;

        @TaskAction
        public void run() {
            for (Configuration config : this.getProject().getConfigurations()) {
                AttributeContainer attributes = config.getAttributes();
                if ((!this.consumable || !config.isCanBeConsumed()) && (!this.resolvable || !config.isCanBeResolved())) continue;
                System.out.println(config.getName());
                System.out.println("\tcanBeResolved: " + config.isCanBeResolved());
                System.out.println("\tcanBeConsumed: " + config.isCanBeConsumed());
                for (Attribute attr : attributes.keySet()) {
                    System.out.println("\t" + attr.getName() + ": " + attributes.getAttribute(attr));
                }
                if (!this.consumable || !config.isCanBeConsumed()) continue;
                for (PublishArtifact artifact : config.getArtifacts()) {
                    System.out.println("\tArtifact: " + artifact.getName() + " (" + artifact.getFile().getName() + ")");
                }
                for (ConfigurationVariant cv : config.getOutgoing().getVariants()) {
                    System.out.println("\tConfigurationVariant: " + cv.getName());
                    for (PublishArtifact pa : cv.getArtifacts()) {
                        System.out.println("\t\tArtifact: " + pa.getFile());
                        System.out.println("\t\tType:" + pa.getType());
                    }
                }
            }
        }
    }
}

