/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.options;

import com.android.build.gradle.options.Option;

public enum BooleanOption implements Option<Boolean>
{
    ENABLE_AAPT2("android.enableAapt2", true),
    ENABLE_IN_PROCESS_AAPT2("android.enableAapt2jni", true),
    ENABLE_DAEMON_MODE_AAPT2("android.enableAapt2DaemonMode", false),
    ENABLE_BUILD_CACHE("android.enableBuildCache", true),
    ENABLE_PROFILE_JSON("android.enableProfileJson", true),
    ENABLE_SDK_DOWNLOAD("android.builder.sdkDownload", true),
    ENABLE_TEST_SHARDING("android.androidTest.shardBetweenDevices"),
    ENABLE_DEX_ARCHIVE("android.useDexArchive", true),
    ENABLE_NEW_RESOURCE_PROCESSING("android.enableNewResourceProcessing", true),
    ENABLE_IMPROVED_DEPENDENCY_RESOLUTION("android.enableImprovedDependenciesResolution", true),
    ENABLE_INTERMEDIATE_ARTIFACTS_CACHE("android.enableIntermediateArtifactsCache", true),
    ENABLE_EXTRACT_ANNOTATIONS("android.enableExtractAnnotations", true),
    VERSION_CHECK_OVERRIDE_PROPERTY("android.overrideVersionCheck"),
    VERSION_CHECK_OVERRIDE_PROPERTY_OLD("com.android.build.gradle.overrideVersionCheck"),
    OVERRIDE_PATH_CHECK_PROPERTY("android.overridePathCheck"),
    OVERRIDE_PATH_CHECK_PROPERTY_OLD("com.android.build.gradle.overridePathCheck"),
    ENABLE_DESUGAR("android.enableDesugar", true),
    ENABLE_GRADLE_WORKERS("android.enableGradleWorkers", false),
    DISABLE_RES_MERGE_IN_LIBRARY("android.disable.res.merge", true),
    ENABLE_D8("android.enableD8", false),
    ENABLE_DEPRECATED_NDK("android.useDeprecatedNdk"),
    DISABLE_RESOURCE_VALIDATION("android.disableResourceValidation"),
    BUILD_ONLY_TARGET_ABI("android.buildOnlyTargetAbi", true),
    KEEP_TIMESTAMPS_IN_APK("android.keepTimestampsInApk"),
    IDE_INVOKED_FROM_IDE("android.injected.invoked.from.ide"),
    IDE_BUILD_MODEL_ONLY("android.injected.build.model.only"),
    IDE_BUILD_MODEL_ONLY_ADVANCED("android.injected.build.model.only.advanced"),
    IDE_BUILD_MODEL_FEATURE_FULL_DEPENDENCIES("android.injected.build.model.feature.full.dependencies"),
    IDE_REFRESH_EXTERNAL_NATIVE_MODEL("android.injected.refresh.external.native.model"),
    IDE_GENERATE_SOURCES_ONLY("android.injected.generateSourcesOnly"),
    ENABLE_SEPARATE_APK_RESOURCES("android.enableSeparateApkRes", false);

    private final String propertyName;
    private final boolean defaultValue;

    private BooleanOption(String propertyName) {
        this(propertyName, false);
    }

    private BooleanOption(String propertyName, boolean defaultValue) {
        this.propertyName = propertyName;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Boolean parse(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof CharSequence) {
            return Boolean.parseBoolean(value.toString());
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        throw new IllegalArgumentException("Cannot parse project property " + this.getPropertyName() + "='" + value + "' of type '" + value.getClass() + "' as boolean.");
    }
}

