/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;

abstract class CmakeExternalNativeJsonGenerator
extends ExternalNativeJsonGenerator {
    private static final Pattern cmakeFileFinder = Pattern.compile("^(.*CMake (Error|Warning).* at\\s+)([^:]+)(:.*)$", 32);
    final File cmakeInstallFolder;

    CmakeExternalNativeJsonGenerator(NdkHandler ndkHandler, int minSdkVersion, String variantName, Collection<Abi> abis, AndroidBuilder androidBuilder, File sdkFolder, File ndkFolder, File soFolder, File objFolder, File jsonFolder, File makeFile, File cmakeInstallFolder, boolean debuggable, List<String> buildArguments, List<String> cFlags, List<String> cppFlags, List<File> nativeBuildConfigurationsJsons) {
        super(ndkHandler, minSdkVersion, variantName, abis, androidBuilder, sdkFolder, ndkFolder, soFolder, objFolder, jsonFolder, makeFile, debuggable, buildArguments, cFlags, cppFlags, nativeBuildConfigurationsJsons);
        this.cmakeInstallFolder = cmakeInstallFolder;
    }

    abstract List<String> getCacheArguments(String var1, int var2);

    @Override
    void processBuildOutput(String buildOutput, String abi, int abiPlatformVersion) throws IOException {
    }

    @Override
    ProcessInfoBuilder getProcessBuilder(String abi, int abiPlatformVersion, File outputJson) {
        this.checkConfiguration();
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        File cmakeListsFolder = this.getMakefile().getParentFile();
        builder.setExecutable(this.getSdkCmakeExecutable());
        builder.addArgs(String.format("-H%s", cmakeListsFolder));
        builder.addArgs(String.format("-B%s", outputJson.getParentFile()));
        builder.addArgs(this.getCacheArguments(abi, abiPlatformVersion));
        return builder;
    }

    protected List<String> getCommonCacheArguments(String abi, int abiPlatformVersion) {
        ArrayList cacheArguments = Lists.newArrayList();
        cacheArguments.add("-DCMAKE_SYSTEM_NAME=Android");
        cacheArguments.add(String.format("-DANDROID_ABI=%s", abi));
        cacheArguments.add(String.format("-DANDROID_PLATFORM=android-%s", abiPlatformVersion));
        cacheArguments.add(String.format("-DCMAKE_LIBRARY_OUTPUT_DIRECTORY=%s", new File(this.getObjFolder(), abi)));
        cacheArguments.add(String.format("-DCMAKE_BUILD_TYPE=%s", this.isDebuggable() ? "Debug" : "Release"));
        cacheArguments.add(String.format("-DANDROID_NDK=%s", this.getNdkFolder()));
        if (!this.getcFlags().isEmpty()) {
            cacheArguments.add(String.format("-DCMAKE_C_FLAGS=%s", Joiner.on((String)" ").join(this.getcFlags())));
        }
        if (!this.getCppFlags().isEmpty()) {
            cacheArguments.add(String.format("-DCMAKE_CXX_FLAGS=%s", Joiner.on((String)" ").join(this.getCppFlags())));
        }
        cacheArguments.addAll(this.getBuildArguments());
        return cacheArguments;
    }

    public File getCompileCommandsJson(String abi) {
        return ExternalNativeBuildTaskUtils.getCompileCommandsJson(this.getJsonFolder(), abi);
    }

    @Override
    public NativeBuildSystem getNativeBuildSystem() {
        return NativeBuildSystem.CMAKE;
    }

    @Override
    Map<Abi, File> getStlSharedObjectFiles() {
        String stl = null;
        File ndkBasePath = null;
        for (String argument : this.getBuildArguments()) {
            if ((argument = argument.replace(" ", "")).equals("-DANDROID_STL=stlport_shared")) {
                stl = "stlport";
                ndkBasePath = FileUtils.join((File)this.getNdkFolder(), (String[])new String[]{"sources", "cxx-stl", "stlport"});
                continue;
            }
            if (argument.equals("-DANDROID_STL=gnustl_shared")) {
                stl = "gnustl";
                ndkBasePath = FileUtils.join((File)this.getNdkFolder(), (String[])new String[]{"sources", "cxx-stl", "gnu-libstdc++", "4.9"});
                continue;
            }
            if (!argument.equals("-DANDROID_STL=c++_shared")) continue;
            stl = "c++";
            ndkBasePath = FileUtils.join((File)this.getNdkFolder(), (String[])new String[]{"sources", "cxx-stl", "llvm-libc++"});
        }
        HashMap result = Maps.newHashMap();
        if (stl == null) {
            return result;
        }
        for (Abi abi : this.getAbis()) {
            File file = FileUtils.join((File)ndkBasePath, (String[])new String[]{"libs", abi.getName(), String.format("lib%s_shared.so", stl)});
            Preconditions.checkState((boolean)file.isFile(), (String)"Expected NDK STL shared object file at %s", (Object)file.toString());
            result.put(abi, file);
        }
        return result;
    }

    static String correctMakefilePaths(String input, File makeFileDirectory) {
        Matcher cmakeFinderMatcher = cmakeFileFinder.matcher(input);
        if (cmakeFinderMatcher.matches()) {
            ArrayList<String> corrected = new ArrayList<String>();
            for (String entry : input.split("\n")) {
                cmakeFinderMatcher = cmakeFileFinder.matcher(entry);
                if (cmakeFinderMatcher.matches()) {
                    String fileName = cmakeFinderMatcher.group(3);
                    File makeFile = new File(fileName);
                    if (makeFile.isAbsolute()) {
                        corrected.add(entry);
                        continue;
                    }
                    makeFile = new File(makeFileDirectory, fileName);
                    if (!makeFile.exists()) {
                        corrected.add(entry);
                        continue;
                    }
                    corrected.add(cmakeFinderMatcher.group(1) + makeFile.getAbsolutePath() + cmakeFinderMatcher.group(4));
                    continue;
                }
                corrected.add(entry);
            }
            return Joiner.on((char)'\n').join(corrected);
        }
        return input;
    }

    protected File getToolChainFile() {
        String toolchainFileName = "android.toolchain.cmake";
        File ndkCmakeFolder = new File(new File(this.getNdkFolder(), "build"), "cmake");
        File toolchainFile = new File(ndkCmakeFolder, toolchainFileName);
        if (!toolchainFile.exists()) {
            toolchainFile = new File(this.getCmakeInstallFolder(), toolchainFileName);
        }
        return toolchainFile;
    }

    protected File getSdkCmakeFolder() {
        return CmakeExternalNativeJsonGenerator.getCmakeFolderFromSdkFolder(this.getSdkFolder());
    }

    protected File getCmakeBinFolder() {
        return new File(this.getCmakeInstallFolder(), "bin");
    }

    protected File getCmakeExecutable() {
        if (CmakeExternalNativeJsonGenerator.isWindows()) {
            return new File(this.getCmakeBinFolder(), "cmake.exe");
        }
        return new File(this.getCmakeBinFolder(), "cmake");
    }

    private void checkConfiguration() {
        List<String> configurationErrors = this.getConfigurationErrors();
        if (!configurationErrors.isEmpty()) {
            throw new GradleException(Joiner.on((String)"\n").join(configurationErrors));
        }
    }

    private List<String> getConfigurationErrors() {
        ArrayList messages = Lists.newArrayList();
        String cmakeListsTxt = "CMakeLists.txt";
        if (this.getMakefile().isDirectory()) {
            messages.add(String.format("Gradle project cmake.path %s is a folder. It must be %s", this.getMakefile(), cmakeListsTxt));
        } else if (this.getMakefile().isFile()) {
            String filename = this.getMakefile().getName();
            if (!filename.equals(cmakeListsTxt)) {
                messages.add(String.format("Gradle project cmake.path specifies %s but it must be %s", filename, cmakeListsTxt));
            }
        } else {
            messages.add(String.format("Gradle project cmake.path is %s but that file doesn't exist", this.getMakefile()));
        }
        messages.addAll(this.getBaseConfigurationErrors());
        return messages;
    }

    private File getCmakeInstallFolder() {
        return this.cmakeInstallFolder;
    }

    protected File getSdkCmakeExecutable() {
        return CmakeExternalNativeJsonGenerator.getSdkCmakeExecutable(this.getSdkFolder());
    }

    protected File getSdkCmakeBinFolder() {
        return CmakeExternalNativeJsonGenerator.getSdkCmakeBinFolder(this.getSdkFolder());
    }
}

