/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import android.databinding.tool.util.Preconditions;
import com.android.build.gradle.internal.pipeline.IntermediateStream;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitivity;

public class StreamBasedTask
extends BaseTask {
    protected Collection<TransformStream> consumedInputStreams;
    protected Collection<TransformStream> referencedInputStreams;
    protected IntermediateStream outputStream;

    @Optional
    @OutputDirectory
    public File getStreamOutputFolder() {
        if (this.outputStream != null) {
            return this.outputStream.getRootLocation();
        }
        return null;
    }

    protected void registerConsumedAndReferencedStreamInputs() {
        Preconditions.checkNotNull(this.consumedInputStreams, (String)"Consumed input streams not set.", (Object[])new Object[0]);
        Preconditions.checkNotNull(this.referencedInputStreams, (String)"Referenced input streams not set.", (Object[])new Object[0]);
        ArrayList<String> inputNames = new ArrayList<String>(this.consumedInputStreams.size() + this.referencedInputStreams.size());
        for (TransformStream stream : Iterables.concat(this.consumedInputStreams, this.referencedInputStreams)) {
            this.getInputs().files(new Object[]{stream.getAsFileTree()}).withPathSensitivity(PathSensitivity.RELATIVE);
            inputNames.add(stream.getName());
        }
        Collections.sort(inputNames);
        this.getInputs().property("transformInputNames", inputNames);
    }
}

