/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.FileUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.tooling.BuildException;

public class OutputScope
implements Serializable {
    private final MultiOutputPolicy multiOutputPolicy;
    private final List<ApkData> apkDatas;
    private final SetMultimap<TaskOutputHolder.OutputType, BuildOutput> splitOutputs = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    public OutputScope(MultiOutputPolicy multiOutputPolicy) {
        this.multiOutputPolicy = multiOutputPolicy;
        this.apkDatas = new ArrayList<ApkData>();
    }

    public OutputScope(MultiOutputPolicy multiOutputPolicy, Collection<ApkData> apkDatas) {
        this.multiOutputPolicy = multiOutputPolicy;
        this.apkDatas = new ArrayList<ApkData>(apkDatas);
    }

    public MultiOutputPolicy getMultiOutputPolicy() {
        return this.multiOutputPolicy;
    }

    void addSplit(ApkData apkData) {
        this.apkDatas.add(apkData);
    }

    public List<ApkData> getApkDatas() {
        return this.apkDatas.stream().filter(ApkData::isEnabled).collect(Collectors.toList());
    }

    public ApkData getSplit(Collection<FilterData> filters) {
        for (ApkData apkData : this.apkDatas) {
            if (!apkData.getFilters().equals(filters)) continue;
            return apkData;
        }
        return null;
    }

    public ApkData getMainSplit() {
        List<ApkData> splitsByType = this.getSplitsByType(VariantOutput.OutputType.MAIN);
        if (!splitsByType.isEmpty()) {
            return splitsByType.get(0);
        }
        Optional<ApkData> universal = this.getApkDatas().stream().filter(split -> split.getFilterName().equals("universal")).findFirst();
        if (universal.isPresent()) {
            return universal.get();
        }
        Optional<ApkData> firstFullSplit = this.getApkDatas().stream().filter(split -> split.getType() == VariantOutput.OutputType.FULL_SPLIT).findFirst();
        return firstFullSplit.orElse(null);
    }

    public List<ApkData> getSplitsByType(VariantOutput.OutputType outputType) {
        return this.apkDatas.stream().filter(split -> split.getType() == outputType).collect(Collectors.toList());
    }

    public void parallelForEach(TaskOutputHolder.OutputType outputType, SplitAction action2) throws IOException {
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        this.apkDatas.forEach(split -> executor.execute(() -> {
            this.addOutputForSplit(outputType, (ApkData)split, action2.processSplit((ApkData)split));
            return null;
        }));
        try {
            List taskResults = executor.waitForAllTasks();
            taskResults.forEach(taskResult -> {
                if (taskResult.getException() != null) {
                    throw new BuildException(taskResult.getException().getMessage(), taskResult.getException());
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public void deleteAllEntries(TaskOutputHolder.OutputType outputType) {
        this.splitOutputs.removeAll((Object)outputType);
    }

    public void parallelForEachOutput(Collection<BuildOutput> inputs, TaskOutputHolder.OutputType inputType, TaskOutputHolder.OutputType outputType, SplitOutputAction action2) {
        this.parallelForEachOutput(inputs, inputType, outputType, (apkData, output, param) -> action2.processSplit(apkData, output), null);
    }

    public <T> void parallelForEachOutput(Collection<BuildOutput> inputs, TaskOutputHolder.OutputType inputType, TaskOutputHolder.OutputType outputType, ParameterizedSplitOutputAction<T> action2, T parameter) {
        this.parallelForEachOutput(inputs, inputType, outputType, (apkData, output, paramOne, paramTwo) -> action2.processSplit(apkData, output, paramOne), parameter, null);
    }

    public <T, U> void parallelForEachOutput(Collection<BuildOutput> inputs, TaskOutputHolder.OutputType inputType, TaskOutputHolder.OutputType outputType, TwoParameterizedSplitOutputAction<T, U> action2, T parameterOne, U parameterTwo) {
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        this.apkDatas.forEach(split -> executor.execute(() -> {
            BuildOutput buildOutput = OutputScope.getOutput(inputs, inputType, (ApkInfo)split);
            if (buildOutput != null) {
                this.addOutputForSplit(outputType, (ApkData)split, action2.processSplit((ApkData)split, buildOutput.getOutputFile(), parameterOne, parameterTwo), buildOutput.getProperties());
            }
            return null;
        }));
        try {
            List taskResults = executor.waitForAllTasks();
            taskResults.forEach(taskResult -> {
                if (taskResult.getException() != null) {
                    throw new BuildException(taskResult.getException().getMessage(), taskResult.getException());
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public void save(TaskOutputHolder.OutputType outputType, File folder) throws IOException {
        this.save((ImmutableList<TaskOutputHolder.OutputType>)ImmutableList.of((Object)outputType), folder);
    }

    public void save(ImmutableList<TaskOutputHolder.OutputType> outputTypes, File folder) throws IOException {
        String persistedString = BuildOutputs.persist(folder.toPath(), outputTypes, this.splitOutputs);
        if (persistedString.isEmpty()) {
            return;
        }
        FileUtils.mkdirs((File)folder);
        try (FileWriter writer = new FileWriter(BuildOutputs.getMetadataFile(folder));){
            ((Writer)writer).append(persistedString);
        }
    }

    public static BuildOutput getOutput(Collection<BuildOutput> buildOutputs, TaskOutputHolder.OutputType outputType, ApkInfo apkData) {
        Optional<BuildOutput> matchingOutput = buildOutputs.stream().filter(splitOutput -> splitOutput.getType() == outputType && splitOutput.getApkInfo().getType() == apkData.getType() && splitOutput.getFilters().equals(apkData.getFilters())).findFirst();
        return matchingOutput.orElse(null);
    }

    public static BuildOutput getOutput(Collection<BuildOutput> buildOutputs, TaskOutputHolder.OutputType outputType, VariantOutput.OutputType apkType) {
        Optional<BuildOutput> matchingOutput = buildOutputs.stream().filter(splitOutput -> splitOutput.getType() == outputType && splitOutput.getApkInfo().getType() == apkType).findFirst();
        return matchingOutput.orElse(null);
    }

    public Collection<BuildOutput> getOutputs(TaskOutputHolder.OutputType outputType) {
        return this.splitOutputs.get((Object)outputType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OutputScope that = (OutputScope)o;
        return Objects.equals(this.splitOutputs, that.splitOutputs) && Objects.equals(this.apkDatas, that.apkDatas) && this.multiOutputPolicy == that.multiOutputPolicy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.splitOutputs, this.apkDatas, this.multiOutputPolicy});
    }

    public void addOutputForSplit(TaskOutputHolder.OutputType outputType, ApkData apkData, File outputFile) {
        if (outputFile != null) {
            this.splitOutputs.put((Object)outputType, (Object)new BuildOutput(outputType, (ApkInfo)apkData, outputFile));
        }
    }

    public void addOutputForSplit(TaskOutputHolder.OutputType outputType, ApkData apkData, File outputFile, Map<String, String> properties) {
        if (outputFile != null) {
            this.splitOutputs.put((Object)outputType, (Object)new BuildOutput(outputType, (ApkInfo)apkData, outputFile, properties));
        }
    }

    public String persist(Path outputPath, ImmutableList<TaskOutputHolder.OutputType> outputTypes) {
        return BuildOutputs.persist(outputPath, outputTypes, this.splitOutputs);
    }

    public static interface SplitOutputAction {
        public File processSplit(ApkData var1, File var2) throws IOException;
    }

    public static interface TwoParameterizedSplitOutputAction<T, U> {
        public File processSplit(ApkData var1, File var2, T var3, U var4) throws IOException;
    }

    public static interface ParameterizedSplitOutputAction<T> {
        public File processSplit(ApkData var1, File var2, T var3) throws IOException;
    }

    public static interface SplitAction {
        public File processSplit(ApkData var1) throws IOException;
    }
}

