/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.DexMergerTransformCallable;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.builder.core.ErrorReporter;
import com.android.builder.dexing.DexMergerTool;
import com.android.builder.dexing.DexingType;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.DexParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import org.gradle.api.file.FileCollection;

public class DexMergerTransform
extends Transform {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(DexMergerTransform.class);
    public static final int ANDROID_L_MAX_DEX_FILES = 100;
    public static final int EXTERNAL_DEPS_DEX_FILES = 50;
    private final DexingType dexingType;
    private final FileCollection mainDexListFile;
    private final DexMergerTool dexMerger;
    private final int minSdkVersion;
    private final boolean isDebuggable;
    private final ErrorReporter errorReporter;
    private final ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();

    public DexMergerTransform(DexingType dexingType, FileCollection mainDexListFile, ErrorReporter errorReporter, DexMergerTool dexMerger, int minSdkVersion, boolean isDebuggable) {
        this.dexingType = dexingType;
        this.mainDexListFile = mainDexListFile;
        this.dexMerger = dexMerger;
        this.minSdkVersion = minSdkVersion;
        this.isDebuggable = isDebuggable;
        Preconditions.checkState((dexingType == DexingType.LEGACY_MULTIDEX == (mainDexListFile != null) ? 1 : 0) != 0, (Object)"Main dex list must only be set when in legacy multidex");
        this.errorReporter = errorReporter;
    }

    public String getName() {
        return "dexMerger";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE));
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return TransformManager.CONTENT_DEX;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_WITH_IR_FOR_DEXING;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        if (this.mainDexListFile != null) {
            return ImmutableList.of((Object)SecondaryFile.nonIncremental((FileCollection)this.mainDexListFile));
        }
        return ImmutableList.of();
    }

    public Map<String, Object> getParameterInputs() {
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("dexing-type", this.dexingType.name());
        params.put("dex-merger-tool", this.dexMerger.name());
        return params;
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean isCacheable() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, IOException, InterruptedException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider, (Object)("Missing output object for transform " + this.getName()));
        if (this.dexMerger == DexMergerTool.D8) {
            logger.info("D8 is used to merge dex.", new Object[0]);
        }
        ParsingProcessOutputHandler outputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new DexParser(), Message.Kind.ERROR, (ILogger)logger), new ToolOutputParser((PatternAwareOutputParser)new DexParser(), (ILogger)logger), new MessageReceiver[]{this.errorReporter});
        if (!transformInvocation.isIncremental()) {
            outputProvider.deleteAll();
        }
        ProcessOutput output = null;
        try (ProcessOutput ignored = output = outputHandler.createOutput();){
            List<ForkJoinTask<Void>> mergeTasks = this.dexingType == DexingType.NATIVE_MULTIDEX ? this.handleNativeMultiDex(transformInvocation.getInputs(), output, outputProvider, transformInvocation.isIncremental()) : this.handleLegacyAndMonoDex(transformInvocation.getInputs(), output, outputProvider);
            mergeTasks.forEach(ForkJoinTask::join);
        }
        catch (IOException e) {
            throw new TransformException((Throwable)e);
        }
        catch (Exception e) {
            throw new TransformException(Throwables.getRootCause((Throwable)e));
        }
        finally {
            if (output != null) {
                try {
                    outputHandler.handleOutput(output);
                }
                catch (ProcessException processException) {}
            }
        }
    }

    private List<ForkJoinTask<Void>> handleLegacyAndMonoDex(Collection<TransformInput> inputs, ProcessOutput output, TransformOutputProvider outputProvider) throws IOException {
        ImmutableList.Builder dexArchiveBuilder = ImmutableList.builder();
        TransformInputUtil.getDirectories(inputs).stream().map(File::toPath).forEach(arg_0 -> ((ImmutableList.Builder)dexArchiveBuilder).add(arg_0));
        inputs.stream().flatMap(transformInput -> transformInput.getJarInputs().stream()).filter(jarInput -> jarInput.getStatus() != Status.REMOVED).map(jarInput -> jarInput.getFile().toPath()).forEach(arg_0 -> ((ImmutableList.Builder)dexArchiveBuilder).add(arg_0));
        ImmutableList dexesToMerge = dexArchiveBuilder.build();
        if (dexesToMerge.isEmpty()) {
            return ImmutableList.of();
        }
        File outputDir = this.getDexOutputLocation(outputProvider, "main", TransformManager.SCOPE_FULL_PROJECT);
        FileUtils.cleanOutputDir((File)outputDir);
        Path mainDexClasses = this.mainDexListFile == null ? null : this.mainDexListFile.getSingleFile().toPath();
        return ImmutableList.of(this.submitForMerging(output, outputDir, (Iterable<Path>)dexesToMerge, mainDexClasses));
    }

    private List<ForkJoinTask<Void>> handleNativeMultiDex(Collection<TransformInput> inputs, ProcessOutput output, TransformOutputProvider outputProvider, boolean isIncremental) throws IOException {
        ImmutableList.Builder subTasks = ImmutableList.builder();
        ArrayList<DirectoryInput> directoryInputs = new ArrayList<DirectoryInput>();
        ArrayList<JarInput> externalLibs = new ArrayList<JarInput>();
        ArrayList<JarInput> nonExternalJars = new ArrayList<JarInput>();
        DexMergerTransform.collectInputsForNativeMultiDex(inputs, directoryInputs, externalLibs, nonExternalJars);
        boolean mergeAllInputs = this.shouldMergeInputsForNative(directoryInputs, nonExternalJars);
        subTasks.addAll(this.processDirectories(output, outputProvider, isIncremental, directoryInputs, mergeAllInputs));
        if (mergeAllInputs) {
            subTasks.addAll(this.processNonExternalJarsTogether(output, outputProvider, isIncremental, nonExternalJars));
        } else {
            subTasks.addAll(this.processNonExternalJarsSeparately(output, outputProvider, isIncremental, nonExternalJars));
        }
        subTasks.addAll(this.processExternalJars(output, outputProvider, isIncremental, externalLibs));
        return subTasks.build();
    }

    private boolean shouldMergeInputsForNative(Collection<DirectoryInput> directories, Collection<JarInput> nonExternalJars) {
        long nonExternalJarCount;
        if (this.minSdkVersion > 22) {
            return false;
        }
        long dirInputsCount = directories.stream().filter(d -> d.getFile().exists()).count();
        return dirInputsCount + (nonExternalJarCount = nonExternalJars.stream().filter(d -> d.getStatus() != Status.REMOVED).count()) > 50L;
    }

    private static void collectInputsForNativeMultiDex(Collection<TransformInput> inputs, Collection<DirectoryInput> directoryInputs, Collection<JarInput> externalLibs, Collection<JarInput> nonExternalJars) {
        for (TransformInput input : inputs) {
            directoryInputs.addAll(input.getDirectoryInputs());
            for (JarInput jarInput : input.getJarInputs()) {
                if (jarInput.getScopes().equals(Collections.singleton(QualifiedContent.Scope.EXTERNAL_LIBRARIES))) {
                    externalLibs.add(jarInput);
                    continue;
                }
                nonExternalJars.add(jarInput);
            }
        }
    }

    private List<ForkJoinTask<Void>> processNonExternalJarsSeparately(ProcessOutput output, TransformOutputProvider outputProvider, boolean isIncremental, Collection<JarInput> inputs) throws IOException {
        ImmutableList.Builder subTasks = ImmutableList.builder();
        for (JarInput jarInput : inputs) {
            File dexOutput = this.getDexOutputLocation(outputProvider, jarInput.getName(), jarInput.getScopes());
            if (!isIncremental || jarInput.getStatus() != Status.NOTCHANGED) {
                FileUtils.cleanOutputDir((File)dexOutput);
            }
            if (isIncremental && jarInput.getStatus() != Status.ADDED && jarInput.getStatus() != Status.CHANGED) continue;
            subTasks.add(this.submitForMerging(output, dexOutput, (Iterable<Path>)ImmutableList.of((Object)jarInput.getFile().toPath()), null));
        }
        return subTasks.build();
    }

    private List<ForkJoinTask<Void>> processNonExternalJarsTogether(ProcessOutput output, TransformOutputProvider outputProvider, boolean isIncremental, Collection<JarInput> inputs) throws IOException {
        Map<Status, List<JarInput>> byStatus = inputs.stream().collect(Collectors.groupingBy(JarInput::getStatus));
        for (Status s : Status.values()) {
            byStatus.putIfAbsent(s, (List<JarInput>)ImmutableList.of());
        }
        if (isIncremental && byStatus.keySet().equals(Collections.singleton(Status.NOTCHANGED))) {
            return ImmutableList.of();
        }
        Set allScopes = inputs.stream().map(QualifiedContent::getScopes).flatMap(Collection::stream).collect(Collectors.toSet());
        File mergedOutput = this.getDexOutputLocation(outputProvider, "nonExternalJars", allScopes);
        FileUtils.cleanOutputDir((File)mergedOutput);
        ArrayList<Path> toMerge = new ArrayList<Path>(byStatus.get(Status.CHANGED).size() + byStatus.get(Status.NOTCHANGED).size() + byStatus.get(Status.ADDED).size());
        for (JarInput input : Iterables.concat((Iterable)byStatus.get(Status.CHANGED), (Iterable)byStatus.get(Status.NOTCHANGED), (Iterable)byStatus.get(Status.ADDED))) {
            toMerge.add(input.getFile().toPath());
        }
        if (!toMerge.isEmpty()) {
            return ImmutableList.of(this.submitForMerging(output, mergedOutput, toMerge, null));
        }
        return ImmutableList.of();
    }

    private List<ForkJoinTask<Void>> processDirectories(ProcessOutput output, TransformOutputProvider outputProvider, boolean isIncremental, Collection<DirectoryInput> inputs, boolean mergeAllInputs) throws IOException {
        ImmutableList.Builder subTasks = ImmutableList.builder();
        ArrayList<DirectoryInput> deleted = new ArrayList<DirectoryInput>();
        ArrayList<DirectoryInput> changed = new ArrayList<DirectoryInput>();
        ArrayList<DirectoryInput> notChanged = new ArrayList<DirectoryInput>();
        for (DirectoryInput directoryInput : inputs) {
            boolean runAgain;
            Path rootFolder = directoryInput.getFile().toPath();
            if (!Files.isDirectory(rootFolder, new LinkOption[0])) {
                deleted.add(directoryInput);
                continue;
            }
            boolean bl = runAgain = !isIncremental;
            if (!runAgain) {
                Collection statuses = directoryInput.getChangedFiles().values();
                boolean bl2 = runAgain = statuses.contains(Status.ADDED) || statuses.contains(Status.REMOVED) || statuses.contains(Status.CHANGED);
            }
            if (runAgain) {
                changed.add(directoryInput);
                continue;
            }
            notChanged.add(directoryInput);
        }
        if (isIncremental && deleted.isEmpty() && changed.isEmpty()) {
            return subTasks.build();
        }
        if (mergeAllInputs) {
            File dexOutput = this.getDexOutputLocation(outputProvider, "directories", (Set<? super QualifiedContent.Scope>)ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT));
            FileUtils.cleanOutputDir((File)dexOutput);
            ArrayList<Path> toMerge = new ArrayList<Path>(changed.size() + notChanged.size());
            for (DirectoryInput input : Iterables.concat(changed, notChanged)) {
                toMerge.add(input.getFile().toPath());
            }
            if (!toMerge.isEmpty()) {
                subTasks.add(this.submitForMerging(output, dexOutput, toMerge, null));
            }
        } else {
            File dexOutput;
            for (DirectoryInput directoryInput : deleted) {
                dexOutput = this.getDexOutputLocation(outputProvider, directoryInput.getName(), directoryInput.getScopes());
                FileUtils.cleanOutputDir((File)dexOutput);
            }
            for (DirectoryInput directoryInput : changed) {
                dexOutput = this.getDexOutputLocation(outputProvider, directoryInput.getName(), directoryInput.getScopes());
                FileUtils.cleanOutputDir((File)dexOutput);
                subTasks.add(this.submitForMerging(output, dexOutput, (Iterable<Path>)ImmutableList.of((Object)directoryInput.getFile().toPath()), null));
            }
        }
        return subTasks.build();
    }

    private List<ForkJoinTask<Void>> processExternalJars(ProcessOutput output, TransformOutputProvider outputProvider, boolean isIncremental, List<JarInput> externalLibs) throws IOException {
        ImmutableList.Builder subTasks = ImmutableList.builder();
        File externalLibsOutput = this.getDexOutputLocation(outputProvider, "externalLibs", (Set<? super QualifiedContent.Scope>)ImmutableSet.of((Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES));
        if (!isIncremental || externalLibs.stream().anyMatch(i -> i.getStatus() != Status.NOTCHANGED)) {
            FileUtils.cleanOutputDir((File)externalLibsOutput);
            Iterable externalLibsToMerge = externalLibs.stream().filter(i -> i.getStatus() != Status.REMOVED).map(input -> input.getFile().toPath()).collect(Collectors.toList());
            if (!Iterables.isEmpty((Iterable)externalLibsToMerge)) {
                subTasks.add(this.submitForMerging(output, externalLibsOutput, externalLibsToMerge, null));
            }
        }
        return subTasks.build();
    }

    private ForkJoinTask<Void> submitForMerging(ProcessOutput output, File dexOutputDir, Iterable<Path> dexArchives, Path mainDexList) {
        DexMergerTransformCallable callable = new DexMergerTransformCallable(this.dexingType, output, dexOutputDir, dexArchives, mainDexList, this.forkJoinPool, this.dexMerger, this.minSdkVersion, this.isDebuggable);
        return this.forkJoinPool.submit((Callable)callable);
    }

    private File getDexOutputLocation(TransformOutputProvider outputProvider, String name, Set<? super QualifiedContent.Scope> scopes) {
        return outputProvider.getContentLocation(name, this.getOutputTypes(), scopes, Format.DIRECTORY);
    }
}

