/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.packaging.PackagingFileAction;
import com.android.build.gradle.internal.packaging.ParsedPackagingOptions;
import com.android.builder.packaging.ZipAbortException;
import com.android.builder.packaging.ZipEntryFilter;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class FileFilter
implements ZipEntryFilter {
    private final ParsedPackagingOptions packagingOptions;
    private final List<SubStream> expandedFolders;

    public FileFilter(List<SubStream> expandedFolders, PackagingOptions packagingOptions) {
        this.expandedFolders = ImmutableList.copyOf(expandedFolders);
        this.packagingOptions = new ParsedPackagingOptions(packagingOptions);
    }

    public boolean checkEntry(String archivePath) throws ZipAbortException {
        PackagingFileAction action2 = this.getPackagingAction(archivePath);
        switch (action2) {
            case EXCLUDE: {
                return false;
            }
            case PICK_FIRST: {
                List<File> allFiles = this.getAllFiles(archivePath);
                return allFiles.isEmpty();
            }
            case MERGE: 
            case NONE: {
                return true;
            }
        }
        throw new RuntimeException("Unhandled action " + (Object)((Object)action2));
    }

    void handleChanged(File outputDir, File changedFile) throws IOException {
        String archivePath = this.getArchivePath(changedFile);
        PackagingFileAction action2 = this.getPackagingAction(archivePath);
        switch (action2) {
            case EXCLUDE: {
                return;
            }
            case MERGE: {
                this.mergeAll(outputDir, archivePath);
                return;
            }
            case PICK_FIRST: {
                FileFilter.copy(changedFile, outputDir, archivePath);
                return;
            }
            case NONE: {
                FileFilter.copy(changedFile, outputDir, archivePath);
            }
        }
    }

    public void handleRemoved(File outputDir, String removedFilePath) throws IOException {
        File outFile = new File(outputDir, removedFilePath);
        if (outFile.exists() && !outFile.delete()) {
            throw new IOException("Cannot delete " + outFile.getAbsolutePath());
        }
        PackagingFileAction itemAction = this.getPackagingAction(removedFilePath);
        switch (itemAction) {
            case PICK_FIRST: 
            case NONE: {
                Optional<File> firstPick = this.getFirstPick(removedFilePath);
                if (firstPick.isPresent()) {
                    FileFilter.copy((File)firstPick.get(), outputDir, removedFilePath);
                }
                return;
            }
            case MERGE: {
                this.mergeAll(outputDir, removedFilePath);
                return;
            }
            case EXCLUDE: {
                return;
            }
        }
        throw new RuntimeException("Unhandled package option" + (Object)((Object)itemAction));
    }

    private static void copy(File inputFile, File outputDir, String archivePath) throws IOException {
        File outputFile = new File(outputDir, archivePath);
        FileUtils.mkdirs((File)outputFile.getParentFile());
        Files.copy((File)inputFile, (File)outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeAll(File outputDir, String archivePath) throws IOException {
        File outputFile = new File(outputDir, archivePath);
        FileUtils.deleteIfExists((File)outputFile);
        FileUtils.mkdirs((File)outputFile.getParentFile());
        List<File> allFiles = this.getAllFiles(archivePath);
        if (!allFiles.isEmpty()) {
            try (OutputStream os = null;){
                os = new BufferedOutputStream(new FileOutputStream(outputFile));
                for (File file : allFiles) {
                    Files.copy((File)file, (OutputStream)os);
                }
            }
        }
    }

    private Optional<File> getFirstPick(final String archivePath) {
        return Optional.fromNullable((Object)this.forEachExpansionFolder(new FolderAction(){

            @Override
            public File on(File folder) {
                File expandedFile = new File(folder, archivePath);
                if (expandedFile.exists()) {
                    return expandedFile;
                }
                return null;
            }
        }));
    }

    private List<File> getAllFiles(final String archivePath) {
        final ImmutableList.Builder matchingFiles = ImmutableList.builder();
        this.forEachExpansionFolder(new FolderAction(){

            @Override
            public File on(File folder) {
                File expandedFile = new File(folder, archivePath);
                if (expandedFile.exists()) {
                    matchingFiles.add((Object)expandedFile);
                }
                return null;
            }
        });
        return matchingFiles.build();
    }

    private File forEachExpansionFolder(FolderAction action2) {
        for (SubStream subStream : this.expandedFolders) {
            File value;
            if (!subStream.getFolder().isDirectory() || (value = action2.on(subStream.getFolder())) == null) continue;
            return value;
        }
        return null;
    }

    private File getExpansionFolder(final File expandedFile) {
        File expansionFolder = this.forEachExpansionFolder(new FolderAction(){

            @Override
            public File on(File folder) {
                return expandedFile.getAbsolutePath().startsWith(folder.getAbsolutePath()) ? folder : null;
            }
        });
        if (expansionFolder == null) {
            throw new RuntimeException("Cannot determine expansion folder for " + expandedFile + " with folders " + Joiner.on((String)",").join(this.expandedFolders));
        }
        return expansionFolder;
    }

    private String getArchivePath(File expandedFile) {
        File expansionFolder = this.getExpansionFolder(expandedFile);
        return expandedFile.getAbsolutePath().substring(expansionFolder.getAbsolutePath().length() + 1);
    }

    private PackagingFileAction getPackagingAction(String archivePath) {
        if (this.packagingOptions != null) {
            return this.packagingOptions.getAction(archivePath);
        }
        return PackagingFileAction.NONE;
    }

    private static interface FolderAction {
        public File on(File var1);
    }

    public static class SubStream {
        private final File folder;
        private final String name;

        SubStream(File folder, String name) {
            this.folder = folder;
            this.name = name;
        }

        public File getFolder() {
            return this.folder;
        }

        public String getName() {
            return this.name;
        }
    }
}

