/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.ConfigurationDependencies;
import com.android.build.gradle.internal.dependency.ConfigurationDependencyGraphs;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.ide.ArtifactMetaDataImpl;
import com.android.build.gradle.internal.ide.JavaArtifactImpl;
import com.android.build.gradle.internal.ide.SyncIssueImpl;
import com.android.build.gradle.internal.variant.DefaultSourceProviderContainer;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.errors.ConfigurableErrorHandler;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.ArtifactMetaData;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.SyncIssue;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageJsonSerializer;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.SourceFilePosition;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logger;

public class ExtraModelInfo
extends ConfigurableErrorHandler
implements MessageReceiver {
    private final Logger logger;
    private final ErrorFormatMode errorFormatMode;
    private final Map<SyncIssueKey, SyncIssue> syncIssues = Maps.newHashMap();
    private final Map<String, ArtifactMetaData> extraArtifactMap = Maps.newHashMap();
    private final ListMultimap<String, AndroidArtifact> extraAndroidArtifacts = ArrayListMultimap.create();
    private final ListMultimap<String, JavaArtifact> extraJavaArtifacts = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraBuildTypeSourceProviders = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraProductFlavorSourceProviders = ArrayListMultimap.create();
    private final ListMultimap<String, SourceProviderContainer> extraMultiFlavorSourceProviders = ArrayListMultimap.create();
    private final Gson mGson;

    public ExtraModelInfo(ProjectOptions projectOptions, Logger logger) {
        super(SyncOptions.getModelQueryMode(projectOptions));
        this.logger = logger;
        this.errorFormatMode = SyncOptions.getErrorFormatMode(projectOptions);
        if (this.errorFormatMode == ErrorFormatMode.MACHINE_PARSABLE) {
            GsonBuilder gsonBuilder = new GsonBuilder();
            MessageJsonSerializer.registerTypeAdapters((GsonBuilder)gsonBuilder);
            this.mGson = gsonBuilder.create();
        } else {
            this.mGson = null;
        }
        if (projectOptions.hasDeprecatedOptions()) {
            this.reportError(0, projectOptions.getDeprecatedOptionsErrorMessage());
        }
    }

    public Map<SyncIssueKey, SyncIssue> getSyncIssues() {
        return this.syncIssues;
    }

    public SyncIssue reportIssue(int type, int severity, String msg, String data) {
        SyncIssueImpl issue;
        switch (this.getMode()) {
            case STANDARD: {
                if (severity != 1 && !ExtraModelInfo.isDependencyIssue(type)) {
                    throw new GradleException(msg);
                }
                if (this.errorFormatMode == ErrorFormatMode.MACHINE_PARSABLE) {
                    Message message = new Message(Message.Kind.WARNING, msg, SourceFilePosition.UNKNOWN, new SourceFilePosition[]{SourceFilePosition.UNKNOWN});
                    this.logger.warn(this.machineReadableMessage(message));
                } else {
                    this.logger.warn("WARNING: " + msg);
                }
                issue = new SyncIssueImpl(type, severity, data, msg);
                break;
            }
            case IDE_LEGACY: {
                if (severity != 1 && type != 2) {
                    throw new GradleException(msg);
                }
            }
            case IDE: {
                issue = new SyncIssueImpl(type, severity, data, msg);
                this.syncIssues.put(SyncIssueKey.from(issue), issue);
                break;
            }
            default: {
                throw new RuntimeException("Unknown SyncIssue type");
            }
        }
        return issue;
    }

    public boolean hasSyncIssue(int type) {
        return this.syncIssues.values().stream().anyMatch(issue -> issue.getType() == type);
    }

    private static boolean isDependencyIssue(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public void receiveMessage(Message message) {
        switch (message.getKind()) {
            case ERROR: {
                if (this.errorFormatMode == ErrorFormatMode.MACHINE_PARSABLE) {
                    this.logger.error(this.machineReadableMessage(message));
                    break;
                }
                this.logger.error(ExtraModelInfo.humanReadableMessage(message));
                break;
            }
            case WARNING: {
                if (this.errorFormatMode == ErrorFormatMode.MACHINE_PARSABLE) {
                    this.logger.warn(this.machineReadableMessage(message));
                    break;
                }
                this.logger.warn(ExtraModelInfo.humanReadableMessage(message));
                break;
            }
            case INFO: {
                this.logger.info(ExtraModelInfo.humanReadableMessage(message));
                break;
            }
            case STATISTICS: {
                this.logger.trace(ExtraModelInfo.humanReadableMessage(message));
                break;
            }
            case UNKNOWN: {
                this.logger.debug(ExtraModelInfo.humanReadableMessage(message));
                break;
            }
            case SIMPLE: {
                this.logger.debug(ExtraModelInfo.humanReadableMessage(message));
            }
        }
    }

    private static String humanReadableMessage(Message message) {
        StringBuilder errorStringBuilder = new StringBuilder();
        List positions = message.getSourceFilePositions();
        if (positions.size() != 1 || !SourceFilePosition.UNKNOWN.equals(Iterables.getOnlyElement((Iterable)positions))) {
            errorStringBuilder.append(Joiner.on((char)' ').join((Iterable)positions));
        }
        if (errorStringBuilder.length() > 0) {
            errorStringBuilder.append(": ");
        }
        if (message.getToolName().isPresent()) {
            errorStringBuilder.append((String)message.getToolName().get()).append(": ");
        }
        errorStringBuilder.append(message.getText());
        String rawMessage = message.getRawMessage();
        if (!message.getText().equals(message.getRawMessage())) {
            String separator = System.lineSeparator();
            errorStringBuilder.append("\n    ").append(rawMessage.replace(separator, separator + "    "));
        }
        return errorStringBuilder.toString();
    }

    private String machineReadableMessage(Message message) {
        Preconditions.checkNotNull((Object)this.mGson);
        return "AGPBI: " + this.mGson.toJson((Object)message);
    }

    public Collection<ArtifactMetaData> getExtraArtifacts() {
        return this.extraArtifactMap.values();
    }

    public Collection<AndroidArtifact> getExtraAndroidArtifacts(String variantName) {
        return this.extraAndroidArtifacts.get((Object)variantName);
    }

    public Collection<JavaArtifact> getExtraJavaArtifacts(String variantName) {
        return this.extraJavaArtifacts.get((Object)variantName);
    }

    public Collection<SourceProviderContainer> getExtraFlavorSourceProviders(String flavorName) {
        return this.extraProductFlavorSourceProviders.get((Object)flavorName);
    }

    public Collection<SourceProviderContainer> getExtraBuildTypeSourceProviders(String buildTypeName) {
        return this.extraBuildTypeSourceProviders.get((Object)buildTypeName);
    }

    public void registerArtifactType(String name, boolean isTest, int artifactType) {
        if (this.extraArtifactMap.get(name) != null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s already registered.", name));
        }
        this.extraArtifactMap.put(name, new ArtifactMetaDataImpl(name, isTest, artifactType));
    }

    public void registerBuildTypeSourceProvider(String name, CoreBuildType buildType, SourceProvider sourceProvider) {
        if (this.extraArtifactMap.get(name) == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name));
        }
        this.extraBuildTypeSourceProviders.put((Object)buildType.getName(), (Object)new DefaultSourceProviderContainer(name, sourceProvider));
    }

    public void registerProductFlavorSourceProvider(String name, CoreProductFlavor productFlavor, SourceProvider sourceProvider) {
        if (this.extraArtifactMap.get(name) == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name));
        }
        this.extraProductFlavorSourceProviders.put((Object)productFlavor.getName(), (Object)new DefaultSourceProviderContainer(name, sourceProvider));
    }

    public void registerMultiFlavorSourceProvider(String name, String flavorName, SourceProvider sourceProvider) {
        if (this.extraArtifactMap.get(name) == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name));
        }
        this.extraMultiFlavorSourceProviders.put((Object)flavorName, (Object)new DefaultSourceProviderContainer(name, sourceProvider));
    }

    public void registerJavaArtifact(String name, BaseVariant variant, String assembleTaskName, String javaCompileTaskName, Collection<File> generatedSourceFolders, Iterable<String> ideSetupTaskNames, Configuration configuration, File classesFolder, File javaResourcesFolder, SourceProvider sourceProvider) {
        ArtifactMetaData artifactMetaData = this.extraArtifactMap.get(name);
        if (artifactMetaData == null) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not yet registered. Use registerArtifactType()", name));
        }
        if (artifactMetaData.getType() != 2) {
            throw new IllegalArgumentException(String.format("Artifact with name %1$s is not of type JAVA", name));
        }
        JavaArtifactImpl artifact = new JavaArtifactImpl(name, assembleTaskName, javaCompileTaskName, ideSetupTaskNames, generatedSourceFolders, classesFolder, Collections.emptySet(), javaResourcesFolder, null, new ConfigurationDependencies(configuration), new ConfigurationDependencyGraphs(configuration), sourceProvider, null);
        this.extraJavaArtifacts.put((Object)variant.getName(), (Object)artifact);
    }

    public ErrorFormatMode getErrorFormatMode() {
        return this.errorFormatMode;
    }

    static final class SyncIssueKey {
        private final int type;
        private final String data;

        static SyncIssueKey from(SyncIssue syncIssue) {
            return new SyncIssueKey(syncIssue.getType(), syncIssue.getData());
        }

        private SyncIssueKey(int type, String data) {
            this.type = type;
            this.data = data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SyncIssueKey that = (SyncIssueKey)o;
            return this.type == that.type && Objects.equals(this.data, that.data);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.data);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("type", this.type).add("data", (Object)this.data).toString();
        }
    }

    public static enum ErrorFormatMode {
        MACHINE_PARSABLE,
        HUMAN_READABLE;

    }
}

