/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.VariantOutput;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.ide.common.build.ApkData;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.internal.reflect.Instantiator;

public class VariantOutputFactory {
    private final Class<? extends BaseVariantOutput> targetClass;
    private final Instantiator instantiator;
    private final BaseVariantImpl variantPublicApi;
    private final TaskContainer taskContainer;
    private final AndroidConfig androidConfig;

    public VariantOutputFactory(Class<? extends BaseVariantOutput> targetClass, Instantiator instantiator, AndroidConfig androidConfig, BaseVariantImpl variantPublicApi, TaskContainer taskContainer) {
        this.targetClass = targetClass;
        this.instantiator = instantiator;
        this.variantPublicApi = variantPublicApi;
        this.taskContainer = taskContainer;
        this.androidConfig = androidConfig;
    }

    public VariantOutput create(ApkData apkData) {
        BaseVariantOutput variantOutput = (BaseVariantOutput)this.instantiator.newInstance(this.targetClass, new Object[]{apkData, this.taskContainer});
        this.androidConfig.getBuildOutputs().add(variantOutput);
        if (this.variantPublicApi != null) {
            this.variantPublicApi.addOutputs((List<BaseVariantOutput>)ImmutableList.of((Object)variantOutput));
        }
        return variantOutput;
    }
}

