/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.FilterableStreamCollection;
import com.android.build.gradle.internal.pipeline.IntermediateStream;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.AndroidTaskRegistry;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.profile.Recorder;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class TransformManager
extends FilterableStreamCollection {
    private static final boolean DEBUG = true;
    private static final String FD_TRANSFORMS = "transforms";
    public static final Set<QualifiedContent.Scope> EMPTY_SCOPES = ImmutableSet.of();
    public static final Set<QualifiedContent.ContentType> CONTENT_CLASS = ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES);
    public static final Set<QualifiedContent.ContentType> CONTENT_JARS = ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES, (Object)QualifiedContent.DefaultContentType.RESOURCES);
    public static final Set<QualifiedContent.ContentType> CONTENT_RESOURCES = ImmutableSet.of((Object)QualifiedContent.DefaultContentType.RESOURCES);
    public static final Set<QualifiedContent.ContentType> CONTENT_NATIVE_LIBS = ImmutableSet.of((Object)((Object)ExtendedContentType.NATIVE_LIBS));
    public static final Set<QualifiedContent.ContentType> CONTENT_DEX = ImmutableSet.of((Object)((Object)ExtendedContentType.DEX));
    public static final Set<QualifiedContent.ContentType> DATA_BINDING_ARTIFACT = ImmutableSet.of((Object)((Object)ExtendedContentType.DATA_BINDING));
    public static final Set<QualifiedContent.ScopeType> PROJECT_ONLY = ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT);
    public static final Set<QualifiedContent.Scope> SCOPE_FULL_PROJECT = Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.EXTERNAL_LIBRARIES});
    public static final Set<QualifiedContent.ScopeType> SCOPE_FULL_WITH_IR_FOR_DEXING = new ImmutableSet.Builder().addAll(SCOPE_FULL_PROJECT).add((Object)InternalScope.MAIN_SPLIT).build();
    public static final Set<QualifiedContent.ScopeType> SCOPE_FULL_LIBRARY_WITH_LOCAL_JARS = ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT, (Object)((Object)InternalScope.LOCAL_DEPS));
    private final Project project;
    private final AndroidTaskRegistry taskRegistry;
    private final EvalIssueReporter issueReporter;
    private final Logger logger;
    private final Recorder recorder;
    private final List<TransformStream> streams = Lists.newArrayList();
    private final List<Transform> transforms = Lists.newArrayList();

    public TransformManager(Project project, AndroidTaskRegistry taskRegistry, EvalIssueReporter issueReporter, Recorder recorder) {
        this.project = project;
        this.taskRegistry = taskRegistry;
        this.issueReporter = issueReporter;
        this.recorder = recorder;
        this.logger = Logging.getLogger(TransformManager.class);
    }

    public AndroidTaskRegistry getTaskRegistry() {
        return this.taskRegistry;
    }

    @Override
    Project getProject() {
        return this.project;
    }

    public void addStream(TransformStream stream) {
        this.streams.add(stream);
    }

    public <T extends Transform> Optional<AndroidTask<TransformTask>> addTransform(TaskFactory taskFactory, TransformVariantScope scope, T transform) {
        return this.addTransform(taskFactory, scope, transform, null);
    }

    public <T extends Transform> Optional<AndroidTask<TransformTask>> addTransform(TaskFactory taskFactory, TransformVariantScope scope, T transform, TransformTask.ConfigActionCallback<T> callback) {
        if (!this.validateTransform(transform)) {
            return Optional.empty();
        }
        ArrayList inputStreams = Lists.newArrayList();
        String taskName = scope.getTaskName(TransformManager.getTaskNamePrefix(transform));
        List<TransformStream> referencedStreams = this.grabReferencedStreams(transform);
        IntermediateStream outputStream = this.findTransformStreams(transform, scope, inputStreams, taskName, scope.getGlobalScope().getBuildDir());
        if (inputStreams.isEmpty() && referencedStreams.isEmpty()) {
            this.issueReporter.reportError(0, String.format("Unable to add Transform '%s' on variant '%s': requested streams not available: %s+%s / %s", transform.getName(), scope.getFullVariantName(), transform.getScopes(), transform.getReferencedScopes(), transform.getInputTypes()));
            return Optional.empty();
        }
        if (this.logger.isEnabled(LogLevel.DEBUG)) {
            this.logger.debug("ADDED TRANSFORM(" + scope.getFullVariantName() + "):");
            this.logger.debug("\tName: " + transform.getName());
            this.logger.debug("\tTask: " + taskName);
            for (TransformStream sd : inputStreams) {
                this.logger.debug("\tInputStream: " + sd);
            }
            for (TransformStream sd : referencedStreams) {
                this.logger.debug("\tRef'edStream: " + sd);
            }
            if (outputStream != null) {
                this.logger.debug("\tOutputStream: " + outputStream);
            }
        }
        this.transforms.add(transform);
        AndroidTask<TransformTask> task = this.taskRegistry.create(taskFactory, new TransformTask.ConfigAction<T>(scope.getFullVariantName(), taskName, transform, inputStreams, referencedStreams, outputStream, this.recorder, callback));
        return Optional.ofNullable(task);
    }

    public List<TransformStream> getStreams() {
        return this.streams;
    }

    static String getTaskNamePrefix(Transform transform) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("transform");
        sb.append(transform.getInputTypes().stream().map(inputType -> CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, inputType.name())).sorted().collect(Collectors.joining("And"))).append("With").append(StringHelper.capitalize((String)transform.getName())).append("For");
        return sb.toString();
    }

    private IntermediateStream findTransformStreams(Transform transform, TransformVariantScope scope, List<TransformStream> inputStreams, String taskName, File buildDir) {
        Set requestedScopes = transform.getScopes();
        if (requestedScopes.isEmpty()) {
            return null;
        }
        Set requestedTypes = transform.getInputTypes();
        ArrayList oldStreams = Lists.newArrayListWithExpectedSize((int)this.streams.size());
        for (TransformStream stream : this.streams) {
            Set<QualifiedContent.ContentType> availableTypes = stream.getContentTypes();
            Set<? super QualifiedContent.Scope> availableScopes = stream.getScopes();
            Sets.SetView commonTypes = Sets.intersection((Set)requestedTypes, availableTypes);
            Sets.SetView commonScopes = Sets.intersection((Set)requestedScopes, availableScopes);
            if (!commonTypes.isEmpty() && !commonScopes.isEmpty()) {
                if (!commonScopes.equals(availableScopes) || !commonTypes.equals(availableTypes)) {
                    inputStreams.add(stream.makeRestrictedCopy((Set<QualifiedContent.ContentType>)commonTypes, (Set<? super QualifiedContent.Scope>)commonScopes));
                    Sets.SetView remainingTypes = Sets.difference(availableTypes, (Set)commonTypes);
                    Sets.SetView remainingScopes = Sets.difference(availableScopes, (Set)commonScopes);
                    if (!remainingTypes.isEmpty()) {
                        oldStreams.add(stream.makeRestrictedCopy((Set<QualifiedContent.ContentType>)remainingTypes.immutableCopy(), availableScopes));
                    }
                    if (remainingScopes.isEmpty()) continue;
                    oldStreams.add(stream.makeRestrictedCopy(availableTypes, (Set<? super QualifiedContent.Scope>)remainingScopes.immutableCopy()));
                    continue;
                }
                inputStreams.add(stream);
                continue;
            }
            oldStreams.add(stream);
        }
        Set outputTypes = transform.getOutputTypes();
        File outRootFolder = FileUtils.join((File)buildDir, (Iterable)StringHelper.toStrings((Object[])new Object[]{"intermediates", FD_TRANSFORMS, transform.getName(), scope.getDirectorySegments()}));
        this.streams.clear();
        this.streams.addAll(oldStreams);
        IntermediateStream outputStream = IntermediateStream.builder(this.project, transform.getName() + "-" + scope.getFullVariantName()).addContentTypes(outputTypes).addScopes(requestedScopes).setRootLocation(outRootFolder).setTaskName(taskName).build();
        this.streams.add(outputStream);
        return outputStream;
    }

    private List<TransformStream> grabReferencedStreams(Transform transform) {
        Set requestedScopes = transform.getReferencedScopes();
        if (requestedScopes.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList streamMatches = Lists.newArrayListWithExpectedSize((int)this.streams.size());
        Set requestedTypes = transform.getInputTypes();
        for (TransformStream stream : this.streams) {
            Set<QualifiedContent.ContentType> availableTypes = stream.getContentTypes();
            Set<? super QualifiedContent.Scope> availableScopes = stream.getScopes();
            Sets.SetView commonTypes = Sets.intersection((Set)requestedTypes, availableTypes);
            Sets.SetView commonScopes = Sets.intersection((Set)requestedScopes, availableScopes);
            if (commonTypes.isEmpty() || commonScopes.isEmpty()) continue;
            streamMatches.add(stream);
        }
        return streamMatches;
    }

    private boolean validateTransform(Transform transform) {
        if (!this.checkContentTypes(transform.getInputTypes(), transform) || !this.checkContentTypes(transform.getOutputTypes(), transform)) {
            return false;
        }
        Set scopes = transform.getScopes();
        if (scopes.contains(QualifiedContent.Scope.PROVIDED_ONLY)) {
            this.issueReporter.reportError(0, String.format("PROVIDED_ONLY scope cannot be consumed by Transform '%1$s'", transform.getName()));
            return false;
        }
        if (scopes.contains(QualifiedContent.Scope.TESTED_CODE)) {
            this.issueReporter.reportError(0, String.format("TESTED_CODE scope cannot be consumed by Transform '%1$s'", transform.getName()));
            return false;
        }
        if (!transform.getClass().getCanonicalName().startsWith("com.android.build.gradle.internal.transforms")) {
            this.checkScopeDeprecation(transform.getScopes(), transform.getName());
            this.checkScopeDeprecation(transform.getReferencedScopes(), transform.getName());
        }
        return true;
    }

    private void checkScopeDeprecation(Set<? super QualifiedContent.Scope> scopes, String transformName) {
        String message;
        if (scopes.contains(QualifiedContent.Scope.PROJECT_LOCAL_DEPS)) {
            message = String.format("Transform '%1$s' uses scope %2$s which is deprecated and replaced with %3$s", transformName, QualifiedContent.Scope.PROJECT_LOCAL_DEPS.name(), QualifiedContent.Scope.EXTERNAL_LIBRARIES.name());
            if (!scopes.contains(QualifiedContent.Scope.EXTERNAL_LIBRARIES)) {
                this.issueReporter.reportError(0, message);
            }
        }
        if (scopes.contains(QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS)) {
            message = String.format("Transform '%1$s' uses scope %2$s which is deprecated and replaced with %3$s", transformName, QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS.name(), QualifiedContent.Scope.EXTERNAL_LIBRARIES.name());
            if (!scopes.contains(QualifiedContent.Scope.EXTERNAL_LIBRARIES)) {
                this.issueReporter.reportError(0, message);
            }
        }
    }

    private boolean checkContentTypes(Set<QualifiedContent.ContentType> contentTypes, Transform transform) {
        for (QualifiedContent.ContentType contentType : contentTypes) {
            if (contentType instanceof QualifiedContent.DefaultContentType || contentType instanceof ExtendedContentType) continue;
            this.issueReporter.reportError(0, String.format("Custom content types (%1$s) are not supported in transforms (%2$s)", contentType.getClass().getName(), transform.getName()));
            return false;
        }
        return true;
    }
}

