/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.namespaced;

import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.res.namespaced.CompileRClassTask;
import com.android.build.gradle.internal.res.namespaced.JarRClassTask;
import com.android.build.gradle.internal.res.namespaced.LinkLibraryAndroidResourcesTask;
import com.android.build.gradle.internal.res.namespaced.ProcessAndroidAppResourcesTask;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.AndroidTaskRegistry;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.builder.core.VariantType;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0002J*\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010\"\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J(\u0010#\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lcom/android/build/gradle/internal/res/namespaced/NamespacedResourcesTaskManager;", "", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "androidTasks", "Lcom/android/build/gradle/internal/scope/AndroidTaskRegistry;", "tasks", "Lcom/android/build/gradle/internal/TaskFactory;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/GlobalScope;Lcom/android/build/gradle/internal/scope/AndroidTaskRegistry;Lcom/android/build/gradle/internal/TaskFactory;Lcom/android/build/gradle/internal/scope/VariantScope;)V", "getAndroidTasks", "()Lcom/android/build/gradle/internal/scope/AndroidTaskRegistry;", "getGlobalScope", "()Lcom/android/build/gradle/internal/scope/GlobalScope;", "getTasks", "()Lcom/android/build/gradle/internal/TaskFactory;", "getVariantScope", "()Lcom/android/build/gradle/internal/scope/VariantScope;", "createCompileCompileOnlyRClassTask", "", "createCompileResourcesTask", "createCompileRuntimeRClassTask", "createJarCompileOnlyRClassClassesTask", "createLinkResourcesTask", "createNamespacedAppProcessTask", "resPackageOutputFolder", "Ljava/io/File;", "packageOutputType", "Lcom/android/build/gradle/internal/scope/TaskOutputHolder$TaskOutputType;", "baseName", "", "useAaptToGenerateLegacyMultidexMainDexProguardRules", "", "createNamespacedLibraryProcessResourcesTask", "createNamespacedResourceTasks", "gradle-core_main"})
public final class NamespacedResourcesTaskManager {
    @NotNull
    private final GlobalScope globalScope;
    @NotNull
    private final AndroidTaskRegistry androidTasks;
    @NotNull
    private final TaskFactory tasks;
    @NotNull
    private final VariantScope variantScope;

    /*
     * Unable to fully structure code
     */
    public final void createNamespacedResourceTasks(@NotNull File resPackageOutputFolder, @Nullable TaskOutputHolder.TaskOutputType packageOutputType, @NotNull String baseName, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules) {
        Intrinsics.checkParameterIsNotNull((Object)resPackageOutputFolder, (String)"resPackageOutputFolder");
        Intrinsics.checkParameterIsNotNull((Object)baseName, (String)"baseName");
        aaptGeneration = AaptGeneration.fromProjectOptions(this.globalScope.getProjectOptions());
        Preconditions.checkState((boolean)(Intrinsics.areEqual((Object)aaptGeneration, (Object)AaptGeneration.AAPT_V2_JNI) != false || Intrinsics.areEqual((Object)aaptGeneration, (Object)AaptGeneration.AAPT_V2_DAEMON_MODE) != false), (String)"Resource Namespacing can only be used with aapt2", (Object[])new Object[0]);
        this.createCompileResourcesTask();
        this.createLinkResourcesTask();
        this.createCompileCompileOnlyRClassTask();
        this.createJarCompileOnlyRClassClassesTask();
        if (Intrinsics.areEqual((Object)this.variantScope.getVariantData().getType(), (Object)VariantType.LIBRARY)) ** GOTO lbl-1000
        v0 = this.variantScope.getTestedVariantData();
        if (Intrinsics.areEqual((Object)(v0 != null ? v0.getType() : null), (Object)VariantType.LIBRARY)) lbl-1000:
        // 2 sources

        {
            this.createNamespacedLibraryProcessResourcesTask(resPackageOutputFolder, packageOutputType);
        } else {
            this.createNamespacedAppProcessTask(resPackageOutputFolder, packageOutputType, baseName, useAaptToGenerateLegacyMultidexMainDexProguardRules);
        }
        this.createCompileRuntimeRClassTask();
    }

    private final void createCompileCompileOnlyRClassTask() {
        File compileOnlyRClassClassesDir = new File(this.variantScope.getGlobalScope().getIntermediatesDir(), "res-r/" + this.variantScope.getVariantConfiguration().getDirName());
        String string = this.variantScope.getTaskName("compile", "RClass");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"compile\", \"RClass\")");
        FileCollection fileCollection = this.variantScope.getOutput(TaskOutputHolder.TaskOutputType.COMPILE_ONLY_R_CLASS_SOURCES);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"variantScope.getOutput(T\u2026ILE_ONLY_R_CLASS_SOURCES)");
        AndroidTask task = this.androidTasks.create(this.tasks, new CompileRClassTask.ConfigAction(string, fileCollection, compileOnlyRClassClassesDir));
        this.variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.COMPILE_ONLY_R_CLASS_CLASSES, compileOnlyRClassClassesDir, task.getName());
    }

    private final void createJarCompileOnlyRClassClassesTask() {
        File rClassJarFile = new File(this.variantScope.getGlobalScope().getIntermediatesDir(), "res-rJar/" + this.variantScope.getVariantConfiguration().getDirName() + "/R.jar");
        String string = this.variantScope.getTaskName("jar", "RClass");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"jar\", \"RClass\")");
        FileCollection fileCollection = this.variantScope.getOutput(TaskOutputHolder.TaskOutputType.COMPILE_ONLY_R_CLASS_CLASSES);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"variantScope.getOutput(T\u2026ILE_ONLY_R_CLASS_CLASSES)");
        AndroidTask task = this.androidTasks.create(this.tasks, new JarRClassTask.ConfigAction(string, fileCollection, rClassJarFile));
        this.variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.COMPILE_ONLY_R_CLASS_JAR, rClassJarFile, task.getName());
    }

    private final void createCompileRuntimeRClassTask() {
        File rClassCompiledOutputDir = new File(this.variantScope.getGlobalScope().getIntermediatesDir(), "res-final-r-classes/" + this.variantScope.getVariantConfiguration().getDirName());
        String string = this.variantScope.getTaskName("compile", "FinalRClass");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"compile\", \"FinalRClass\")");
        FileCollection fileCollection = this.variantScope.getOutput(TaskOutputHolder.TaskOutputType.RUNTIME_R_CLASS_SOURCES);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"variantScope.getOutput(T\u2026.RUNTIME_R_CLASS_SOURCES)");
        AndroidTask task = this.androidTasks.create(this.tasks, new CompileRClassTask.ConfigAction(string, fileCollection, rClassCompiledOutputDir));
        this.variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.RUNTIME_R_CLASS_CLASSES, rClassCompiledOutputDir, task.getName());
    }

    private final void createNamespacedAppProcessTask(File resPackageOutputFolder, TaskOutputHolder.TaskOutputType packageOutputType, String baseName, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules) {
        File runtimeRClassSources = new File(this.globalScope.getGeneratedDir(), "source/final-r/" + this.variantScope.getVariantConfiguration().getDirName());
        AndroidTask process = this.androidTasks.create(this.tasks, new ProcessAndroidResources.NamespacedConfigAction(this.variantScope, runtimeRClassSources, resPackageOutputFolder, Intrinsics.areEqual((Object)this.variantScope.getVariantData().getType(), (Object)VariantType.LIBRARY), useAaptToGenerateLegacyMultidexMainDexProguardRules, baseName));
        this.variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.PROCESSED_RES, resPackageOutputFolder, process.getName());
        this.variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.RUNTIME_R_CLASS_SOURCES, runtimeRClassSources, process.getName());
        if (packageOutputType != null) {
            this.variantScope.addTaskOutput(packageOutputType, this.variantScope.getProcessResourcePackageOutputDirectory(), process.getName());
        }
    }

    private final void createNamespacedLibraryProcessResourcesTask(File resPackageOutputFolder, TaskOutputHolder.TaskOutputType packageOutputType) {
        File runtimeRClassSources = new File(this.globalScope.getGeneratedDir(), "source/final-r/" + this.variantScope.getVariantConfiguration().getDirName());
        AndroidTask process = this.androidTasks.create(this.tasks, new ProcessAndroidAppResourcesTask.ConfigAction(this.variantScope, runtimeRClassSources, new File(resPackageOutputFolder, "res.apk"), Intrinsics.areEqual((Object)this.variantScope.getVariantData().getType(), (Object)VariantType.LIBRARY)));
        this.variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.PROCESSED_RES, resPackageOutputFolder, process.getName());
        this.variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.RUNTIME_R_CLASS_SOURCES, runtimeRClassSources, process.getName());
        if (packageOutputType != null) {
            this.variantScope.addTaskOutput(packageOutputType, this.variantScope.getProcessResourcePackageOutputDirectory(), process.getName());
        }
    }

    private final void createCompileResourcesTask() {
        File compiled = FileUtils.join((File)this.variantScope.getGlobalScope().getIntermediatesDir(), (String[])new String[]{"res", "compiled", this.variantScope.getVariantConfiguration().getDirName()});
        AndroidTask compile = this.androidTasks.create(this.tasks, new MergeResources.ConfigAction(this.variantScope, "compile", compiled, null, false, true, false, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of()));
        compile.dependsOn(this.tasks, this.variantScope.getResourceGenTask());
        this.variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.RES_COMPILED_FLAT_FILES, compiled, compile.getName());
    }

    private final void createLinkResourcesTask() {
        File resourceStaticLibrary = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"res-linked", this.variantScope.getVariantConfiguration().getDirName(), "res.apk"});
        File compileOnlyRClassSourceDir = new File(this.globalScope.getGeneratedDir(), "source/r/" + this.variantScope.getVariantConfiguration().getDirName());
        File file = resourceStaticLibrary;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"resourceStaticLibrary");
        AndroidTask link = this.androidTasks.create(this.tasks, new LinkLibraryAndroidResourcesTask.ConfigAction(this.variantScope, compileOnlyRClassSourceDir, file));
        this.variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.RES_STATIC_LIBRARY, resourceStaticLibrary, link.getName());
        this.variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.COMPILE_ONLY_R_CLASS_SOURCES, compileOnlyRClassSourceDir, link.getName());
    }

    @NotNull
    public final GlobalScope getGlobalScope() {
        return this.globalScope;
    }

    @NotNull
    public final AndroidTaskRegistry getAndroidTasks() {
        return this.androidTasks;
    }

    @NotNull
    public final TaskFactory getTasks() {
        return this.tasks;
    }

    @NotNull
    public final VariantScope getVariantScope() {
        return this.variantScope;
    }

    public NamespacedResourcesTaskManager(@NotNull GlobalScope globalScope, @NotNull AndroidTaskRegistry androidTasks, @NotNull TaskFactory tasks, @NotNull VariantScope variantScope) {
        Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
        Intrinsics.checkParameterIsNotNull((Object)androidTasks, (String)"androidTasks");
        Intrinsics.checkParameterIsNotNull((Object)tasks, (String)"tasks");
        Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
        this.globalScope = globalScope;
        this.androidTasks = androidTasks;
        this.tasks = tasks;
        this.variantScope = variantScope;
    }
}

