/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.internal.transforms.InstantRunSplitApkBuilder;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.internal.aapt.AaptOptions;
import com.android.builder.utils.FileCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class InstantRunDependenciesApkBuilder
extends InstantRunSplitApkBuilder {
    private static final String APK_FILE_NAME = "dependencies";

    public InstantRunDependenciesApkBuilder(Logger logger, Project project, InstantRunBuildContext buildContext, AndroidBuilder androidBuilder, FileCache fileCache, PackagingScope packagingScope, CoreSigningConfig signingConf, AaptGeneration aaptGeneration, AaptOptions aaptOptions, File outputDirectory, File supportDirectory, File aaptIntermediateDirectory) {
        super(logger, project, buildContext, androidBuilder, fileCache, packagingScope, signingConf, aaptGeneration, aaptOptions, outputDirectory, supportDirectory, aaptIntermediateDirectory);
    }

    public String getName() {
        return "instantRunDependenciesApk";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)((Object)ExtendedContentType.DEX));
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Enum[])new QualifiedContent.Scope[0]);
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        boolean anyChangeOfInterest = transformInvocation.getInputs().stream().flatMap(t -> t.getDirectoryInputs().stream()).anyMatch(directoryInput -> !directoryInput.getChangedFiles().isEmpty());
        if (transformInvocation.isIncremental() && !anyChangeOfInterest) {
            return;
        }
        ImmutableSet.Builder dexFiles = ImmutableSet.builder();
        for (TransformInput transformInput : transformInvocation.getInputs()) {
            for (JarInput jarInput : transformInput.getJarInputs()) {
                this.logger.error("InstantRunDependenciesApkBuilder received a jar file " + jarInput.getFile().getAbsolutePath());
            }
            for (DirectoryInput directoryInput2 : transformInput.getDirectoryInputs()) {
                Object[] files = directoryInput2.getFile().listFiles();
                if (files == null) continue;
                dexFiles.add(files);
            }
        }
        ImmutableSet listOfDexes = dexFiles.build();
        if (listOfDexes.isEmpty()) {
            return;
        }
        try {
            this.generateSplitApk(new InstantRunSplitApkBuilder.DexFiles((ImmutableSet<File>)listOfDexes, APK_FILE_NAME));
        }
        catch (Exception e) {
            this.logger.error("Error while generating dependencies split APK", (Throwable)e);
            throw new TransformException((Throwable)e);
        }
    }
}

