/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.packaging.ApkCreatorFactories;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.AaptOptions;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.PackagerException;
import com.android.builder.utils.FileCache;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.signing.KeytoolException;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;

public abstract class InstantRunSplitApkBuilder
extends Transform {
    protected final Logger logger;
    protected final Project project;
    protected final AndroidBuilder androidBuilder;
    private final FileCache fileCache;
    private final AaptGeneration aaptGeneration;
    protected final InstantRunBuildContext buildContext;
    protected final File outputDirectory;
    protected final CoreSigningConfig signingConf;
    private final PackagingScope packagingScope;
    private final AaptOptions aaptOptions;
    protected final File supportDirectory;
    protected final File aaptIntermediateDirectory;

    public InstantRunSplitApkBuilder(Logger logger, Project project, InstantRunBuildContext buildContext, AndroidBuilder androidBuilder, FileCache fileCache, PackagingScope packagingScope, CoreSigningConfig signingConf, AaptGeneration aaptGeneration, AaptOptions aaptOptions, File outputDirectory, File supportDirectory, File aaptIntermediateDirectory) {
        this.logger = logger;
        this.project = project;
        this.buildContext = buildContext;
        this.androidBuilder = androidBuilder;
        this.fileCache = fileCache;
        this.packagingScope = packagingScope;
        this.signingConf = signingConf;
        this.aaptGeneration = aaptGeneration;
        this.aaptOptions = aaptOptions;
        this.outputDirectory = outputDirectory;
        this.supportDirectory = supportDirectory;
        this.aaptIntermediateDirectory = aaptIntermediateDirectory;
    }

    public final Map<String, Object> getParameterInputs() {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"applicationId", (Object)this.packagingScope.getApplicationId()).put((Object)"versionCode", (Object)this.packagingScope.getVersionCode()).put((Object)"aaptGeneration", (Object)this.aaptGeneration.name());
        if (this.packagingScope.getVersionName() != null) {
            builder.put((Object)"versionName", (Object)this.packagingScope.getVersionName());
        }
        return builder.build();
    }

    protected File generateSplitApk(DexFiles dexFiles) throws IOException, KeytoolException, PackagerException, InterruptedException, ProcessException, TransformException, ExecutionException {
        String uniqueName = dexFiles.encodeName();
        File alignedOutput = new File(this.outputDirectory, uniqueName + ".apk");
        com.google.common.io.Files.createParentDirs((File)alignedOutput);
        try (Aapt aapt = this.getAapt();){
            File resPackageFile = InstantRunSplitApkBuilder.generateSplitApkResourcesAp(this.logger, aapt, this.packagingScope, this.supportDirectory, this.aaptOptions, this.androidBuilder, uniqueName);
            File tempDir = new File(this.supportDirectory, "package_" + uniqueName);
            if (!tempDir.exists() && !tempDir.mkdirs()) {
                throw new TransformException("Cannot create temporary folder " + tempDir.getAbsolutePath());
            }
            FileUtils.cleanOutputDir((File)tempDir);
            this.androidBuilder.packageCodeSplitApk(resPackageFile, (Set)dexFiles.dexFiles, (SigningConfig)this.signingConf, alignedOutput, tempDir, ApkCreatorFactories.fromProjectProperties(this.project, true));
            this.buildContext.addChangedFile(FileType.SPLIT, alignedOutput);
            Files.deleteIfExists(resPackageFile.toPath());
        }
        return alignedOutput;
    }

    public static File generateSplitApkManifest(File apkSupportDir, String splitName, String packageId, String versionName, int versionCode, String minSdkVersion) throws IOException {
        String versionNameToUse = versionName;
        if (versionNameToUse == null) {
            versionNameToUse = String.valueOf(versionCode);
        }
        File androidManifest = new File(apkSupportDir, "AndroidManifest.xml");
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(androidManifest), "UTF-8");){
            fileWriter.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n").append("      package=\"").append(packageId).append("\"\n");
            if (versionCode != -1) {
                fileWriter.append("      android:versionCode=\"").append(String.valueOf(versionCode)).append("\"\n").append("      android:versionName=\"").append(versionNameToUse).append("\"\n");
            }
            fileWriter.append("      split=\"lib_").append(splitName).append("_apk\">\n");
            if (minSdkVersion != null) {
                fileWriter.append("\t<uses-sdk android:minSdkVersion=\"").append(minSdkVersion).append("\"/>\n");
            }
            fileWriter.append("</manifest>\n").flush();
        }
        return androidManifest;
    }

    public static File generateSplitApkResourcesAp(Logger logger, Aapt aapt, PackagingScope packagingScope, File supportDirectory, AaptOptions aaptOptions, AndroidBuilder androidBuilder, String uniqueName) throws IOException, ProcessException, InterruptedException {
        File apkSupportDir = new File(supportDirectory, uniqueName);
        if (!apkSupportDir.exists() && !apkSupportDir.mkdirs()) {
            logger.error("Cannot create apk support dir {}", (Object)apkSupportDir.getAbsoluteFile());
        }
        File androidManifest = InstantRunSplitApkBuilder.generateSplitApkManifest(apkSupportDir, uniqueName, packagingScope.getApplicationId(), packagingScope.getVersionName(), packagingScope.getVersionCode(), null);
        return InstantRunSplitApkBuilder.generateSplitApkResourcesAp(logger, aapt, androidManifest, supportDirectory, aaptOptions, androidBuilder, null, uniqueName);
    }

    public static File generateSplitApkResourcesAp(Logger logger, Aapt aapt, File androidManifest, File supportDirectory, AaptOptions aaptOptions, AndroidBuilder androidBuilder, FileCollection imports, String uniqueName) throws IOException, ProcessException, InterruptedException {
        File apkSupportDir = new File(supportDirectory, uniqueName);
        if (!apkSupportDir.exists() && !apkSupportDir.mkdirs()) {
            logger.error("Cannot create apk support dir {}", (Object)apkSupportDir.getAbsoluteFile());
        }
        File resFilePackageFile = new File(apkSupportDir, "resources_ap");
        ImmutableList importedAPKs = imports != null ? imports.getAsFileTree().getFiles().stream().filter(file -> file.getName().endsWith("ap_")).collect(Collectors.toList()) : ImmutableList.of();
        AaptPackageConfig.Builder aaptConfig = new AaptPackageConfig.Builder().setManifestFile(androidManifest).setOptions(aaptOptions).setDebuggable(true).setVariantType(VariantType.DEFAULT).setImports((Collection)ImmutableList.copyOf((Collection)importedAPKs)).setResourceOutputApk(resFilePackageFile);
        androidBuilder.processResources(aapt, aaptConfig);
        return resFilePackageFile;
    }

    protected Aapt getAapt() throws IOException {
        return InstantRunSplitApkBuilder.makeAapt(this.aaptGeneration, this.androidBuilder, this.fileCache, this.aaptIntermediateDirectory);
    }

    public static Aapt makeAapt(AaptGeneration aaptGeneration, AndroidBuilder androidBuilder, FileCache fileCache, File intermediateFolder) throws IOException {
        return AaptGradleFactory.make(aaptGeneration, androidBuilder, null, fileCache, true, FileUtils.mkdirs((File)intermediateFolder), 0);
    }

    protected static class DexFiles {
        private final ImmutableSet<File> dexFiles;
        private final String dexFolderName;

        protected DexFiles(File[] dexFiles, String dexFolderName) {
            this((ImmutableSet<File>)ImmutableSet.copyOf((Object[])dexFiles), dexFolderName);
        }

        protected DexFiles(ImmutableSet<File> dexFiles, String dexFolderName) {
            this.dexFiles = dexFiles;
            this.dexFolderName = dexFolderName;
        }

        protected String encodeName() {
            return this.dexFolderName.replace('-', '_');
        }

        protected ImmutableSet<File> getDexFiles() {
            return this.dexFiles;
        }
    }
}

