/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.VariantOutput;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;

public class CheckManifestInInstantRunMode
extends AndroidVariantTask {
    private static final Logger LOG = Logging.getLogger(CheckManifestInInstantRunMode.class);
    private InstantRunBuildContext buildContext;
    private File instantRunSupportDir;
    private OutputScope outputScope;
    private FileCollection instantRunManifests;
    private FileCollection processedRes;

    @InputFiles
    FileCollection getInstantRunManifests() {
        return this.instantRunManifests;
    }

    @InputFiles
    FileCollection getProcessedRes() {
        return this.processedRes;
    }

    @TaskAction
    public void checkManifestChanges() throws IOException {
        if (!this.buildContext.isInInstantRunMode()) {
            LOG.warn("CheckManifestInInstantRunMode configured in non instant run build, please file a bug.");
            return;
        }
        if (this.instantRunManifests.getFiles().isEmpty()) {
            String message = "No instant run specific merged manifests in InstantRun mode, please file a bug and disable InstantRun.";
            LOG.error(message);
            throw new RuntimeException(message);
        }
        if (this.instantRunManifests.getFiles().size() > 1) {
            String message = "Full Split are not supported in InstantRun mode, please disable InstantRun";
            LOG.error(message);
            throw new RuntimeException(message);
        }
        Collection<BuildOutput> manifestsOutputs = BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS, this.instantRunManifests);
        Collection<BuildOutput> processedResOutputs = BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.PROCESSED_RES, this.processedRes);
        for (BuildOutput mergedManifest : manifestsOutputs) {
            ApkInfo apkInfo = mergedManifest.getApkInfo();
            ApkData apkData = this.outputScope.getSplit(apkInfo.getFilters());
            if (apkData == null || !apkData.isEnabled() || apkData.getType() == VariantOutput.OutputType.SPLIT) continue;
            File manifestFile = mergedManifest.getOutputFile();
            LOG.info("CheckManifestInInstantRunMode : Merged manifest %1$s", (Object)manifestFile);
            CheckManifestInInstantRunMode.runManifestChangeVerifier(this.buildContext, this.instantRunSupportDir, manifestFile);
            BuildOutput output = OutputScope.getOutput(processedResOutputs, (TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.PROCESSED_RES, (ApkInfo)apkData);
            if (output == null) {
                throw new RuntimeException("Cannot find processed resources for " + apkData + " split in " + Joiner.on((String)",").join(this.outputScope.getOutputs(TaskOutputHolder.TaskOutputType.PROCESSED_RES)));
            }
            File resourcesApk = output.getOutputFile();
            LOG.info("CheckManifestInInstantRunMode : Resource APK %1$s", (Object)resourcesApk);
            if (!resourcesApk.exists()) continue;
            CheckManifestInInstantRunMode.runManifestBinaryChangeVerifier(this.buildContext, this.instantRunSupportDir, resourcesApk);
        }
    }

    static void runManifestChangeVerifier(InstantRunBuildContext buildContext, File instantRunSupportDir, File manifestFileToPackage) throws IOException {
        File previousManifestFile = new File(instantRunSupportDir, "manifest.xml");
        if (previousManifestFile.exists()) {
            String previousManifest;
            String currentManifest = Files.asCharSource((File)manifestFileToPackage, (Charset)Charsets.UTF_8).read();
            if (!currentManifest.equals(previousManifest = Files.asCharSource((File)previousManifestFile, (Charset)Charsets.UTF_8).read())) {
                buildContext.setVerifierStatus(InstantRunVerifierStatus.MANIFEST_FILE_CHANGE);
                Files.copy((File)manifestFileToPackage, (File)previousManifestFile);
            }
        } else {
            Files.createParentDirs((File)previousManifestFile);
            Files.copy((File)manifestFileToPackage, (File)previousManifestFile);
            buildContext.setVerifierStatus(InstantRunVerifierStatus.INITIAL_BUILD);
        }
    }

    static void runManifestBinaryChangeVerifier(InstantRunBuildContext buildContext, File instantRunSupportDir, File resOutBaseNameFile) throws IOException {
        String currentIterationCRC = null;
        try (JarFile jarFile = new JarFile(resOutBaseNameFile);){
            ZipEntry entry = jarFile.getEntry("AndroidManifest.xml");
            if (entry != null) {
                currentIterationCRC = String.valueOf(entry.getCrc());
            }
        }
        File crcFile = new File(instantRunSupportDir, "manifest.crc");
        if (crcFile.exists() && currentIterationCRC != null) {
            String previousIterationCRC = Files.readFirstLine((File)crcFile, (Charset)Charsets.UTF_8);
            if (!currentIterationCRC.equals(previousIterationCRC)) {
                buildContext.setVerifierStatus(InstantRunVerifierStatus.BINARY_MANIFEST_FILE_CHANGE);
            }
        } else {
            buildContext.setVerifierStatus(InstantRunVerifierStatus.INITIAL_BUILD);
        }
        if (currentIterationCRC != null) {
            Files.createParentDirs((File)crcFile);
            Files.write((CharSequence)currentIterationCRC, (File)crcFile, (Charset)Charsets.UTF_8);
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<CheckManifestInInstantRunMode> {
        protected final TransformVariantScope transformVariantScope;
        protected final InstantRunVariantScope instantRunVariantScope;
        protected final FileCollection instantRunMergedManifests;
        protected final FileCollection processedResources;

        public ConfigAction(TransformVariantScope transformVariantScope, InstantRunVariantScope instantRunVariantScope, FileCollection instantRunMergedManifests, FileCollection processedResources) {
            this.transformVariantScope = transformVariantScope;
            this.instantRunVariantScope = instantRunVariantScope;
            this.instantRunMergedManifests = instantRunMergedManifests;
            this.processedResources = processedResources;
        }

        @Override
        public String getName() {
            return this.transformVariantScope.getTaskName("checkManifestChanges");
        }

        @Override
        public Class<CheckManifestInInstantRunMode> getType() {
            return CheckManifestInInstantRunMode.class;
        }

        @Override
        public void execute(CheckManifestInInstantRunMode task) {
            task.instantRunManifests = this.instantRunMergedManifests;
            task.processedRes = this.processedResources;
            task.outputScope = this.transformVariantScope.getOutputScope();
            task.buildContext = this.instantRunVariantScope.getInstantRunBuildContext();
            task.instantRunSupportDir = new File(this.instantRunVariantScope.getInstantRunSupportDir(), "manifestChecker");
            task.setVariantName(this.transformVariantScope.getFullVariantName());
        }
    }
}

