/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.DslAdaptersKt;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.v1.AaptV1;
import com.android.builder.utils.FileCache;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.MergingLogRewriter;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.blame.parser.aapt.AaptOutputParser;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.res2.CompileResourceRequest;
import com.android.ide.common.res2.FileStatus;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

public class VerifyLibraryResourcesTask
extends IncrementalTask {
    private File compiledDirectory;
    private FileCollection inputDirectory;
    private File mergeBlameLogFolder;
    private TaskOutputHolder.TaskOutputType taskInputType;
    private FileCollection manifestFiles;
    private FileCache fileCache;
    protected static final Logger LOG = Logging.getLogger(VerifyLibraryResourcesTask.class);
    private AaptGeneration aaptGeneration;

    @Override
    protected boolean isIncremental() {
        return true;
    }

    @Override
    protected final void doFullTaskAction() throws Exception {
        Map<File, FileStatus> fileStatusMap = Files.walk(this.inputDirectory.getSingleFile().toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toMap(Path::toFile, file -> FileStatus.NEW));
        FileUtils.cleanOutputDir((File)this.compiledDirectory);
        this.compileAndVerifyResources(fileStatusMap);
    }

    @Override
    protected final void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws Exception {
        this.compileAndVerifyResources(changedInputs);
    }

    private void compileAndVerifyResources(Map<File, FileStatus> inputs) throws Exception {
        AndroidBuilder builder = this.getBuilder();
        MergingLog mergingLog = new MergingLog(this.mergeBlameLogFolder);
        MergingLogRewriter mergingLogRewriter = new MergingLogRewriter(arg_0 -> ((MergingLog)mergingLog).find(arg_0), builder.getMessageReceiver());
        ParsingProcessOutputHandler processOutputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new AaptOutputParser(), this.getILogger()), new MessageReceiver[]{mergingLogRewriter});
        Collection<BuildOutput> manifestsOutputs = BuildOutputs.load((TaskOutputHolder.OutputType)this.taskInputType, this.manifestFiles);
        File manifestFile = ((BuildOutput)Iterables.getOnlyElement(manifestsOutputs)).getOutputFile();
        try (Aapt aapt = AaptGradleFactory.make(this.aaptGeneration, builder, (ProcessOutputHandler)processOutputHandler, this.fileCache, true, FileUtils.mkdirs((File)new File(this.getIncrementalFolder(), "aapt-temp")), 0);){
            if (aapt instanceof AaptV1) {
                this.linkResources(this.inputDirectory.getSingleFile(), aapt, manifestFile);
            } else {
                VerifyLibraryResourcesTask.compileResources(inputs, this.compiledDirectory, aapt);
                this.linkResources(this.compiledDirectory, aapt, manifestFile);
            }
        }
    }

    private static void compileResources(Map<File, FileStatus> inputs, File outDirectory, Aapt aapt) throws AaptException, ExecutionException, InterruptedException, IOException {
        Preconditions.checkState((!(aapt instanceof AaptV1) ? 1 : 0) != 0, (Object)"Library resources should be compiled for verification using AAPT2");
        ArrayList<Future> compiling = new ArrayList<Future>();
        for (Map.Entry<File, FileStatus> input : inputs.entrySet()) {
            switch (input.getValue()) {
                case NEW: 
                case CHANGED: {
                    try {
                        Future result = aapt.compile(new CompileResourceRequest(input.getKey(), outDirectory, input.getKey().getParent(), false, false));
                        compiling.add(result);
                        break;
                    }
                    catch (Exception e) {
                        throw new AaptException(String.format("Failed to compile file %s", input.getKey().getAbsolutePath()), new Object[]{e});
                    }
                }
                case REMOVED: {
                    FileUtils.deleteIfExists((File)aapt.compileOutputFor(new CompileResourceRequest(input.getKey(), outDirectory, input.getKey().getParent())));
                }
            }
        }
        for (Future result : compiling) {
            result.get();
        }
    }

    private void linkResources(File resDir, Aapt aapt, File manifestFile) throws InterruptedException, ProcessException, IOException {
        Preconditions.checkNotNull((Object)manifestFile, (Object)"Manifest file cannot be null");
        AndroidBuilder builder = this.getBuilder();
        AaptPackageConfig.Builder config = new AaptPackageConfig.Builder().setManifestFile(manifestFile).setResourceDir(resDir).setLibrarySymbolTableFiles((Set)ImmutableSet.of()).setOptions(DslAdaptersKt.convert(new AaptOptions())).setVariantType(VariantType.LIBRARY);
        builder.processResources(aapt, config);
    }

    @Input
    public String getAaptGeneration() {
        return this.aaptGeneration.name();
    }

    @InputFiles
    public FileCollection getManifestFiles() {
        return this.manifestFiles;
    }

    @Input
    public TaskOutputHolder.TaskOutputType getTaskInputType() {
        return this.taskInputType;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getInputDirectory() {
        return this.inputDirectory;
    }

    @OutputDirectory
    public File getCompiledDirectory() {
        return this.compiledDirectory;
    }

    @Input
    public File getMergeBlameLogFolder() {
        return this.mergeBlameLogFolder;
    }

    public static class ConfigAction
    implements TaskConfigAction<VerifyLibraryResourcesTask> {
        protected final VariantScope scope;
        private final TaskManager.MergeType sourceTaskOutputType;

        public ConfigAction(VariantScope scope, TaskManager.MergeType sourceTaskOutputType) {
            this.scope = scope;
            this.sourceTaskOutputType = sourceTaskOutputType;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("verify", "Resources");
        }

        @Override
        public Class<VerifyLibraryResourcesTask> getType() {
            return VerifyLibraryResourcesTask.class;
        }

        @Override
        public void execute(VerifyLibraryResourcesTask verifyLibraryResources) {
            BaseVariantData variantData = this.scope.getVariantData();
            GradleVariantConfiguration config = variantData.getVariantConfiguration();
            verifyLibraryResources.setVariantName(config.getFullName());
            verifyLibraryResources.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            verifyLibraryResources.aaptGeneration = AaptGeneration.fromProjectOptions(this.scope.getGlobalScope().getProjectOptions());
            verifyLibraryResources.setIncrementalFolder(this.scope.getIncrementalDir(this.getName()));
            Preconditions.checkState((this.sourceTaskOutputType == TaskManager.MergeType.MERGE ? 1 : 0) != 0, (Object)"Support for not merging resources in libraries not implemented yet.");
            verifyLibraryResources.inputDirectory = this.scope.getOutput(this.sourceTaskOutputType.getOutputType());
            verifyLibraryResources.compiledDirectory = this.scope.getCompiledResourcesOutputDir();
            verifyLibraryResources.mergeBlameLogFolder = this.scope.getResourceBlameLogDir();
            boolean aaptFriendlyManifestsFilePresent = this.scope.hasOutput(TaskOutputHolder.TaskOutputType.AAPT_FRIENDLY_MERGED_MANIFESTS);
            verifyLibraryResources.taskInputType = aaptFriendlyManifestsFilePresent ? TaskOutputHolder.TaskOutputType.AAPT_FRIENDLY_MERGED_MANIFESTS : (this.scope.getInstantRunBuildContext().isInInstantRunMode() ? TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS : TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS);
            verifyLibraryResources.manifestFiles = this.scope.getOutput(verifyLibraryResources.taskInputType);
            verifyLibraryResources.fileCache = this.scope.getGlobalScope().getBuildCache();
        }
    }
}

