/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.builder.core.BuilderConstants;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.internal.reflect.Instantiator;

class ReportingPlugin
implements Plugin<Project> {
    private final Instantiator instantiator;
    private TestOptions extension;

    @Inject
    public ReportingPlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void apply(Project project) {
        project.evaluationDependsOnChildren();
        this.extension = (TestOptions)project.getExtensions().create("android", TestOptions.class, new Object[]{this.instantiator});
        AndroidReportTask mergeReportsTask = (AndroidReportTask)project.getTasks().create("mergeAndroidReports", AndroidReportTask.class);
        mergeReportsTask.setGroup("verification");
        mergeReportsTask.setDescription("Merges all the Android test reports from the sub projects.");
        mergeReportsTask.setReportType(ReportType.MULTI_PROJECT);
        mergeReportsTask.setResultsDir(() -> {
            String resultsDir = this.extension.getResultsDir();
            if (resultsDir == null) {
                return new File(project.getBuildDir(), BuilderConstants.FD_ANDROID_RESULTS);
            }
            return project.file((Object)resultsDir);
        });
        mergeReportsTask.setReportsDir(() -> {
            String reportsDir = this.extension.getReportDir();
            if (reportsDir == null) {
                return new File(new File(project.getBuildDir(), "reports"), "androidTests");
            }
            return project.file((Object)reportsDir);
        });
        project.afterEvaluate(prj -> {
            for (Project p : prj.getSubprojects()) {
                TaskCollection tasks = p.getTasks().withType(AndroidReportTask.class);
                for (AndroidReportTask task : tasks) {
                    mergeReportsTask.addTask(task);
                }
                TaskCollection tasks2 = p.getTasks().withType(DeviceProviderInstrumentTestTask.class);
                for (DeviceProviderInstrumentTestTask task : tasks2) {
                    mergeReportsTask.addTask(task);
                }
            }
        });
        if (project.getGradle().getStartParameter().isContinueOnFailure()) {
            project.getGradle().getTaskGraph().whenReady(taskExecutionGraph -> {
                if (taskExecutionGraph.hasTask((Task)mergeReportsTask)) {
                    mergeReportsTask.setWillRun();
                }
            });
        }
    }
}

