/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

public class DefaultAndroidSourceDirectorySet
implements AndroidSourceDirectorySet {
    private final String name;
    private final Project project;
    private List<Object> source = Lists.newArrayList();
    private final PatternSet filter = new PatternSet();

    public DefaultAndroidSourceDirectorySet(String name, Project project) {
        this.name = name;
        this.project = project;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AndroidSourceDirectorySet srcDir(Object srcDir) {
        this.source.add(srcDir);
        return this;
    }

    @Override
    public AndroidSourceDirectorySet srcDirs(Object ... srcDirs) {
        Collections.addAll(this.source, srcDirs);
        return this;
    }

    @Override
    public AndroidSourceDirectorySet setSrcDirs(Iterable<?> srcDirs) {
        this.source.clear();
        for (Object srcDir : srcDirs) {
            this.source.add(srcDir);
        }
        return this;
    }

    @Override
    public FileTree getSourceFiles() {
        FileTree src = null;
        Set<File> sources = this.getSrcDirs();
        if (!sources.isEmpty()) {
            src = this.project.files(new Object[]{new ArrayList<File>(sources)}).getAsFileTree().matching((PatternFilterable)this.filter);
        }
        return src == null ? this.project.files(new Object[0]).getAsFileTree() : src;
    }

    @Override
    public List<ConfigurableFileTree> getSourceDirectoryTrees() {
        return (List)this.source.stream().map(sourceDir -> this.project.fileTree((Map)ImmutableMap.of((Object)"dir", (Object)sourceDir, (Object)"includes", this.getIncludes(), (Object)"excludes", this.getExcludes()))).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Set<File> getSrcDirs() {
        return ImmutableSet.copyOf((Collection)this.project.files(this.source.toArray()).getFiles());
    }

    @Override
    public PatternFilterable getFilter() {
        return this.filter;
    }

    public String toString() {
        return this.source.toString();
    }

    public Set<String> getIncludes() {
        return this.filter.getIncludes();
    }

    public Set<String> getExcludes() {
        return this.filter.getExcludes();
    }

    public PatternFilterable setIncludes(Iterable<String> includes) {
        this.filter.setIncludes(includes);
        return this;
    }

    public PatternFilterable setExcludes(Iterable<String> excludes) {
        this.filter.setExcludes(excludes);
        return this;
    }

    public PatternFilterable include(String ... includes) {
        this.filter.include(includes);
        return this;
    }

    public PatternFilterable include(Iterable<String> includes) {
        this.filter.include(includes);
        return this;
    }

    public PatternFilterable include(Spec<FileTreeElement> includeSpec) {
        this.filter.include(includeSpec);
        return this;
    }

    public PatternFilterable include(Closure includeSpec) {
        this.filter.include(includeSpec);
        return this;
    }

    public PatternFilterable exclude(Iterable<String> excludes) {
        this.filter.exclude(excludes);
        return this;
    }

    public PatternFilterable exclude(String ... excludes) {
        this.filter.exclude(excludes);
        return this;
    }

    public PatternFilterable exclude(Spec<FileTreeElement> excludeSpec) {
        this.filter.exclude(excludeSpec);
        return this;
    }

    public PatternFilterable exclude(Closure excludeSpec) {
        this.filter.exclude(excludeSpec);
        return this;
    }
}

