/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.Closeable;
import java.io.IOException;

public abstract class AndroidBuildGradleJsonStreamingParser
implements Closeable {
    private final JsonReader reader;

    protected AndroidBuildGradleJsonStreamingParser(JsonReader reader) {
        this.reader = reader;
    }

    public void parse() throws IOException {
        this.reader.beginObject();
        block16: while (this.reader.hasNext()) {
            String name;
            switch (name = this.reader.nextName()) {
                case "buildFiles": {
                    this.parseBuildFiles();
                    continue block16;
                }
                case "cleanCommands": {
                    this.parseCleanCommands();
                    continue block16;
                }
                case "cFileExtensions": {
                    this.parseCFileExtensions();
                    continue block16;
                }
                case "cppFileExtensions": {
                    this.parseCppFileExtensions();
                    continue block16;
                }
                case "libraries": {
                    this.parseLibraries();
                    continue block16;
                }
                case "toolchains": {
                    this.parseToolchains();
                    continue block16;
                }
            }
            this.parseUnknown();
        }
        this.reader.endObject();
    }

    private void parseUnknown() throws IOException {
        JsonToken peek = this.reader.peek();
        switch (peek) {
            case BEGIN_OBJECT: {
                this.parseUnknownObject();
                break;
            }
            case BEGIN_ARRAY: {
                this.parseUnknownArray();
                break;
            }
            case STRING: {
                this.reader.nextString();
                break;
            }
            case NAME: {
                this.reader.nextName();
                break;
            }
            case NULL: {
                this.reader.nextNull();
                break;
            }
            case NUMBER: {
                this.reader.nextString();
                break;
            }
            case BOOLEAN: {
                this.reader.nextBoolean();
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unexpected: Saw Gson token '%s' while parsing new and unrecognized Json section. ", peek.toString()));
            }
        }
    }

    private void parseUnknownArray() throws IOException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            this.parseUnknown();
        }
        this.reader.endArray();
    }

    private void parseUnknownObject() throws IOException {
        this.reader.beginObject();
        while (this.reader.hasNext()) {
            this.parseUnknown();
        }
        this.reader.endObject();
    }

    private void parseLibraryObject() throws IOException {
        this.reader.beginObject();
        block22: while (this.reader.hasNext()) {
            String name;
            switch (name = this.reader.nextName()) {
                case "abi": {
                    this.visitLibraryAbi(this.reader.nextString());
                    continue block22;
                }
                case "artifactName": {
                    this.visitLibraryArtifactName(this.reader.nextString());
                    continue block22;
                }
                case "buildCommand": {
                    this.visitLibraryBuildCommand(this.reader.nextString());
                    continue block22;
                }
                case "buildType": {
                    this.visitLibraryBuildType(this.reader.nextString());
                    continue block22;
                }
                case "output": {
                    this.visitLibraryOutput(this.reader.nextString());
                    continue block22;
                }
                case "toolchain": {
                    this.visitLibraryToolchain(this.reader.nextString());
                    continue block22;
                }
                case "groupName": {
                    this.visitLibraryGroupName(this.reader.nextString());
                    continue block22;
                }
                case "files": {
                    this.parseLibraryFiles();
                    continue block22;
                }
                case "runtimeFiles": {
                    this.parseLibraryRuntimeFiles();
                    continue block22;
                }
            }
            this.parseUnknown();
        }
        this.reader.endObject();
    }

    private void parseToolchainObject() throws IOException {
        this.reader.beginObject();
        block8: while (this.reader.hasNext()) {
            String name;
            switch (name = this.reader.nextName()) {
                case "cCompilerExecutable": {
                    this.visitToolchainCCompilerExecutable(this.reader.nextString());
                    continue block8;
                }
                case "cppCompilerExecutable": {
                    this.visitToolchainCppCompilerExecutable(this.reader.nextString());
                    continue block8;
                }
            }
            this.parseUnknown();
        }
        this.reader.endObject();
    }

    private void parseLibraryFileObject() throws IOException {
        this.reader.beginObject();
        block10: while (this.reader.hasNext()) {
            String name;
            switch (name = this.reader.nextName()) {
                case "flags": {
                    this.visitLibraryFileFlags(this.reader.nextString());
                    continue block10;
                }
                case "src": {
                    this.visitLibraryFileSrc(this.reader.nextString());
                    continue block10;
                }
                case "workingDirectory": {
                    this.visitLibraryFileWorkingDirectory(this.reader.nextString());
                    continue block10;
                }
            }
            this.parseUnknown();
        }
        this.reader.endObject();
    }

    private void parseBuildFiles() throws IOException {
        this.reader.beginArray();
        block10: while (this.reader.hasNext()) {
            JsonToken peek = this.reader.peek();
            switch (this.reader.peek()) {
                case STRING: {
                    this.visitBuildFile(this.reader.nextString());
                    continue block10;
                }
                case BEGIN_OBJECT: {
                    String name;
                    this.reader.beginObject();
                    switch (name = this.reader.nextName()) {
                        case "path": {
                            this.visitBuildFile(this.reader.nextString());
                            break;
                        }
                        default: {
                            this.parseUnknown();
                        }
                    }
                    this.reader.endObject();
                    continue block10;
                }
            }
            this.parseUnknown();
        }
        this.reader.endArray();
    }

    private void parseCleanCommands() throws IOException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            String value = this.reader.nextString();
            this.visitCleanCommands(value);
        }
        this.reader.endArray();
    }

    private void parseCFileExtensions() throws IOException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            String value = this.reader.nextString();
            this.visitCFileExtensions(value);
        }
        this.reader.endArray();
    }

    private void parseCppFileExtensions() throws IOException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            String value = this.reader.nextString();
            this.visitCppFileExtensions(value);
        }
        this.reader.endArray();
    }

    private void parseLibraries() throws IOException {
        this.reader.beginObject();
        while (this.reader.hasNext()) {
            String name = this.reader.nextName();
            this.beginLibrary(name);
            this.parseLibraryObject();
            this.endLibrary();
        }
        this.reader.endObject();
    }

    private void parseToolchains() throws IOException {
        this.reader.beginObject();
        while (this.reader.hasNext()) {
            String name = this.reader.nextName();
            this.beginToolchain(name);
            this.parseToolchainObject();
            this.endToolchain();
        }
        this.reader.endObject();
    }

    private void parseLibraryFiles() throws IOException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            this.beginLibraryFile();
            this.parseLibraryFileObject();
            this.endLibraryFile();
        }
        this.reader.endArray();
    }

    private void parseLibraryRuntimeFiles() throws IOException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            this.visitLibraryRuntimeFile(this.reader.nextString());
        }
        this.reader.endArray();
    }

    protected void beginLibrary(String libraryName) {
    }

    protected void endLibrary() {
    }

    protected void beginLibraryFile() {
    }

    protected void endLibraryFile() {
    }

    protected void beginToolchain(String toolchain) {
    }

    protected void endToolchain() {
    }

    protected void visitBuildFile(String buildFile) {
    }

    protected void visitLibraryAbi(String abi) {
    }

    protected void visitLibraryArtifactName(String artifact) {
    }

    protected void visitLibraryBuildCommand(String buildCommand) {
    }

    protected void visitLibraryBuildType(String buildCommand) {
    }

    protected void visitLibraryOutput(String output) {
    }

    protected void visitLibraryToolchain(String toolchain) {
    }

    protected void visitLibraryGroupName(String groupName) {
    }

    protected void visitToolchainCCompilerExecutable(String executable) {
    }

    protected void visitToolchainCppCompilerExecutable(String executable) {
    }

    protected void visitLibraryFileFlags(String flags) {
    }

    protected void visitLibraryFileSrc(String src) {
    }

    protected void visitLibraryFileWorkingDirectory(String workingDirectory) {
    }

    protected void visitCleanCommands(String cleanCommand) {
    }

    protected void visitCFileExtensions(String buildFile) {
    }

    protected void visitCppFileExtensions(String buildFile) {
    }

    protected void visitLibraryRuntimeFile(String runtimeFile) {
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

