/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.profile.RecordingBuildListener;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.ProcessProfileWriterFactory;
import com.android.builder.profile.ProfileRecordWriter;
import com.android.utils.ILogger;
import java.io.File;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.gradle.BuildAdapter;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.BuildCompletionListener;

public final class ProfilerInitializer {
    private static final String PROFILE_DIRECTORY = "android-profile";
    private static final DateTimeFormatter PROFILE_FILE_NAME = DateTimeFormatter.ofPattern("'profile-'YYYY-MM-dd-HH-mm-ss-SSS'.rawproto'", Locale.US);
    private static final Object lock = new Object();
    private static volatile RecordingBuildListener recordingBuildListener;

    private ProfilerInitializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Project project, ProjectOptions projectOptions) {
        Object object = lock;
        synchronized (object) {
            if (recordingBuildListener != null) {
                return;
            }
            ProcessProfileWriterFactory.initialize((File)project.getRootProject().getProjectDir(), (String)project.getGradle().getGradleVersion(), (ILogger)new LoggerWrapper(project.getLogger()), (boolean)projectOptions.get(BooleanOption.ENABLE_PROFILE_JSON));
            recordingBuildListener = new RecordingBuildListener((ProfileRecordWriter)ProcessProfileWriter.get());
            project.getGradle().addListener((Object)recordingBuildListener);
        }
        project.getGradle().addListener((Object)new ProfileShutdownListener(project.getGradle()));
    }

    private static final class ProfileShutdownListener
    extends BuildAdapter
    implements BuildCompletionListener {
        private final Gradle gradle;
        private Path profileDir = null;

        ProfileShutdownListener(Gradle gradle) {
            this.gradle = gradle;
        }

        public void projectsEvaluated(Gradle gradle) {
            this.profileDir = gradle.getRootProject().getBuildDir().toPath().resolve(ProfilerInitializer.PROFILE_DIRECTORY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed() {
            try {
                Object object = lock;
                synchronized (object) {
                    if (recordingBuildListener != null) {
                        this.gradle.removeListener((Object)recordingBuildListener);
                        recordingBuildListener = null;
                        Path profileFile = this.profileDir == null ? null : this.profileDir.resolve(PROFILE_FILE_NAME.format(LocalDateTime.now()));
                        ProcessProfileWriterFactory.shutdownAndMaybeWrite(profileFile);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

