/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.builder.testing.TestData;
import com.android.sdklib.AndroidVersion;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.gradle.api.file.FileCollection;

public abstract class AbstractTestDataImpl
implements TestData {
    private final VariantConfiguration<?, ?, ?> testVariantConfig;
    private Map<String, String> extraInstrumentationTestRunnerArgs;
    private boolean animationsDisabled;
    protected final FileCollection testApkDir;
    protected final FileCollection testedApksDir;

    public AbstractTestDataImpl(VariantConfiguration<?, ?, ?> testVariantConfig, FileCollection testApkDir, FileCollection testedApksDir) {
        this.testVariantConfig = (VariantConfiguration)Preconditions.checkNotNull(testVariantConfig);
        this.extraInstrumentationTestRunnerArgs = Maps.newHashMap();
        this.testApkDir = testApkDir;
        this.testedApksDir = testedApksDir;
    }

    public String getInstrumentationRunner() {
        return this.testVariantConfig.getInstrumentationRunner();
    }

    public Map<String, String> getInstrumentationRunnerArguments() {
        return ImmutableMap.builder().putAll(this.testVariantConfig.getInstrumentationRunnerArguments()).putAll(this.extraInstrumentationTestRunnerArgs).build();
    }

    public void setExtraInstrumentationTestRunnerArgs(Map<String, String> extraInstrumentationTestRunnerArgs) {
        this.extraInstrumentationTestRunnerArgs = ImmutableMap.copyOf(extraInstrumentationTestRunnerArgs);
    }

    public boolean getAnimationsDisabled() {
        return this.animationsDisabled;
    }

    public void setAnimationsDisabled(boolean animationsDisabled) {
        this.animationsDisabled = animationsDisabled;
    }

    public boolean isTestCoverageEnabled() {
        return this.testVariantConfig.isTestCoverageEnabled();
    }

    public AndroidVersion getMinSdkVersion() {
        return this.testVariantConfig.getMinSdkVersion();
    }

    public String getFlavorName() {
        return this.testVariantConfig.getFlavorName().toUpperCase(Locale.getDefault());
    }

    public FileCollection getTestApkDir() {
        return this.testApkDir;
    }

    public FileCollection getTestedApksDir() {
        return this.testedApksDir;
    }

    public File getTestApk() {
        Collection<BuildOutput> testApkOutputs = BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.APK, this.testApkDir);
        if (testApkOutputs.size() != 1) {
            throw new RuntimeException("Unexpected number of main APKs, expected 1, got  " + testApkOutputs.size() + ":" + Joiner.on((String)",").join(testApkOutputs));
        }
        return testApkOutputs.iterator().next().getOutputFile();
    }
}

