/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class ZipMergingTask
extends AndroidVariantTask {
    private final byte[] buffer = new byte[8192];
    private FileCollection inputFiles;
    private File outputFile;

    void init(FileCollection inputFiles, File outputFile) {
        this.inputFiles = inputFiles;
        this.outputFile = outputFile;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public FileCollection getInputFiles() {
        return this.inputFiles;
    }

    @TaskAction
    public void merge() throws IOException {
        try (FileOutputStream fos = new FileOutputStream(this.outputFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             ZipOutputStream zos = new ZipOutputStream(bos);){
            HashSet entries = Sets.newHashSet();
            for (File inputFile : this.inputFiles) {
                FileInputStream fis = new FileInputStream(inputFile);
                Throwable throwable = null;
                try {
                    ZipInputStream zis = new ZipInputStream(fis);
                    Throwable throwable2 = null;
                    try {
                        ZipEntry entry;
                        while ((entry = zis.getNextEntry()) != null) {
                            int count;
                            String entryName;
                            if (entry.isDirectory() || entries.contains(entryName = entry.getName())) continue;
                            entries.add(entryName);
                            zos.putNextEntry(entry);
                            while ((count = zis.read(this.buffer)) != -1) {
                                zos.write(this.buffer, 0, count);
                            }
                            zos.closeEntry();
                            zis.closeEntry();
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (zis == null) continue;
                        if (throwable2 != null) {
                            try {
                                zis.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        zis.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (fis == null) continue;
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    fis.close();
                }
            }
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<ZipMergingTask> {
        private VariantScope scope;
        private File outputFile;

        public ConfigAction(VariantScope scope, File outputFile) {
            this.scope = scope;
            this.outputFile = outputFile;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("createFullJar");
        }

        @Override
        public Class<ZipMergingTask> getType() {
            return ZipMergingTask.class;
        }

        @Override
        public void execute(ZipMergingTask task) {
            task.init(this.scope.getOutput(TaskOutputHolder.TaskOutputType.LIBRARY_CLASSES).plus(this.scope.getOutput(TaskOutputHolder.TaskOutputType.LIBRARY_JAVA_RES)), this.outputFile);
            task.setVariantName(this.scope.getFullVariantName());
        }
    }
}

