/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.coverage;

import com.android.build.gradle.internal.LoggerWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.jacoco.core.JaCoCo;

public class JacocoPlugin
implements Plugin<Project> {
    public static final String ANT_CONFIGURATION_NAME = "androidJacocoAnt";
    public static final String AGENT_CONFIGURATION_NAME = "androidJacocoAgent";
    public static final String DEFAULT_JACOCO_VERSION = "0.7.4.201502262128";
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(JacocoPlugin.class);
    private Project project;
    private String jacocoVersion;

    public void apply(Project project) {
        this.project = project;
        this.addJacocoConfigurations();
    }

    public String getAgentRuntimeDependency() {
        return "org.jacoco:org.jacoco.agent:" + this.getJacocoVersion() + ":runtime";
    }

    private void addJacocoConfigurations() {
        Configuration config = (Configuration)this.project.getConfigurations().create(AGENT_CONFIGURATION_NAME);
        config.setVisible(false);
        config.setTransitive(true);
        config.setCanBeConsumed(false);
        config.setDescription("The Jacoco agent to use to get coverage data.");
        this.project.getDependencies().add(AGENT_CONFIGURATION_NAME, (Object)this.getAgentRuntimeDependency());
        config = (Configuration)this.project.getConfigurations().create(ANT_CONFIGURATION_NAME);
        config.setVisible(false);
        config.setTransitive(true);
        config.setCanBeConsumed(false);
        config.setDescription("The Jacoco ant tasks to use to get execute Gradle tasks.");
        this.project.getDependencies().add(ANT_CONFIGURATION_NAME, (Object)("org.jacoco:org.jacoco.ant:" + this.getJacocoVersion()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getJacocoVersion() {
        if (this.jacocoVersion != null) {
            return this.jacocoVersion;
        }
        String pomFile = "META-INF/maven/org.jacoco/org.jacoco.core/pom.properties";
        try (InputStream in = JaCoCo.class.getClassLoader().getResourceAsStream(pomFile);){
            if (in == null) {
                logger.warning("This is not a Jacoco maven jar. Using version %s.", DEFAULT_JACOCO_VERSION);
                String string = this.jacocoVersion = DEFAULT_JACOCO_VERSION;
                return string;
            }
            Properties properties = new Properties();
            properties.load(in);
            this.jacocoVersion = properties.getProperty("version", DEFAULT_JACOCO_VERSION);
            return this.jacocoVersion;
        }
        catch (IOException e) {
            logger.warning("Loading properties failed. Using version %s.", DEFAULT_JACOCO_VERSION);
            this.jacocoVersion = DEFAULT_JACOCO_VERSION;
        }
        return this.jacocoVersion;
    }
}

