/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.ide.NativeAndroidProjectBuilder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.builder.model.NativeAndroidProject;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class NativeModelBuilder
implements ToolingModelBuilder {
    private final VariantManager variantManager;

    public NativeModelBuilder(VariantManager variantManager) {
        this.variantManager = variantManager;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(NativeAndroidProject.class.getName());
    }

    public Object buildAll(String modelName, Project project) {
        NativeAndroidProjectBuilder builder = new NativeAndroidProjectBuilder(project.getName());
        for (VariantScope scope : this.variantManager.getVariantScopes()) {
            ExternalNativeJsonGenerator generator = scope.getExternalNativeJsonGenerator();
            if (generator == null) continue;
            builder.addBuildSystem(generator.getNativeBuildSystem().getName());
            try {
                for (JsonReader stream : generator.streamExistingNativeBuildConfigurations()) {
                    builder.addJson(stream, generator.getVariantName());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read native JSON data", e);
            }
        }
        return builder.buildOrNull();
    }
}

