/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.LocalVariable;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class ByteCodeUtils {
    public static final String CONSTRUCTOR = "<init>";
    public static final String CLASS_INITIALIZER = "<clinit>";
    private static final Type NUMBER_TYPE = Type.getObjectType((String)"java/lang/Number");
    private static final Method SHORT_VALUE = Method.getMethod((String)"short shortValue()");
    private static final Method BYTE_VALUE = Method.getMethod((String)"byte byteValue()");

    public static void unbox(GeneratorAdapter mv, Type type) {
        if (type.equals((Object)Type.SHORT_TYPE)) {
            mv.checkCast(NUMBER_TYPE);
            mv.invokeVirtual(NUMBER_TYPE, SHORT_VALUE);
        } else if (type.equals((Object)Type.BYTE_TYPE)) {
            mv.checkCast(NUMBER_TYPE);
            mv.invokeVirtual(NUMBER_TYPE, BYTE_VALUE);
        } else {
            mv.unbox(type);
        }
    }

    public static String textify(MethodNode method) {
        Textifier textifier = new Textifier();
        TraceMethodVisitor trace = new TraceMethodVisitor((Printer)textifier);
        method.accept((MethodVisitor)trace);
        String ret = "";
        for (Object line : textifier.getText()) {
            ret = ret + line;
        }
        return ret;
    }

    static void newVariableArray(GeneratorAdapter mv, List<LocalVariable> variables) {
        mv.push(variables.size());
        mv.newArray(Type.getType(Object.class));
        ByteCodeUtils.loadVariableArray(mv, variables, 0);
    }

    static void loadVariableArray(GeneratorAdapter mv, List<LocalVariable> variables, int offset) {
        for (int i = offset; i < variables.size(); ++i) {
            LocalVariable variable = variables.get(i);
            mv.dup();
            mv.push(i);
            mv.visitVarInsn(variable.type.getOpcode(21), variable.var);
            mv.box(variable.type);
            mv.arrayStore(Type.getType(Object.class));
        }
    }

    static void restoreVariables(GeneratorAdapter mv, List<LocalVariable> variables) {
        for (int i = 0; i < variables.size(); ++i) {
            LocalVariable variable = variables.get(i);
            mv.dup();
            mv.push(i);
            mv.arrayLoad(Type.getType(Object.class));
            mv.unbox(variable.type);
            mv.visitVarInsn(variable.type.getOpcode(54), variable.var);
        }
        mv.pop();
    }

    static List<LocalVariable> toLocalVariables(List<Type> types) {
        ArrayList variables = Lists.newArrayList();
        int stack = 0;
        for (int i = 0; i < types.size(); ++i) {
            Type type = types.get(i);
            variables.add(new LocalVariable(type, stack));
            stack += type.getSize();
        }
        return variables;
    }

    static Type getTypeForStoreOpcode(int opcode) {
        switch (opcode) {
            case 54: {
                return Type.INT_TYPE;
            }
            case 55: {
                return Type.LONG_TYPE;
            }
            case 56: {
                return Type.FLOAT_TYPE;
            }
            case 57: {
                return Type.DOUBLE_TYPE;
            }
            case 58: {
                return Type.getType(Object.class);
            }
        }
        return null;
    }

    public static String toInternalName(String className) {
        return className.replace('.', '/');
    }

    public static String getClassName(String memberName) {
        Preconditions.checkArgument((boolean)memberName.contains(":"), (Object)"Class name passed as argument.");
        return memberName.substring(0, memberName.indexOf(46));
    }

    public static Optional<String> getPackageName(String internalName) {
        List parts = Splitter.on((char)'/').splitToList((CharSequence)internalName);
        if (parts.size() == 1) {
            return Optional.empty();
        }
        return Optional.of(Joiner.on((char)'.').join(parts.subList(0, parts.size() - 1)));
    }
}

