/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.TestServerTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.testing.api.TestServer;
import com.android.utils.StringHelper;

public class TestServerTaskConfigAction
implements TaskConfigAction<TestServerTask> {
    private final VariantScope scope;
    private final TestServer testServer;

    public TestServerTaskConfigAction(VariantScope scope, TestServer testServer) {
        this.scope = scope;
        this.testServer = testServer;
    }

    @Override
    public String getName() {
        return this.scope.getVariantConfiguration().hasFlavors() ? this.scope.getTaskName(this.testServer.getName() + "Upload") : this.testServer.getName() + "Upload";
    }

    @Override
    public Class<TestServerTask> getType() {
        return TestServerTask.class;
    }

    @Override
    public void execute(TestServerTask serverTask) {
        BaseVariantData testedVariantData = this.scope.getTestedVariantData();
        String variantName = this.scope.getVariantConfiguration().getFullName();
        serverTask.setDescription("Uploads APKs for Build '" + variantName + "' to Test Server '" + StringHelper.capitalize((String)this.testServer.getName()) + "'.");
        serverTask.setGroup("verification");
        serverTask.setVariantName(variantName);
        serverTask.setTestServer(this.testServer);
        if (testedVariantData != null && testedVariantData.getScope().hasOutput(TaskOutputHolder.TaskOutputType.APK)) {
            serverTask.setTestedApks(testedVariantData.getScope().getOutput(TaskOutputHolder.TaskOutputType.APK));
        }
        serverTask.setTestApks(this.scope.getOutput(TaskOutputHolder.TaskOutputType.APK));
        if (!this.testServer.isConfigured()) {
            serverTask.setEnabled(false);
        }
    }
}

