/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.VariantOutput;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.FileCollection;

public class SplitList {
    public static final String RESOURCE_CONFIGS = "ResConfigs";
    private ImmutableList<Record> records;
    public static final SplitList EMPTY = new SplitList((List<Record>)ImmutableList.of());

    private SplitList(List<Record> records) {
        this.records = ImmutableList.copyOf(records);
    }

    public static SplitList load(FileCollection persistedList) throws IOException {
        String persistedData = FileUtils.readFileToString((File)persistedList.getSingleFile());
        Gson gson = new Gson();
        Type collectionType = new TypeToken<ArrayList<Record>>(){}.getType();
        return new SplitList((List)gson.fromJson(persistedData, collectionType));
    }

    public static SplitList maybeLoad(FileCollection persistedList) throws IOException {
        if (persistedList == null) {
            return EMPTY;
        }
        return SplitList.load(persistedList);
    }

    public Set<String> getFilters(VariantOutput.FilterType splitType) throws IOException {
        return this.getFilters(splitType.name());
    }

    public synchronized Set<String> getFilters(String filterType) throws IOException {
        Optional<Record> record = this.records.stream().filter(r -> ((Record)r).splitType.equals(filterType)).findFirst();
        return record.isPresent() ? record.get().values : ImmutableSet.of();
    }

    public void forEach(SplitAction action2) throws IOException {
        this.records.forEach(record -> {
            if (((Record)record).isConfigSplit() && !((Record)record).values.isEmpty()) {
                action2.apply(VariantOutput.FilterType.valueOf((String)((Record)record).splitType), ((Record)record).values);
            }
        });
    }

    public Set<String> getResourcesSplit() throws IOException {
        ImmutableSet.Builder allFilters = ImmutableSet.builder();
        allFilters.addAll(this.getFilters(VariantOutput.FilterType.DENSITY));
        allFilters.addAll(this.getFilters(VariantOutput.FilterType.LANGUAGE));
        return allFilters.build();
    }

    public static Set<String> getSplits(SplitList splitList, MultiOutputPolicy multiOutputPolicy) throws IOException {
        return multiOutputPolicy == MultiOutputPolicy.SPLITS ? splitList.getResourcesSplit() : ImmutableSet.of();
    }

    public static synchronized void save(File outputFile, Set<String> densityFilters, Set<String> languageFilters, Set<String> abiFilters, Collection<String> resourceConfigs) throws IOException {
        ImmutableList records = ImmutableList.of((Object)new Record(VariantOutput.FilterType.DENSITY.name(), densityFilters), (Object)new Record(VariantOutput.FilterType.LANGUAGE.name(), languageFilters), (Object)new Record(VariantOutput.FilterType.ABI.name(), abiFilters), (Object)new Record(RESOURCE_CONFIGS, (Set)ImmutableSet.copyOf(resourceConfigs)));
        Gson gson = new Gson();
        String listOfFilters = gson.toJson((Object)records);
        FileUtils.write((File)outputFile, (CharSequence)listOfFilters);
    }

    private static final class Record {
        private final String splitType;
        private final Set<String> values;

        private Record(String splitType, Set<String> values) {
            this.splitType = splitType;
            this.values = values;
        }

        private boolean isConfigSplit() {
            return !this.splitType.equals(SplitList.RESOURCE_CONFIGS);
        }
    }

    public static interface SplitAction {
        public void apply(VariantOutput.FilterType var1, Set<String> var2);
    }
}

