/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.builder.testing.api.TestServer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class TestServerTask
extends AndroidVariantTask {
    private FileCollection testApks;
    private FileCollection testedApks;
    TestServer testServer;

    @TaskAction
    public void sendToServer() {
        ImmutableList testedApkFiles;
        Object object = testedApkFiles = this.testedApks != null ? BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.APK, this.testedApks).stream().map(BuildOutput::getOutputFile).collect(Collectors.toList()) : ImmutableList.of();
        if (testedApkFiles.size() > 1) {
            throw new RuntimeException("Cannot handle split APKs");
        }
        File testedApkFile = testedApkFiles.isEmpty() ? null : (File)testedApkFiles.get(0);
        List testApkFiles = BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.APK, this.testApks).stream().map(BuildOutput::getOutputFile).collect(Collectors.toList());
        if (testApkFiles.size() > 1) {
            throw new RuntimeException("Cannot handle split APKs in test APKs");
        }
        this.testServer.uploadApks(this.getVariantName(), (File)testApkFiles.get(0), testedApkFile);
    }

    @InputFiles
    public FileCollection getTestApks() {
        return this.testApks;
    }

    @InputFiles
    @Optional
    public FileCollection getTestedApks() {
        return this.testedApks;
    }

    @Override
    @Input
    public String getVariantName() {
        return (String)Preconditions.checkNotNull((Object)super.getVariantName(), (Object)"Test server task must have a variant name.");
    }

    public TestServer getTestServer() {
        return this.testServer;
    }

    public void setTestServer(TestServer testServer) {
        this.testServer = testServer;
    }

    public void setTestApks(FileCollection testApks) {
        this.testApks = testApks;
    }

    public void setTestedApks(FileCollection testedApks) {
        this.testedApks = testedApks;
    }
}

