/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.VariantOutput;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.builder.model.SourceProvider;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.file.FileCollection;
import org.xml.sax.SAXException;

public class TestApplicationTestData
extends AbstractTestDataImpl {
    private final String testApplicationId;
    private final Map<String, String> testedProperties;
    private final GradleVariantConfiguration variantConfiguration;

    public TestApplicationTestData(GradleVariantConfiguration variantConfiguration, String testApplicationId, FileCollection testApkDir, FileCollection testedApksDir) {
        super(variantConfiguration, testApkDir, testedApksDir);
        this.variantConfiguration = variantConfiguration;
        this.testedProperties = new HashMap<String, String>();
        this.testApplicationId = testApplicationId;
    }

    public void loadFromMetadataFile(File metadataFile) throws ParserConfigurationException, SAXException, IOException {
        Collection<BuildOutput> testedManifests = BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, metadataFile.getParentFile());
        Optional<BuildOutput> splitOutput = testedManifests.stream().findFirst();
        if (!splitOutput.isPresent()) {
            throw new RuntimeException("No merged manifest metadata at " + metadataFile.getAbsolutePath());
        }
        this.testedProperties.putAll(splitOutput.get().getProperties());
    }

    public String getApplicationId() {
        return this.testApplicationId;
    }

    public String getTestedApplicationId() {
        return this.testedProperties.get("packageId");
    }

    public boolean isLibrary() {
        return false;
    }

    public ImmutableList<File> getTestedApks(ProcessExecutor processExecutor, File splitSelectExe, DeviceConfigProvider deviceConfigProvider, ILogger logger) throws ProcessException {
        ImmutableList.Builder selectedApks = ImmutableList.builder();
        Collection<BuildOutput> testedApkFiles = BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.APK, this.testedApksDir);
        if (testedApkFiles.size() > 1 && splitSelectExe != null) {
            OutputScope testedOutputScope = new OutputScope(MultiOutputPolicy.MULTI_APK);
            List<String> testedSplitApksPath = TestApplicationTestData.getSplitApks(testedOutputScope);
            selectedApks.addAll((Iterable)SplitOutputMatcher.computeBestOutput((ProcessExecutor)processExecutor, (File)splitSelectExe, (DeviceConfigProvider)deviceConfigProvider, (File)TestApplicationTestData.getMainApk(testedOutputScope), testedSplitApksPath));
        } else {
            if (testedApkFiles.size() > 1) {
                logger.warning("split-select tool unavailable, all split APKs will be installed", new Object[0]);
            }
            selectedApks.addAll((Iterable)testedApkFiles.stream().map(BuildOutput::getOutputFile).collect(Collectors.toList()));
        }
        return selectedApks.build();
    }

    public List<File> getTestDirectories() {
        ImmutableList.Builder javaDirectories = ImmutableList.builder();
        for (SourceProvider sourceProvider : this.variantConfiguration.getSortedSourceProviders()) {
            javaDirectories.addAll((Iterable)sourceProvider.getJavaDirectories());
        }
        return javaDirectories.build();
    }

    private static List<String> getSplitApks(OutputScope outputScope) {
        return outputScope.getOutputs(TaskOutputHolder.TaskOutputType.APK).stream().filter(splitOutput -> splitOutput.getApkInfo().getType() == VariantOutput.OutputType.SPLIT).map(splitOutput -> splitOutput.getOutputFile().getAbsolutePath()).collect(Collectors.toList());
    }

    private static File getMainApk(OutputScope outputScope) {
        Optional<File> mainApk = outputScope.getOutputs(TaskOutputHolder.TaskOutputType.APK).stream().filter(splitOutput -> splitOutput.getApkInfo().getType() != VariantOutput.OutputType.SPLIT).map(BuildOutput::getOutputFile).findFirst();
        if (mainApk.isPresent()) {
            return mainApk.get();
        }
        throw new RuntimeException("Cannot retrieve main APK");
    }
}

