/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.CombinedInput;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import java.io.File;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class CheckTestedAppObfuscation
extends AndroidVariantTask {
    FileCollection mappingFile;

    @InputFiles
    public FileCollection getMappingFile() {
        return this.mappingFile;
    }

    @OutputFile
    @Optional
    public File getDummyOutput() {
        return null;
    }

    @TaskAction
    void checkIfAppIsObfuscated() {
        if (!this.mappingFile.isEmpty()) {
            throw new RuntimeException("Mapping file found in tested application. Proguard must also be enabled in test plugin with:\nandroid {\n    buildTypes {\n        " + this.getVariantName() + " {\n            minifyEnabled true\n            useProguard true\n        }\n    }\n}\n");
        }
    }

    @Input
    public String getCombinedInput() {
        return new CombinedInput().add("dummyOutput", this.getDummyOutput()).toString();
    }

    public static class ConfigAction
    implements TaskConfigAction<CheckTestedAppObfuscation> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("checkTestedAppObfuscation");
        }

        @Override
        public Class<CheckTestedAppObfuscation> getType() {
            return CheckTestedAppObfuscation.class;
        }

        @Override
        public void execute(CheckTestedAppObfuscation task) {
            task.setVariantName(this.scope.getFullVariantName());
            task.mappingFile = this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.APK_MAPPING);
        }
    }
}

