/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.MergeConsumerProguardFilesConfigAction;
import com.android.build.gradle.internal.tasks.MergeFileTask;
import com.android.build.gradle.internal.tasks.PackageRenderscriptConfigAction;
import com.android.build.gradle.internal.transforms.LibraryAarJarsTransform;
import com.android.build.gradle.internal.transforms.LibraryBaseTransform;
import com.android.build.gradle.internal.transforms.LibraryIntermediateJarsTransform;
import com.android.build.gradle.internal.transforms.LibraryJniLibsTransform;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.internal.variant.VariantHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.AndroidZip;
import com.android.build.gradle.tasks.ExtractAnnotations;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.VerifyLibraryResourcesTask;
import com.android.build.gradle.tasks.ZipMergingTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.profile.Recorder;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class LibraryTaskManager
extends TaskManager {
    private Task assembleDefault;

    public LibraryTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(final VariantScope variantScope) {
        LibraryVariantData libVariantData = (LibraryVariantData)variantScope.getVariantData();
        final GradleVariantConfiguration variantConfig = variantScope.getVariantConfiguration();
        GlobalScope globalScope = variantScope.getGlobalScope();
        File intermediatesDir = globalScope.getIntermediatesDir();
        Collection<String> variantDirectorySegments = variantConfig.getDirectorySegments();
        String projectPath = this.project.getPath();
        String variantName = variantScope.getFullVariantName();
        this.createAnchorTasks(variantScope);
        this.createDependencyStreams(variantScope);
        this.createCheckManifestTask(variantScope);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_GENERATE_RES_VALUES_TASK, projectPath, variantName, () -> this.createGenerateResValuesTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_MANIFEST_TASK, projectPath, variantName, () -> this.createMergeLibManifestsTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_CREATE_RENDERSCRIPT_TASK, projectPath, variantName, () -> this.createRenderscriptTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_RESOURCES_TASK, projectPath, variantName, () -> this.createMergeResourcesTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_ASSETS_TASK, projectPath, variantName, () -> {
            this.createMergeAssetsTask(variantScope);
            this.createLibraryAssetsTask(variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_BUILD_CONFIG_TASK, projectPath, variantName, () -> this.createBuildConfigTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_PROCESS_RES_TASK, projectPath, variantName, () -> {
            this.createProcessResTask(variantScope, new File(globalScope.getIntermediatesDir(), "symbols/" + variantScope.getVariantData().getVariantConfiguration().getDirName()), variantScope.getProcessResourcePackageOutputDirectory(), null, TaskManager.MergeType.PACKAGE, globalScope.getProjectBaseName());
            if (!((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable() && !Boolean.TRUE.equals(variantScope.getGlobalScope().getExtension().getAaptOptions().getNamespaced())) {
                this.createVerifyLibraryResTask(variantScope, TaskManager.MergeType.MERGE);
            }
            this.createProcessJavaResTask(variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_AIDL_TASK, projectPath, variantName, () -> this.createAidlTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_SHADER_TASK, projectPath, variantName, () -> this.createShaderTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_COMPILE_TASK, projectPath, variantName, () -> {
            this.createDataBindingMergeArtifactsTaskIfNecessary(variantScope);
            this.createDataBindingTasksIfNecessary(variantScope, TaskManager.MergeType.PACKAGE);
            JavaCompile javacTask = this.createJavacTask(variantScope);
            this.addJavacClassesStream(variantScope);
            TaskManager.setJavaCompilerTask((Task)javacTask, variantScope);
        });
        if (!this.isComponentModelPlugin()) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_NDK_TASK, projectPath, variantName, () -> this.createNdkTasks(variantScope));
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantScope.getVariantData()));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_EXTERNAL_NATIVE_BUILD_TASK, projectPath, variantName, () -> {
            this.createExternalNativeBuildJsonGenerators(variantScope);
            this.createExternalNativeBuildTasks(variantScope);
        });
        this.createMergeJniLibFoldersTasks(variantScope);
        LibraryTaskManager.createStripNativeLibraryTask(this.taskFactory, variantScope);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_PACKAGING_TASK, projectPath, variantName, () -> {
            File rsFolder = variantScope.getIntermediateDir(TaskOutputHolder.TaskOutputType.RENDERSCRIPT_HEADERS);
            Sync task = this.taskFactory.create(new PackageRenderscriptConfigAction(variantScope, rsFolder));
            variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.RENDERSCRIPT_HEADERS, rsFolder, task.getName());
        });
        MergeFileTask mergeProguardFilesTask = (MergeFileTask)((Object)this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_PROGUARD_FILE_TASK, projectPath, variantName, () -> this.createMergeFileTask(variantScope)));
        if (this.projectOptions.get(BooleanOption.ENABLE_EXTRACT_ANNOTATIONS)) {
            this.taskFactory.create(new ExtractAnnotations.ConfigAction(this.extension, variantScope));
        }
        final boolean instrumented = ((CoreBuildType)variantConfig.getBuildType()).isTestCoverageEnabled() && !variantScope.getInstantRunBuildContext().isInInstantRunMode();
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_POST_COMPILATION_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                TransformManager transformManager = variantScope.getTransformManager();
                if (instrumented) {
                    LibraryTaskManager.this.createJacocoTransform(variantScope);
                }
                List<Transform> customTransforms = LibraryTaskManager.this.extension.getTransforms();
                List<List<Object>> customTransformsDependencies = LibraryTaskManager.this.extension.getTransformsDependencies();
                int count = customTransforms.size();
                for (int i = 0; i < count; ++i) {
                    Transform transform = customTransforms.get(i);
                    Sets.SetView difference = Sets.difference((Set)transform.getScopes(), TransformManager.PROJECT_ONLY);
                    if (!difference.isEmpty()) {
                        String scopes = difference.toString();
                        LibraryTaskManager.this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, String.format("Transforms with scopes '%s' cannot be applied to library projects.", scopes));
                    }
                    List<Object> deps = customTransformsDependencies.get(i);
                    transformManager.addTransform(LibraryTaskManager.this.taskFactory, variantScope, transform).ifPresent(t -> {
                        if (!deps.isEmpty()) {
                            t.dependsOn(new Object[]{deps});
                        }
                        if (transform.getScopes().isEmpty()) {
                            variantScope.getAssembleTask().dependsOn(new Object[]{t});
                        }
                    });
                }
                String packageName = variantConfig.getPackageFromManifest();
                if (packageName == null) {
                    throw new BuildException("Failed to read manifest", null);
                }
                File jarOutputFolder = variantScope.getIntermediateJarOutputFolder();
                File mainClassJar = new File(jarOutputFolder, "classes.jar");
                File mainResJar = new File(jarOutputFolder, "res.jar");
                LibraryIntermediateJarsTransform intermediateTransform = new LibraryIntermediateJarsTransform(mainClassJar, mainResJar, null, packageName, LibraryTaskManager.this.extension.getPackageBuildConfig());
                LibraryTaskManager.this.excludeDataBindingClassesIfNecessary(variantScope, intermediateTransform);
                Optional<TransformTask> intermediateTransformTask = transformManager.addTransform(LibraryTaskManager.this.taskFactory, variantScope, intermediateTransform);
                intermediateTransformTask.ifPresent(t -> {
                    variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.LIBRARY_CLASSES, mainClassJar, t.getName());
                    variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.LIBRARY_JAVA_RES, mainResJar, t.getName());
                });
                File mainFullJar = new File(jarOutputFolder, "full.jar");
                ZipMergingTask zipMerger = LibraryTaskManager.this.taskFactory.create(new ZipMergingTask.ConfigAction(variantScope, mainFullJar));
                variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.FULL_JAR, mainFullJar, zipMerger.getName());
                File intermediateJniLibsFolder = new File(jarOutputFolder, "jni");
                LibraryJniLibsTransform intermediateJniTransform = new LibraryJniLibsTransform("intermediateJniLibs", intermediateJniLibsFolder, TransformManager.PROJECT_ONLY);
                Optional<TransformTask> task = transformManager.addTransform(LibraryTaskManager.this.taskFactory, variantScope, intermediateJniTransform);
                task.ifPresent(t -> variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.LIBRARY_JNI, intermediateJniLibsFolder, t.getName()));
                LibraryTaskManager.this.createMergeJavaResTransform(variantScope);
                LibraryTaskManager.this.maybeCreateJavaCodeShrinkerTransform(variantScope);
                LibraryTaskManager.this.maybeCreateResourcesShrinkerTransform(variantScope);
                File classesJar = variantScope.getAarClassesJar();
                File libsDirectory = variantScope.getAarLibsDirectory();
                LibraryAarJarsTransform transform = new LibraryAarJarsTransform(classesJar, libsDirectory, variantScope.hasOutput(TaskOutputHolder.TaskOutputType.ANNOTATIONS_TYPEDEF_FILE) ? variantScope.getOutput(TaskOutputHolder.TaskOutputType.ANNOTATIONS_TYPEDEF_FILE) : null, packageName, LibraryTaskManager.this.extension.getPackageBuildConfig());
                LibraryTaskManager.this.excludeDataBindingClassesIfNecessary(variantScope, transform);
                Optional<TransformTask> libraryJarTransformTask = transformManager.addTransform(LibraryTaskManager.this.taskFactory, variantScope, transform);
                libraryJarTransformTask.ifPresent(t -> {
                    variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.AAR_MAIN_JAR, classesJar, t.getName());
                    variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.AAR_LIBS_DIRECTORY, libsDirectory, t.getName());
                });
                File jniLibsFolder = variantScope.getIntermediateDir(TaskOutputHolder.TaskOutputType.LIBRARY_AND_LOCAL_JARS_JNI);
                LibraryJniLibsTransform jniTransform = new LibraryJniLibsTransform("syncJniLibs", jniLibsFolder, TransformManager.SCOPE_FULL_LIBRARY_WITH_LOCAL_JARS);
                Optional<TransformTask> jniPackagingTask = transformManager.addTransform(LibraryTaskManager.this.taskFactory, variantScope, jniTransform);
                jniPackagingTask.ifPresent(t -> variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.LIBRARY_AND_LOCAL_JARS_JNI, jniLibsFolder, t.getName()));
                return null;
            }
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.LIB_TASK_MANAGER_CREATE_LINT_TASK, projectPath, variantName, () -> this.createLintTasks(variantScope));
        this.createBundleTask(variantScope);
    }

    private void createBundleTask(VariantScope variantScope) {
        LibraryVariantData libVariantData = (LibraryVariantData)variantScope.getVariantData();
        GradleVariantConfiguration variantConfig = variantScope.getVariantConfiguration();
        AndroidZip bundle = (AndroidZip)this.project.getTasks().create(variantScope.getTaskName("bundle"), AndroidZip.class);
        libVariantData.addTask(TaskContainer.TaskKind.PACKAGE_ANDROID_ARTIFACT, (Task)bundle);
        bundle.setDuplicatesStrategy(DuplicatesStrategy.FAIL);
        bundle.setReproducibleFileOrder(true);
        bundle.setPreserveFileTimestamps(false);
        Preconditions.checkNotNull((Object)variantScope.getOutputScope().getMainSplit());
        bundle.setDescription("Assembles a bundle containing the library in " + variantConfig.getFullName() + ".");
        bundle.setDestinationDir(variantScope.getAarLocation());
        bundle.setArchiveNameSupplier(() -> variantScope.getOutputScope().getMainSplit().getOutputFileName());
        bundle.setExtension("aar");
        bundle.from(variantScope.getOutput(TaskOutputHolder.TaskOutputType.AIDL_PARCELABLE), LibraryTaskManager.prependToCopyPath("aidl"));
        bundle.from(new Object[]{variantScope.getOutput(TaskOutputHolder.TaskOutputType.CONSUMER_PROGUARD_FILE)});
        if (this.extension.getDataBinding().isEnabled()) {
            bundle.from(variantScope.getOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_ARTIFACT), LibraryTaskManager.prependToCopyPath("data-binding"));
        }
        bundle.from(new Object[]{variantScope.getOutput(TaskOutputHolder.TaskOutputType.LIBRARY_MANIFEST)});
        if (!Boolean.TRUE.equals(variantScope.getGlobalScope().getExtension().getAaptOptions().getNamespaced())) {
            bundle.from(new Object[]{variantScope.getOutput(TaskOutputHolder.TaskOutputType.SYMBOL_LIST)});
            bundle.from(variantScope.getOutput(TaskOutputHolder.TaskOutputType.PACKAGED_RES), LibraryTaskManager.prependToCopyPath("res"));
        }
        bundle.from(variantScope.getOutput(TaskOutputHolder.TaskOutputType.RENDERSCRIPT_HEADERS), LibraryTaskManager.prependToCopyPath("rs"));
        bundle.from(new Object[]{variantScope.getOutput(TaskOutputHolder.TaskOutputType.PUBLIC_RES)});
        if (variantScope.hasOutput(TaskOutputHolder.TaskOutputType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR)) {
            bundle.from(new Object[]{variantScope.getOutput(TaskOutputHolder.TaskOutputType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR)});
        }
        if (variantScope.hasOutput(TaskOutputHolder.TaskOutputType.RES_STATIC_LIBRARY)) {
            bundle.from(new Object[]{variantScope.getOutput(TaskOutputHolder.TaskOutputType.RES_STATIC_LIBRARY)});
        }
        bundle.from(variantScope.getOutput(TaskOutputHolder.TaskOutputType.LIBRARY_AND_LOCAL_JARS_JNI), LibraryTaskManager.prependToCopyPath("jni"));
        bundle.from(new Object[]{variantScope.getGlobalScope().getOutput(TaskOutputHolder.TaskOutputType.LINT_JAR)});
        if (variantScope.hasOutput(TaskOutputHolder.TaskOutputType.ANNOTATIONS_ZIP)) {
            bundle.from(new Object[]{variantScope.getOutput(TaskOutputHolder.TaskOutputType.ANNOTATIONS_ZIP)});
        }
        bundle.from(new Object[]{variantScope.getOutput(TaskOutputHolder.TaskOutputType.AAR_MAIN_JAR)});
        bundle.from(variantScope.getOutput(TaskOutputHolder.TaskOutputType.AAR_LIBS_DIRECTORY), LibraryTaskManager.prependToCopyPath("libs"));
        bundle.from(variantScope.getOutput(TaskOutputHolder.TaskOutputType.LIBRARY_ASSETS), LibraryTaskManager.prependToCopyPath("assets"));
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.AAR, () -> new File(variantScope.getAarLocation(), variantScope.getOutputScope().getMainSplit().getOutputFileName()), bundle.getName());
        libVariantData.packageLibTask = bundle;
        variantScope.getAssembleTask().dependsOn(new Object[]{bundle});
        if (this.extension.getDefaultPublishConfig().equals(variantConfig.getFullName())) {
            VariantHelper.setupArchivesConfig(this.project, variantScope.getVariantDependencies().getRuntimeClasspath());
            this.project.getArtifacts().add("default", (Object)bundle);
        }
    }

    private static Action<CopySpec> prependToCopyPath(String pathSegment) {
        return copySpec -> copySpec.eachFile(fileCopyDetails -> fileCopyDetails.setRelativePath(fileCopyDetails.getRelativePath().prepend(new String[]{pathSegment})));
    }

    @Override
    protected void createDependencyStreams(VariantScope variantScope) {
        super.createDependencyStreams(variantScope);
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "local-deps-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.LOCAL_DEPS).setJars(variantScope.getLocalPackagedJars()).build());
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "local-deps-native").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.RESOURCES, ExtendedContentType.NATIVE_LIBS}).addScope(InternalScope.LOCAL_DEPS).setJars(variantScope.getLocalPackagedJars()).build());
    }

    private MergeFileTask createMergeFileTask(VariantScope variantScope) {
        File outputFile = variantScope.getConsumerProguardFile();
        MergeFileTask task = this.taskFactory.create(new MergeConsumerProguardFilesConfigAction(this.project, variantScope, outputFile));
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.CONSUMER_PROGUARD_FILE, outputFile, task.getName());
        return task;
    }

    private void createMergeResourcesTask(VariantScope variantScope) {
        ImmutableSet flags = Boolean.TRUE.equals(variantScope.getGlobalScope().getExtension().getAaptOptions().getNamespaced()) ? Sets.immutableEnumSet((Enum)MergeResources.Flag.REMOVE_RESOURCE_NAMESPACES, (Enum[])new MergeResources.Flag[0]) : ImmutableSet.of();
        MergeResources mergeResourceTask = this.basicCreateMergeResourcesTask(variantScope, TaskManager.MergeType.PACKAGE, variantScope.getIntermediateDir(TaskOutputHolder.TaskOutputType.PACKAGED_RES), false, false, false, (ImmutableSet<MergeResources.Flag>)flags);
        this.createMergeResourcesTask(variantScope, false);
        File publicTxt = new File(variantScope.getIntermediateDir(TaskOutputHolder.TaskOutputType.PUBLIC_RES), "public.txt");
        mergeResourceTask.setPublicFile(publicTxt);
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.PUBLIC_RES, publicTxt, mergeResourceTask.getName());
    }

    @Override
    protected void postJavacCreation(VariantScope scope) {
        ConfigurableFileCollection fileCollection = scope.createAnchorOutput(TaskOutputHolder.AnchorOutputType.ALL_CLASSES);
        fileCollection.from(new Object[]{scope.getOutput(TaskOutputHolder.TaskOutputType.JAVAC)});
        fileCollection.from(new Object[]{scope.getVariantData().getAllPreJavacGeneratedBytecode()});
        fileCollection.from(new Object[]{scope.getVariantData().getAllPostJavacGeneratedBytecode()});
    }

    private void excludeDataBindingClassesIfNecessary(VariantScope variantScope, LibraryBaseTransform transform) {
        if (!this.extension.getDataBinding().isEnabled()) {
            return;
        }
        transform.addExcludeListProvider(() -> {
            File excludeFile = variantScope.getVariantData().getType().isExportDataBindingClassList() ? variantScope.getGeneratedClassListOutputFileForDataBinding() : null;
            File dataBindingFolder = variantScope.getBuildFolderForDataBindingCompiler();
            return this.dataBindingBuilder.getJarExcludeList(variantScope.getVariantData().getLayoutXmlProcessor(), excludeFile, dataBindingFolder);
        });
    }

    public MergeSourceSetFolders createLibraryAssetsTask(VariantScope scope) {
        GradleVariantConfiguration variantConfiguration = scope.getVariantConfiguration();
        File outputDir = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"packagedAssets", variantConfiguration.getDirName()});
        MergeSourceSetFolders mergeAssetsTask = this.taskFactory.create(new MergeSourceSetFolders.LibraryAssetConfigAction(scope, outputDir));
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.LIBRARY_ASSETS, outputDir, mergeAssetsTask.getName());
        mergeAssetsTask.dependsOn(new Object[]{scope.getAssetGenTask()});
        scope.setMergeAssetsTask(mergeAssetsTask);
        return mergeAssetsTask;
    }

    @Override
    protected Set<? super QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        if (variantScope.getTestedVariantData() != null) {
            return TransformManager.SCOPE_FULL_PROJECT;
        }
        return TransformManager.PROJECT_ONLY;
    }

    @Override
    protected boolean isLibrary() {
        return true;
    }

    private Task getAssembleDefault() {
        if (this.assembleDefault == null) {
            this.assembleDefault = (Task)this.project.getTasks().findByName("assembleDefault");
        }
        return this.assembleDefault;
    }

    public void createVerifyLibraryResTask(VariantScope scope, TaskManager.MergeType mergeType) {
        VerifyLibraryResourcesTask verifyLibraryResources = this.taskFactory.create(new VerifyLibraryResourcesTask.ConfigAction(scope, mergeType));
        scope.getAssembleTask().dependsOn(new Object[]{verifyLibraryResources});
    }
}

