/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.InstantRunBuildMode;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.google.common.collect.ImmutableMap;

public enum InstantRunVerifierStatus {
    NO_CHANGES(InstantRunBuildMode.HOT_WARM),
    COMPATIBLE(InstantRunBuildMode.HOT_WARM),
    NOT_RUN,
    INSTANT_RUN_DISABLED,
    INSTANT_RUN_FAILURE,
    CLASS_ADDED,
    PARENT_CLASS_CHANGED,
    IMPLEMENTED_INTERFACES_CHANGE,
    CLASS_ANNOTATION_CHANGE,
    STATIC_INITIALIZER_CHANGE,
    CONSTRUCTOR_SIGNATURE_CHANGE,
    METHOD_SIGNATURE_CHANGE,
    METHOD_ANNOTATION_CHANGE,
    METHOD_DELETED,
    METHOD_ADDED,
    ABSTRACT_METHOD_CHANGE,
    FIELD_ADDED,
    FIELD_REMOVED,
    FIELD_TYPE_CHANGE,
    R_CLASS_CHANGE,
    REFLECTION_USED,
    JAVA_RESOURCES_CHANGED,
    BUILD_NOT_INCREMENTAL,
    DEPENDENCY_CHANGED,
    MANIFEST_FILE_CHANGE,
    BINARY_MANIFEST_FILE_CHANGE,
    COLD_SWAP_REQUESTED,
    FULL_BUILD_REQUESTED(InstantRunBuildMode.FULL),
    INITIAL_BUILD(InstantRunBuildMode.FULL);

    private final ImmutableMap<InstantRunPatchingPolicy, InstantRunBuildMode> buildMode;

    private InstantRunVerifierStatus() {
        this(InstantRunBuildMode.COLD);
    }

    private InstantRunVerifierStatus(InstantRunBuildMode multiApkBuildMode) {
        this.buildMode = ImmutableMap.of((Object)((Object)InstantRunPatchingPolicy.MULTI_APK), (Object)((Object)multiApkBuildMode), (Object)((Object)InstantRunPatchingPolicy.MULTI_APK_SEPARATE_RESOURCES), (Object)((Object)multiApkBuildMode));
    }

    public InstantRunBuildMode getInstantRunBuildModeForPatchingPolicy(InstantRunPatchingPolicy patchingPolicy) {
        return (InstantRunBuildMode)((Object)this.buildMode.get((Object)patchingPolicy));
    }
}

