/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.DesugarIncrementalTransformHelper;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderCacheHandler;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.builder.core.DexOptions;
import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexArchiveBuilderConfig;
import com.android.builder.dexing.DexArchiveBuilderException;
import com.android.builder.dexing.DexArchives;
import com.android.builder.dexing.DexerTool;
import com.android.builder.dexing.r8.ClassFileProviderFactory;
import com.android.builder.utils.FileCache;
import com.android.dx.command.dexer.DxContext;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.DexParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.tooling.BuildException;
import org.gradle.workers.IsolationMode;

public class DexArchiveBuilderTransform
extends Transform {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(DexArchiveBuilderTransform.class);
    public static final int DEFAULT_BUFFER_SIZE_IN_KB = 100;
    public static final int NUMBER_OF_BUCKETS = 5;
    private final Supplier<List<File>> androidJarClasspath;
    private final DexOptions dexOptions;
    private final MessageReceiver messageReceiver;
    final WaitableExecutor executor;
    private final int minSdkVersion;
    private final DexerTool dexer;
    private String projectVariant;
    private boolean enableIncrementalDesugaring;
    private final DexArchiveBuilderCacheHandler cacheHandler;
    private final boolean useGradleWorkers;
    private final int inBufferSize;
    private final int outBufferSize;
    private final boolean isDebuggable;
    private final VariantScope.Java8LangSupport java8LangSupportType;

    DexArchiveBuilderTransform(Supplier<List<File>> androidJarClasspath, DexOptions dexOptions, MessageReceiver messageReceiver, FileCache userLevelCache, int minSdkVersion, DexerTool dexer, boolean useGradleWorkers, Integer inBufferSize, Integer outBufferSize, boolean isDebuggable, VariantScope.Java8LangSupport java8LangSupportType, String projectVariant, boolean enableIncrementalDesugaring) {
        this.androidJarClasspath = androidJarClasspath;
        this.dexOptions = dexOptions;
        this.messageReceiver = messageReceiver;
        this.minSdkVersion = minSdkVersion;
        this.dexer = dexer;
        this.projectVariant = projectVariant;
        this.enableIncrementalDesugaring = enableIncrementalDesugaring;
        this.executor = WaitableExecutor.useGlobalSharedThreadPool();
        this.cacheHandler = new DexArchiveBuilderCacheHandler(userLevelCache, dexOptions, minSdkVersion, isDebuggable, dexer);
        this.useGradleWorkers = useGradleWorkers;
        this.inBufferSize = (inBufferSize == null ? 100 : inBufferSize) * 1024;
        this.outBufferSize = (outBufferSize == null ? 100 : outBufferSize) * 1024;
        this.isDebuggable = isDebuggable;
        this.java8LangSupportType = java8LangSupportType;
    }

    public String getName() {
        return "dexBuilder";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE));
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_WITH_IR_FOR_DEXING;
    }

    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        return ImmutableSet.of((Object)QualifiedContent.Scope.PROVIDED_ONLY, (Object)QualifiedContent.Scope.TESTED_CODE);
    }

    public Map<String, Object> getParameterInputs() {
        try {
            HashMap params = Maps.newHashMapWithExpectedSize((int)4);
            params.put("optimize", !this.dexOptions.getAdditionalParameters().contains("--no-optimize"));
            params.put("jumbo", this.dexOptions.getJumboMode());
            params.put("min-sdk-version", this.minSdkVersion);
            params.put("dex-builder-tool", this.dexer.name());
            return params;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, IOException, InterruptedException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider, (Object)"Missing output provider.");
        if (this.dexer == DexerTool.D8) {
            logger.info("D8 is used to build dex.", new Object[0]);
        }
        if (this.dexOptions.getAdditionalParameters().contains("--no-optimize")) {
            logger.warning("Disabling dex optimization produces wrong local debug info, b.android.com/82031.", new Object[0]);
        }
        logger.verbose("Task is incremental : %b ", transformInvocation.isIncremental());
        if (!transformInvocation.isIncremental()) {
            outputProvider.deleteAll();
        }
        Set<File> additionalPaths = this.incrementalAnalysis(transformInvocation).stream().map(Path::toFile).collect(Collectors.toSet());
        ClassFileProviderFactory classFileProviderFactory = new ClassFileProviderFactory();
        ArrayList<DexArchiveBuilderCacheHandler.CacheableItem> cacheableItems = new ArrayList<DexArchiveBuilderCacheHandler.CacheableItem>();
        boolean isIncremental = transformInvocation.isIncremental();
        try {
            for (TransformInput input : transformInvocation.getInputs()) {
                List<String> bootclasspath = DexArchiveBuilderTransform.getBootClasspath(this.androidJarClasspath, this.java8LangSupportType);
                List<String> classpath = DexArchiveBuilderTransform.getClasspath(transformInvocation, this.java8LangSupportType);
                for (DirectoryInput dirInput : input.getDirectoryInputs()) {
                    logger.verbose("Dir input %s", dirInput.getFile().toString());
                    this.convertToDexArchive(transformInvocation.getContext(), (QualifiedContent)dirInput, outputProvider, isIncremental, classFileProviderFactory, bootclasspath, classpath, additionalPaths);
                }
                for (JarInput jarInput : input.getJarInputs()) {
                    logger.verbose("Jar input %s", jarInput.getFile().toString());
                    List<File> dexArchives = this.processJarInput(transformInvocation.getContext(), isIncremental, jarInput, outputProvider, classFileProviderFactory, bootclasspath, classpath, additionalPaths);
                    cacheableItems.add(new DexArchiveBuilderCacheHandler.CacheableItem((QualifiedContent)jarInput, dexArchives, bootclasspath, classpath));
                }
            }
            if (this.useGradleWorkers) {
                transformInvocation.getContext().getWorkerExecutor().await();
            } else {
                this.executor.waitForTasksWithQuickFail(true);
            }
            if (transformInvocation.isIncremental()) {
                for (TransformInput transformInput : transformInvocation.getInputs()) {
                    DexArchiveBuilderTransform.removeDeletedEntries(outputProvider, transformInput);
                }
            }
            if (!cacheableItems.isEmpty()) {
                this.cacheHandler.populateCache(cacheableItems);
            }
            logger.verbose("Done with all dex archive conversions", new Object[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TransformException((Throwable)e);
        }
        catch (Exception e) {
            logger.error(null, Throwables.getStackTraceAsString((Throwable)e), new Object[0]);
            throw new TransformException((Throwable)e);
        }
    }

    private static void removeDeletedEntries(TransformOutputProvider outputProvider, TransformInput transformInput) throws IOException {
        for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
            File outputFile = DexArchiveBuilderTransform.getPreDexFolder(outputProvider, directoryInput);
            DexArchive output = DexArchives.fromInput((Path)outputFile.toPath());
            Throwable throwable = null;
            try {
                for (Map.Entry fileStatusEntry : directoryInput.getChangedFiles().entrySet()) {
                    if (fileStatusEntry.getValue() != Status.REMOVED) continue;
                    Path relativePath = directoryInput.getFile().toPath().relativize(((File)fileStatusEntry.getKey()).toPath());
                    String fileToDelete = ((File)fileStatusEntry.getKey()).getName().endsWith(".class") ? ClassFileEntry.withDexExtension((String)relativePath.toString()) : relativePath.toString();
                    output.removeFile(fileToDelete);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (output == null) continue;
                if (throwable != null) {
                    try {
                        output.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                output.close();
            }
        }
    }

    private List<File> processJarInput(Context context, boolean isIncremental, JarInput jarInput, TransformOutputProvider transformOutputProvider, ClassFileProviderFactory classFileProviderFactory, List<String> bootclasspath, List<String> classpath, Set<File> additionalPaths) throws Exception {
        if (!isIncremental || additionalPaths.contains(jarInput.getFile())) {
            Preconditions.checkState((boolean)jarInput.getFile().exists(), (String)"File %s does not exist, yet it is reported as input. Try \ncleaning the build directory.", (Object)jarInput.getFile().toString());
            return this.convertJarToDexArchive(context, jarInput, transformOutputProvider, classFileProviderFactory, bootclasspath, classpath);
        }
        if (jarInput.getStatus() != Status.NOTCHANGED) {
            for (int bucketId = 0; bucketId < 5; ++bucketId) {
                File shardedOutput = DexArchiveBuilderTransform.getPreDexJar(transformOutputProvider, jarInput, bucketId);
                FileUtils.deleteIfExists((File)shardedOutput);
                if (jarInput.getStatus() == Status.REMOVED) continue;
                FileUtils.mkdirs((File)shardedOutput.getParentFile());
            }
            File nonShardedOutput = DexArchiveBuilderTransform.getPreDexJar(transformOutputProvider, jarInput, null);
            FileUtils.deleteIfExists((File)nonShardedOutput);
            if (jarInput.getStatus() != Status.REMOVED) {
                FileUtils.mkdirs((File)nonShardedOutput.getParentFile());
            }
            if (jarInput.getStatus() == Status.ADDED || jarInput.getStatus() == Status.CHANGED) {
                return this.convertJarToDexArchive(context, jarInput, transformOutputProvider, classFileProviderFactory, bootclasspath, classpath);
            }
        }
        return ImmutableList.of();
    }

    private List<File> convertJarToDexArchive(Context context, JarInput toConvert, TransformOutputProvider transformOutputProvider, ClassFileProviderFactory classFileProviderFactory, List<String> bootclasspath, List<String> classpath) throws Exception {
        File cachedVersion = this.cacheHandler.getCachedVersionIfPresent(toConvert, bootclasspath, classpath);
        if (cachedVersion == null) {
            return this.convertToDexArchive(context, (QualifiedContent)toConvert, transformOutputProvider, false, classFileProviderFactory, bootclasspath, classpath, (Set<File>)ImmutableSet.of());
        }
        File outputFile = DexArchiveBuilderTransform.getPreDexJar(transformOutputProvider, toConvert, null);
        Files.copy(cachedVersion.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return ImmutableList.of();
    }

    private static DexArchiveBuilder getDexArchiveBuilder(int minSdkVersion, List<String> dexAdditionalParameters, int inBufferSize, int outBufferSize, List<String> bootClasspath, List<String> classpath, DexerTool dexer, boolean isDebuggable, ClassFileProviderFactory classFileProviderFactory, boolean d8DesugaringEnabled, OutputStream outStream, OutputStream errStream) throws IOException {
        DexArchiveBuilder dexArchiveBuilder;
        switch (dexer) {
            case DX: {
                boolean optimizedDex = !dexAdditionalParameters.contains("--no-optimize");
                DxContext dxContext = new DxContext(outStream, errStream);
                DexArchiveBuilderConfig config = new DexArchiveBuilderConfig(dxContext, optimizedDex, inBufferSize, minSdkVersion, DexerTool.DX, outBufferSize, DexArchiveBuilderCacheHandler.isJumboModeEnabledForDx());
                dexArchiveBuilder = DexArchiveBuilder.createDxDexBuilder((DexArchiveBuilderConfig)config);
                break;
            }
            case D8: {
                dexArchiveBuilder = DexArchiveBuilder.createD8DexBuilder((int)minSdkVersion, (boolean)isDebuggable, bootClasspath.stream().map(string -> Paths.get(string, new String[0])).collect(Collectors.toList()), classpath.stream().map(string -> Paths.get(string, new String[0])).collect(Collectors.toList()), (ClassFileProviderFactory)classFileProviderFactory, (boolean)d8DesugaringEnabled);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown dexer type: " + dexer.name()));
            }
        }
        return dexArchiveBuilder;
    }

    private List<File> convertToDexArchive(Context context, QualifiedContent input, TransformOutputProvider outputProvider, boolean isIncremental, ClassFileProviderFactory classFileProviderFactory, List<String> bootClasspath, List<String> classpath, Set<File> additionalPaths) throws Exception {
        logger.verbose("Dexing %s", input.getFile().getAbsolutePath());
        ImmutableList.Builder dexArchives = ImmutableList.builder();
        for (int bucketId = 0; bucketId < 5; ++bucketId) {
            File preDexOutputFile = DexArchiveBuilderTransform.getPreDexFile(outputProvider, input, bucketId);
            dexArchives.add((Object)preDexOutputFile);
            DexConversionParameters parameters = new DexConversionParameters(input, bootClasspath, classpath, preDexOutputFile, 5, bucketId, this.minSdkVersion, this.dexOptions.getAdditionalParameters(), this.inBufferSize, this.outBufferSize, this.dexer, this.isDebuggable, isIncremental, classFileProviderFactory, this.java8LangSupportType, additionalPaths);
            if (this.useGradleWorkers) {
                context.getWorkerExecutor().submit(DexConversionWorkAction.class, configuration -> {
                    configuration.setIsolationMode(IsolationMode.NONE);
                    configuration.setParams(new Object[]{parameters});
                });
                continue;
            }
            this.executor.execute(() -> {
                ParsingProcessOutputHandler outputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new DexParser(), Message.Kind.ERROR, (ILogger)logger), new ToolOutputParser((PatternAwareOutputParser)new DexParser(), (ILogger)logger), new MessageReceiver[]{this.messageReceiver});
                ProcessOutput output = null;
                try (ProcessOutput ignored = output = outputHandler.createOutput();){
                    DexArchiveBuilderTransform.launchProcessing(parameters, output.getStandardOutput(), output.getErrorOutput());
                }
                finally {
                    if (output != null) {
                        try {
                            outputHandler.handleOutput(output);
                        }
                        catch (ProcessException processException) {}
                    }
                }
                return null;
            });
        }
        return dexArchives.build();
    }

    private static void launchProcessing(DexConversionParameters dexConversionParameters, OutputStream outStream, OutputStream errStream) throws IOException, URISyntaxException {
        DexArchiveBuilder dexArchiveBuilder = DexArchiveBuilderTransform.getDexArchiveBuilder(dexConversionParameters.minSdkVersion, dexConversionParameters.dexAdditionalParameters, dexConversionParameters.inBufferSize, dexConversionParameters.outBufferSize, dexConversionParameters.bootClasspath, dexConversionParameters.classpath, dexConversionParameters.dexer, dexConversionParameters.isDebuggable, dexConversionParameters.classFileProviderFactory, VariantScope.Java8LangSupport.D8 == dexConversionParameters.java8LangSupportType, outStream, errStream);
        Path inputPath = dexConversionParameters.input.getFile().toPath();
        Predicate<String> bucketFilter = dexConversionParameters::belongsToThisBucket;
        boolean hasIncrementalInfo = dexConversionParameters.isDirectoryBased() && dexConversionParameters.isIncremental;
        Predicate<String> toProcess = hasIncrementalInfo ? path -> {
            File resolved = inputPath.resolve((String)path).toFile();
            if (dexConversionParameters.additionalPaths.contains(resolved)) {
                return true;
            }
            Map changedFiles = ((DirectoryInput)dexConversionParameters.input).getChangedFiles();
            Status status = (Status)changedFiles.get(resolved);
            return status == Status.ADDED || status == Status.CHANGED;
        } : path -> true;
        bucketFilter = bucketFilter.and(toProcess);
        logger.verbose("Dexing '" + inputPath + "' to '" + dexConversionParameters.output + "'", new Object[0]);
        try (ClassFileInput input = ClassFileInputs.fromPath((Path)inputPath);){
            dexArchiveBuilder.convert(input.entries(bucketFilter), Paths.get(new URI(dexConversionParameters.output)), dexConversionParameters.isDirectoryBased());
        }
        catch (DexArchiveBuilderException ex) {
            throw new DexArchiveBuilderException("Failed to process " + inputPath.toString(), (Throwable)ex);
        }
    }

    private static List<String> getClasspath(TransformInvocation transformInvocation, VariantScope.Java8LangSupport java8LangSupportType) throws IOException {
        if (java8LangSupportType != VariantScope.Java8LangSupport.D8) {
            return Collections.emptyList();
        }
        ImmutableList.Builder classpathEntries = ImmutableList.builder();
        Iterable dependencies = Iterables.concat((Iterable)transformInvocation.getInputs(), (Iterable)transformInvocation.getReferencedInputs());
        classpathEntries.addAll(TransformInputUtil.getDirectories(dependencies).stream().map(File::getPath).distinct().iterator());
        classpathEntries.addAll(Streams.stream((Iterable)dependencies).flatMap(transformInput -> transformInput.getJarInputs().stream()).filter(jarInput -> jarInput.getStatus() != Status.REMOVED).map(jarInput -> jarInput.getFile().getPath()).distinct().iterator());
        return classpathEntries.build();
    }

    private static List<String> getBootClasspath(Supplier<List<File>> androidJarClasspath, VariantScope.Java8LangSupport java8LangSupportType) throws IOException {
        if (java8LangSupportType != VariantScope.Java8LangSupport.D8) {
            return Collections.emptyList();
        }
        ImmutableList.Builder classpathEntries = ImmutableList.builder();
        classpathEntries.addAll(androidJarClasspath.get().stream().map(file -> file.getPath()).iterator());
        return classpathEntries.build();
    }

    private static File getPreDexFile(TransformOutputProvider output, QualifiedContent qualifiedContent, int bucketId) {
        return qualifiedContent.getFile().isDirectory() ? DexArchiveBuilderTransform.getPreDexFolder(output, (DirectoryInput)qualifiedContent) : DexArchiveBuilderTransform.getPreDexJar(output, (JarInput)qualifiedContent, bucketId);
    }

    private static File getPreDexJar(TransformOutputProvider output, JarInput qualifiedContent, Integer bucketId) {
        return output.getContentLocation(qualifiedContent.getName() + (bucketId == null ? "" : "-" + bucketId), (Set)ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE)), qualifiedContent.getScopes(), Format.JAR);
    }

    private static File getPreDexFolder(TransformOutputProvider output, DirectoryInput directoryInput) {
        return FileUtils.mkdirs((File)output.getContentLocation(directoryInput.getName(), (Set)ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE)), directoryInput.getScopes(), Format.DIRECTORY));
    }

    private Set<Path> incrementalAnalysis(TransformInvocation invocation) throws InterruptedException {
        if (!this.enableIncrementalDesugaring || this.java8LangSupportType != VariantScope.Java8LangSupport.D8) {
            return ImmutableSet.of();
        }
        DesugarIncrementalTransformHelper helper = new DesugarIncrementalTransformHelper(this.projectVariant);
        return helper.getAdditionalPaths(invocation, this.executor);
    }

    public static class DexConversionWorkAction
    implements Runnable {
        private final DexConversionParameters dexConversionParameters;

        @Inject
        public DexConversionWorkAction(DexConversionParameters dexConversionParameters) {
            this.dexConversionParameters = dexConversionParameters;
        }

        @Override
        public void run() {
            try {
                DexArchiveBuilderTransform.launchProcessing(this.dexConversionParameters, System.out, System.err);
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class DexConversionParameters
    implements Serializable {
        private final QualifiedContent input;
        private final List<String> bootClasspath;
        private final List<String> classpath;
        private final String output;
        private final int numberOfBuckets;
        private final int buckedId;
        private final int minSdkVersion;
        private final List<String> dexAdditionalParameters;
        private final int inBufferSize;
        private final int outBufferSize;
        private final DexerTool dexer;
        private final boolean isDebuggable;
        private final boolean isIncremental;
        private final ClassFileProviderFactory classFileProviderFactory;
        private final VariantScope.Java8LangSupport java8LangSupportType;
        private final Set<File> additionalPaths;

        public DexConversionParameters(QualifiedContent input, List<String> bootClasspath, List<String> classpath, File output, int numberOfBuckets, int buckedId, int minSdkVersion, List<String> dexAdditionalParameters, int inBufferSize, int outBufferSize, DexerTool dexer, boolean isDebuggable, boolean isIncremental, ClassFileProviderFactory classFileProviderFactory, VariantScope.Java8LangSupport java8LangSupportType, Set<File> additionalPaths) {
            this.input = input;
            this.bootClasspath = bootClasspath;
            this.classpath = classpath;
            this.numberOfBuckets = numberOfBuckets;
            this.buckedId = buckedId;
            this.output = output.toURI().toString();
            this.minSdkVersion = minSdkVersion;
            this.dexAdditionalParameters = dexAdditionalParameters;
            this.inBufferSize = inBufferSize;
            this.outBufferSize = outBufferSize;
            this.dexer = dexer;
            this.isDebuggable = isDebuggable;
            this.isIncremental = isIncremental;
            this.classFileProviderFactory = classFileProviderFactory;
            this.java8LangSupportType = java8LangSupportType;
            this.additionalPaths = additionalPaths;
        }

        public boolean belongsToThisBucket(String path) {
            return Math.abs(path.hashCode()) % this.numberOfBuckets == this.buckedId;
        }

        public boolean isDirectoryBased() {
            return this.input instanceof DirectoryInput;
        }
    }
}

