/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.options;

import com.android.build.gradle.options.Option;

public enum IntegerOption implements Option<Integer>
{
    ANDROID_TEST_SHARD_COUNT("android.androidTest.numShards"),
    ANDROID_SDK_CHANNEL("android.sdk.channel"),
    IDE_BUILD_MODEL_ONLY_VERSION("android.injected.build.model.only.versioned"),
    IDE_TARGET_DEVICE_API("android.injected.build.api"),
    IDE_VERSION_CODE_OVERRIDE("android.injected.version.code"),
    DEXING_READ_BUFFER_SIZE("android.dexingReadBuffer.size"),
    DEXING_WRITE_BUFFER_SIZE("android.dexingWriteBuffer.size");

    private final String propertyName;

    private IntegerOption(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Integer getDefaultValue() {
        return null;
    }

    @Override
    public Integer parse(Object value) {
        if (value instanceof CharSequence) {
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new IllegalArgumentException("Cannot parse project property " + this.getPropertyName() + "='" + value + "' of type '" + value.getClass() + "' as integer.");
    }
}

