/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.options;

import android.databinding.tool.util.Preconditions;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.DeprecatedOptions;
import com.android.build.gradle.options.EnumOptions;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.LongOption;
import com.android.build.gradle.options.Option;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.StringOption;
import com.android.builder.model.OptionalCompilationStep;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.gradle.api.Project;

public final class ProjectOptions {
    public static final String PROPERTY_TEST_RUNNER_ARGS = "android.testInstrumentationRunnerArguments.";
    private final ImmutableMap<DeprecatedOptions, String> deprecatedOptions;
    private final ImmutableMap<BooleanOption, Boolean> booleanOptions;
    private final ImmutableMap<OptionalBooleanOption, Boolean> optionalBooleanOptions;
    private final ImmutableMap<IntegerOption, Integer> integerOptions;
    private final ImmutableMap<LongOption, Long> longOptions;
    private final ImmutableMap<StringOption, String> stringOptions;
    private final ImmutableMap<String, String> testRunnerArgs;
    private final EnumOptions enumOptions;

    public ProjectOptions(ImmutableMap<String, Object> properties) {
        this.deprecatedOptions = ProjectOptions.readOptions((Option[])DeprecatedOptions.values(), properties);
        this.booleanOptions = ProjectOptions.readOptions((Option[])BooleanOption.values(), properties);
        this.optionalBooleanOptions = ProjectOptions.readOptions((Option[])OptionalBooleanOption.values(), properties);
        this.integerOptions = ProjectOptions.readOptions((Option[])IntegerOption.values(), properties);
        this.longOptions = ProjectOptions.readOptions((Option[])LongOption.values(), properties);
        this.stringOptions = ProjectOptions.readOptions((Option[])StringOption.values(), properties);
        this.testRunnerArgs = ProjectOptions.readTestRunnerArgs(properties);
        this.enumOptions = EnumOptions.load((ImmutableMap<EnumOptions.EnumOption, String>)ProjectOptions.readOptions((Option[])EnumOptions.EnumOption.values(), properties));
    }

    public ProjectOptions(Project project) {
        this(ProjectOptions.copyProperties(project));
    }

    public ProjectOptions(Project project, ImmutableMap<String, Object> overwrites) {
        this(ProjectOptions.copyAndModifyProperties(project, overwrites));
    }

    private static ImmutableMap<String, Object> copyProperties(Project project) {
        return ProjectOptions.copyAndModifyProperties(project, (ImmutableMap<String, Object>)ImmutableMap.of());
    }

    private static ImmutableMap<String, Object> copyAndModifyProperties(Project project, ImmutableMap<String, Object> overwrites) {
        ImmutableMap.Builder optionsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : project.getExtensions().getExtraProperties().getProperties().entrySet()) {
            Object value = entry.getValue();
            if (value == null || overwrites.containsKey(entry.getKey())) continue;
            optionsBuilder.put(entry.getKey(), value);
        }
        for (Map.Entry overwrite : overwrites.entrySet()) {
            optionsBuilder.put(overwrite.getKey(), overwrite.getValue());
        }
        return optionsBuilder.build();
    }

    private static <OptionT extends Option<ValueT>, ValueT> ImmutableMap<OptionT, ValueT> readOptions(OptionT[] values, Map<String, ?> properties) {
        Map<String, Option> optionLookup = Arrays.stream(values).collect(Collectors.toMap(Option::getPropertyName, v -> v));
        ImmutableMap.Builder valuesBuilder = ImmutableMap.builder();
        for (Map.Entry<String, ?> property : properties.entrySet()) {
            Option option = optionLookup.get(property.getKey());
            if (option == null) continue;
            valuesBuilder.put((Object)option, option.parse(property.getValue()));
        }
        return valuesBuilder.build();
    }

    private static ImmutableMap<String, String> readTestRunnerArgs(Map<String, ?> properties) {
        ImmutableMap.Builder testRunnerArgsBuilder = ImmutableMap.builder();
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            String name = entry.getKey();
            if (!name.startsWith(PROPERTY_TEST_RUNNER_ARGS)) continue;
            String argName = name.substring(PROPERTY_TEST_RUNNER_ARGS.length());
            String argValue = entry.getValue().toString();
            testRunnerArgsBuilder.put((Object)argName, (Object)argValue);
        }
        return testRunnerArgsBuilder.build();
    }

    public boolean get(BooleanOption option) {
        return (Boolean)this.booleanOptions.getOrDefault((Object)option, (Object)option.getDefaultValue());
    }

    public Boolean get(OptionalBooleanOption option) {
        return (Boolean)this.optionalBooleanOptions.get((Object)option);
    }

    public Integer get(IntegerOption option) {
        return (Integer)this.integerOptions.getOrDefault((Object)option, (Object)option.getDefaultValue());
    }

    public Long get(LongOption option) {
        return (Long)this.longOptions.getOrDefault((Object)option, (Object)option.getDefaultValue());
    }

    public String get(StringOption option) {
        return (String)this.stringOptions.getOrDefault((Object)option, (Object)option.getDefaultValue());
    }

    public Map<String, String> getExtraInstrumentationTestRunnerArgs() {
        return this.testRunnerArgs;
    }

    public Set<OptionalCompilationStep> getOptionalCompilationSteps() {
        String values = this.get(StringOption.IDE_OPTIONAL_COMPILATION_STEPS);
        if (values != null) {
            ArrayList<OptionalCompilationStep> optionalCompilationSteps = new ArrayList<OptionalCompilationStep>();
            StringTokenizer st = new StringTokenizer(values, ",");
            while (st.hasMoreElements()) {
                optionalCompilationSteps.add(OptionalCompilationStep.valueOf((String)st.nextToken()));
            }
            return EnumSet.copyOf(optionalCompilationSteps);
        }
        return EnumSet.noneOf(OptionalCompilationStep.class);
    }

    public EnumOptions getEnumOptions() {
        return this.enumOptions;
    }

    public boolean hasDeprecatedOptions() {
        return !this.deprecatedOptions.isEmpty();
    }

    public String getDeprecatedOptionsErrorMessage() {
        Preconditions.check((boolean)this.hasDeprecatedOptions(), (String)"Has deprecated options should be checked before calling this method.", (Object[])new Object[0]);
        StringBuilder builder = new StringBuilder("The following project options are deprecated: \n");
        this.deprecatedOptions.forEach((option, errorMessage) -> builder.append(option.getPropertyName()).append("\n").append((String)errorMessage).append("\n\n"));
        return builder.toString();
    }
}

