/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.aapt;

import android.databinding.tool.util.Preconditions;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;

public enum AaptGeneration {
    AAPT_V1,
    AAPT_V2_JNI,
    AAPT_V2_DAEMON_MODE;


    public static AaptGeneration fromProjectOptions(ProjectOptions projectOptions) {
        if (projectOptions.get(BooleanOption.ENABLE_AAPT2)) {
            Preconditions.check((!projectOptions.get(BooleanOption.ENABLE_IN_PROCESS_AAPT2) || !projectOptions.get(BooleanOption.ENABLE_DAEMON_MODE_AAPT2) ? 1 : 0) != 0, (String)"Both JNI and Daemon mode versions of AAPT2 cannot be enabled at the same time. Please disable one of them (e.g. android.enableAapt2jni=false)", (Object[])new Object[0]);
            Preconditions.check((projectOptions.get(BooleanOption.ENABLE_IN_PROCESS_AAPT2) || projectOptions.get(BooleanOption.ENABLE_DAEMON_MODE_AAPT2) ? 1 : 0) != 0, (String)"To use AAPT2 either JNI or Daemon mode versions need to be enabled. Please enable one (e.g. android.enableAapt2DaemonMode=true)", (Object[])new Object[0]);
            if (projectOptions.get(BooleanOption.ENABLE_IN_PROCESS_AAPT2)) {
                return AAPT_V2_JNI;
            }
            return AAPT_V2_DAEMON_MODE;
        }
        return AAPT_V1;
    }
}

