/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclaration;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitPackageIds;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;

public class FeatureSplitPackageIdsWriterTask
extends AndroidVariantTask {
    FileCollection input;
    File outputDirectory;

    @InputFiles
    FileCollection getInput() {
        return this.input;
    }

    @OutputDirectory
    File getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    public void fullTaskAction() throws IOException {
        FeatureSplitPackageIds featureSplitPackageIds = new FeatureSplitPackageIds();
        for (File featureSplitDeclaration : this.input.getAsFileTree().getFiles()) {
            try {
                FeatureSplitDeclaration loaded = FeatureSplitDeclaration.load(featureSplitDeclaration);
                featureSplitPackageIds.addFeatureSplit(loaded.getUniqueIdentifier());
            }
            catch (FileNotFoundException e) {
                throw new BuildException("Cannot read features split declaration file", (Throwable)e);
            }
        }
        featureSplitPackageIds.save(this.outputDirectory);
    }

    public static class ConfigAction
    implements TaskConfigAction<FeatureSplitPackageIdsWriterTask> {
        private final VariantScope variantScope;
        private final File outputDirectory;

        public ConfigAction(VariantScope variantScope, File outputDirectory) {
            this.variantScope = variantScope;
            this.outputDirectory = outputDirectory;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("generate", "FeaturePackageIds");
        }

        @Override
        public Class<FeatureSplitPackageIdsWriterTask> getType() {
            return FeatureSplitPackageIdsWriterTask.class;
        }

        @Override
        public void execute(FeatureSplitPackageIdsWriterTask task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            task.outputDirectory = this.outputDirectory;
            task.input = this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.METADATA_FEATURE_DECLARATION);
        }
    }
}

