/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.SdkConstants;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.internal.transforms.InstantRunSplitApkBuilder;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.internal.aapt.AaptOptions;
import com.android.builder.utils.FileCache;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class InstantRunSliceSplitApkBuilder
extends InstantRunSplitApkBuilder {
    private final WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
    private final boolean runSerially;

    public InstantRunSliceSplitApkBuilder(Logger logger, Project project, InstantRunBuildContext buildContext, AndroidBuilder androidBuilder, FileCache fileCache, PackagingScope packagingScope, CoreSigningConfig signingConf, AaptGeneration aaptGeneration, AaptOptions aaptOptions, File outputDirectory, File supportDirectory, File aaptIntermediateDirectory, Boolean runAapt2Serially) {
        super(logger, project, buildContext, androidBuilder, fileCache, packagingScope, signingConf, aaptGeneration, aaptOptions, outputDirectory, supportDirectory, aaptIntermediateDirectory);
        this.runSerially = runAapt2Serially == null ? SdkConstants.CURRENT_PLATFORM == 2 : runAapt2Serially;
    }

    public String getName() {
        return "instantRunSlicesApk";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)((Object)ExtendedContentType.DEX));
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS});
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        ArrayList<InstantRunSplitApkBuilder.DexFiles> splitsToBuild = new ArrayList<InstantRunSplitApkBuilder.DexFiles>();
        if (transformInvocation.isIncremental()) {
            for (TransformInput transformInput : transformInvocation.getInputs()) {
                for (JarInput jarInput : transformInput.getJarInputs()) {
                    this.logger.error("InstantRunDependenciesApkBuilder received a jar file " + jarInput.getFile().getAbsolutePath());
                }
                block6: for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                    Map sliceStatuses = directoryInput.getChangedFiles().entrySet().stream().collect(Collectors.groupingBy(fileStatus -> ((File)fileStatus.getKey()).getParentFile(), Collectors.mapping(Map.Entry::getValue, Collectors.toSet())));
                    for (Map.Entry slices : sliceStatuses.entrySet()) {
                        if (slices.getValue().equals(EnumSet.of(Status.REMOVED))) {
                            InstantRunSplitApkBuilder.DexFiles dexFile = new InstantRunSplitApkBuilder.DexFiles((ImmutableSet<File>)ImmutableSet.of(), slices.getKey().getName());
                            String outputFileName = dexFile.encodeName() + "_unaligned.apk";
                            FileUtils.deleteIfExists((File)new File(this.outputDirectory, outputFileName));
                            outputFileName = dexFile.encodeName() + ".apk";
                            FileUtils.deleteIfExists((File)new File(this.outputDirectory, outputFileName));
                            continue block6;
                        }
                        if (slices.getValue().equals(EnumSet.of(Status.NOTCHANGED))) continue;
                        File[] dexFiles = slices.getKey().listFiles();
                        if (dexFiles == null) continue block6;
                        try {
                            splitsToBuild.add(new InstantRunSplitApkBuilder.DexFiles(dexFiles, directoryInput.getName()));
                            continue block6;
                        }
                        catch (Exception e) {
                            throw new TransformException((Throwable)e);
                        }
                    }
                }
            }
        } else {
            FileUtils.cleanOutputDir((File)this.outputDirectory);
            for (TransformInput transformInput : transformInvocation.getInputs()) {
                for (JarInput jarInput : transformInput.getJarInputs()) {
                    this.logger.error("InstantRunDependenciesApkBuilder received a jar file " + jarInput.getFile().getAbsolutePath());
                }
                for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                    Object[] files = directoryInput.getFile().listFiles();
                    if (files == null) continue;
                    try {
                        splitsToBuild.add(new InstantRunSplitApkBuilder.DexFiles((ImmutableSet<File>)ImmutableSet.copyOf((Object[])files), directoryInput.getName()));
                    }
                    catch (Exception e) {
                        throw new TransformException((Throwable)e);
                    }
                }
            }
        }
        this.logger.debug("Invoking aapt2 serially : {} ", (Object)this.runSerially);
        splitsToBuild.forEach(split -> {
            try {
                if (this.runSerially) {
                    this.generateSplitApk((InstantRunSplitApkBuilder.DexFiles)split);
                } else {
                    this.executor.execute(() -> this.generateSplitApk((InstantRunSplitApkBuilder.DexFiles)split));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        if (!this.runSerially) {
            this.executor.waitForTasksWithQuickFail(true);
        }
    }
}

