/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.BuildSessionImpl;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.model.Version;
import com.android.builder.utils.FileCache;
import com.android.builder.utils.SynchronizedFile;
import com.android.prefs.AndroidLocation;
import com.android.utils.FileUtils;
import com.android.utils.concurrency.ReadWriteProcessLock;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.Project;

public final class BuildCacheUtils {
    public static final String BUILD_CACHE_TROUBLESHOOTING_MESSAGE = "To troubleshoot the issue or learn how to disable the build cache, go to https://d.android.com/r/tools/build-cache.html.\nIf you are unable to fix the issue, please file a bug at https://d.android.com/studio/report-bugs.html.";
    private static final long CACHE_ENTRY_DAYS_TO_LIVE = 30L;
    private static final long DAYS_BETWEEN_CACHE_EVICTION_RUNS = 1L;

    public static FileCache createBuildCacheIfEnabled(Project project, ProjectOptions projectOptions) {
        File normalizedSharedBuildCacheDir;
        if (!projectOptions.get(BooleanOption.ENABLE_BUILD_CACHE)) {
            return null;
        }
        Supplier<File> defaultBuildCacheDirSupplier = () -> {
            try {
                return new File(AndroidLocation.getFolder(), "build-cache");
            }
            catch (AndroidLocation.AndroidLocationException e) {
                throw new RuntimeException(e);
            }
        };
        FileCache buildCache = BuildCacheUtils.createBuildCache(projectOptions.get(StringOption.BUILD_CACHE_DIR), arg_0 -> ((Project)project.getRootProject()).file(arg_0), defaultBuildCacheDirSupplier, Version.ANDROID_GRADLE_PLUGIN_VERSION);
        File sharedBuildCacheDir = buildCache.getCacheDirectory().getParentFile();
        try {
            normalizedSharedBuildCacheDir = sharedBuildCacheDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        String actionGroup = BuildCacheUtils.class.getName() + "@" + normalizedSharedBuildCacheDir.getPath();
        BuildSessionImpl.getSingleton().executeOnce(actionGroup, "lockSharedBuildCacheDir", () -> {
            File lockFile = SynchronizedFile.getLockFile((File)normalizedSharedBuildCacheDir);
            ReadWriteProcessLock.Lock lock = new ReadWriteProcessLock(lockFile.toPath()).readLock();
            try {
                lock.lock();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            BuildSessionImpl.getSingleton().executeOnceWhenBuildFinished(actionGroup, "unlockSharedBuildCacheDir", () -> {
                try {
                    lock.unlock();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        });
        BuildCacheUtils.deleteOldCacheEntries(buildCache, Duration.ofDays(30L), Duration.ofDays(1L));
        return buildCache;
    }

    static FileCache createBuildCache(String buildCacheDir, Function<Object, File> pathToFileResolver, Supplier<File> defaultBuildCacheDirSupplier, String pluginVersion) {
        File sharedBuildCacheDir = buildCacheDir != null ? pathToFileResolver.apply(buildCacheDir) : defaultBuildCacheDirSupplier.get();
        return FileCache.getInstanceWithMultiProcessLocking((File)new File(sharedBuildCacheDir, pluginVersion));
    }

    static void deleteOldCacheEntries(FileCache buildCache, Duration cacheEntryLifeTime, Duration cacheEvictionInterval) {
        File markerFile = new File(buildCache.getCacheDirectory(), ".cache-eviction-marker");
        long lastEvictionTimestamp = markerFile.lastModified();
        if (lastEvictionTimestamp == 0L || Duration.ofMillis(System.currentTimeMillis() - lastEvictionTimestamp).compareTo(cacheEvictionInterval) >= 0) {
            buildCache.deleteOldCacheEntries(System.currentTimeMillis() - cacheEntryLifeTime.toMillis());
            FileUtils.mkdirs((File)markerFile.getParentFile());
            try {
                markerFile.createNewFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            markerFile.setLastModified(System.currentTimeMillis());
        }
    }
}

